<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InternalChatRepository")
 */
class InternalChat {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="text")
	 */
	private $chat_content;

	/**
	 * @ORM\Column(type="integer", nullable=true)
	 */
	private $chat_reply_to;

	/**
	 * @ORM\Column(type="boolean", nullable=true)
	 */
	private $chat_message_is_read;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="internalChats___to")
	 * @ORM\JoinColumn(nullable=true)
	 */
	private $message__to;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="internalChat___from")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $message__from;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\InternalChatGroups", inversedBy="internal_chat_messages")
	 * @ORM\JoinColumn(nullable=true)
	 */
	private $chat_group;

	/**
	 * @var \DateTime $created_at
	 *
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	private $created_at;

	/**
	 * @var \DateTime $updated_at
	 *
	 * @Gedmo\Timestampable(on="update")
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	private $updated_at;

	/**
	 * @ORM\Column(type="boolean", nullable=true)
	 */
	private $is_edited = 0;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $is_deleted = 0;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $is_sent = 1;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $is_important = 0;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	private $message_subject;


	public function __construct() {
		$this->chat_to = new ArrayCollection();
	}

	public function getId(): ?int {
		return $this->id;
	}

	public function getChatContent(): ?string {
		return $this->chat_content;
	}

	public function setChatContent( string $chat_content ): self {
		$this->chat_content = $chat_content;

		return $this;
	}

	public function getChatReplyTo(): ?int {
		return $this->chat_reply_to;
	}

	public function setChatReplyTo( ?int $chat_reply_to ): self {
		$this->chat_reply_to = $chat_reply_to;

		return $this;
	}

	public function getChatMessageIsRead(): ?bool {
		return $this->chat_message_is_read;
	}

	public function setChatMessageIsRead( ?bool $chat_message_is_read ): self {
		$this->chat_message_is_read = $chat_message_is_read;

		return $this;
	}

	public function getMessageTo(): ?User {
		return $this->message__to;
	}

	public function setMessageTo( ?User $message__to ): self {
		$this->message__to = $message__to;

		return $this;
	}

	public function getMessageFrom(): ?User {
		return $this->message__from;
	}

	public function setMessageFrom( ?User $message__from ): self {
		$this->message__from = $message__from;

		return $this;
	}

	public function getChatGroup(): ?InternalChatGroups {
		return $this->chat_group;
	}

	public function setChatGroup( ?InternalChatGroups $chat_group ): self {
		$this->chat_group = $chat_group;

		return $this;
	}

	public function getCreatedAt(): ?\DateTimeInterface {
		return $this->created_at;
	}

	public function setCreatedAt( ?\DateTimeInterface $created_at ): self {
		$this->created_at = $created_at;

		return $this;
	}

	public function getUpdatedAt(): ?\DateTimeInterface {
		return $this->updated_at;
	}

	public function setUpdatedAt( ?\DateTimeInterface $updated_at ): self {
		$this->updated_at = $updated_at;

		return $this;
	}

	public function getIsEdited(): ?bool {
		return $this->is_edited;
	}

	public function setIsEdited( ?bool $is_edited ): self {
		$this->is_edited = $is_edited;

		return $this;
	}

	public function getIsDeleted(): ?bool {
		return $this->is_deleted;
	}

	public function setIsDeleted( bool $is_deleted ): self {
		$this->is_deleted = $is_deleted;

		return $this;
	}

	public function getIsSent(): ?bool {
		return $this->is_sent;
	}

	public function setIsSent( bool $is_sent ): self {
		$this->is_sent = $is_sent;

		return $this;
	}

	public function getIsImportant(): ?bool {
		return $this->is_important;
	}

	public function setIsImportant( bool $is_important ): self {
		$this->is_important = $is_important;

		return $this;
	}

	public function getMessageSubject(): ?string {
		return $this->message_subject;
	}

	public function setMessageSubject( string $message_subject ): self {
		$this->message_subject = $message_subject;

		return $this;
	}

}
