<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassGradeRepository")
 */
class ClassGrade
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\GradeCategories", inversedBy="classGrades")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotBlank(message="Grade category reference should not be null")
     * @Assert\Valid
     */
    private $student_grade_category;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassGradeTemplate", inversedBy="classGrades")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotBlank(message="Class grade template reference should not be null")
     * @Assert\Valid
     */
    private $class_grade_template;

    /**
     * @ORM\Column(type="string", length=5)
     * @Assert\NotBlank(message="Grade name should not be null")
     * @Assert\Length(min=1, max=5, minMessage="Grade name must be at least {{ limit }} characters long", maxMessage =
     *                       "Grade name cannot be longer than {{ limit }} characters")
     */
    private $class_grade_name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Assert\Length(max=255,  maxMessage =
     *                       "Grade Description be longer than {{ limit }} characters")
     */
    private $class_grade_desc;

    /**
     * @ORM\Column(type="smallint")
     * @Assert\Length(min=1, max=6, minMessage="Marks must be at least {{ limit }} characters long", maxMessage =
     *                       "Marks cannot be longer than {{ limit }} characters")
     */
    private $class_marks_equal_or_greater_than;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="classGrades")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotBlank(message="Class reference should not be null")
     * @Assert\Valid
     */
    private $class;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStudentGradeCategory(): ?GradeCategories
    {
        return $this->student_grade_category;
    }

    public function setStudentGradeCategory(?GradeCategories $student_grade_category): self
    {
        $this->student_grade_category = $student_grade_category;

        return $this;
    }

    public function getClassGradeTemplate(): ?ClassGradeTemplate
    {
        return $this->class_grade_template;
    }

    public function setClassGradeTemplate(?ClassGradeTemplate $class_grade_template): self
    {
        $this->class_grade_template = $class_grade_template;

        return $this;
    }

    public function getClassGradeName(): ?string
    {
        return $this->class_grade_name;
    }

    public function setClassGradeName(string $class_grade_name): self
    {
        $this->class_grade_name = $class_grade_name;

        return $this;
    }

    public function getClassGradeDesc(): ?string
    {
        return $this->class_grade_desc;
    }

    public function setClassGradeDesc(?string $class_grade_desc): self
    {
        $this->class_grade_desc = $class_grade_desc;

        return $this;
    }

    public function getClassMarksEqualOrGreaterThan(): ?int
    {
        return $this->class_marks_equal_or_greater_than;
    }

    public function setClassMarksEqualOrGreaterThan(int $class_marks_equal_or_greater_than): self
    {
        $this->class_marks_equal_or_greater_than = $class_marks_equal_or_greater_than;

        return $this;
    }

    public function getClass(): ?Classes
    {
        return $this->class;
    }

    public function setClass(?Classes $class): self
    {
        $this->class = $class;

        return $this;
    }
}
