<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;


/**
 * @ORM\Entity(repositoryClass="App\Repository\AttendanceRepository")
 */
class Attendance {


	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	private $comments;

	/**
	 * @ORM\Column(type="datetime")
	 */
	private $datetime_in;

	/**
	 * @ORM\Column(type="datetime")
	 */
	private $datetime_out;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="attendances")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $user;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\AttendanceStatus", inversedBy="attendances")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $attendance_status;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\ClassSessionEnrolmentSubjects", inversedBy="attendances")
	 * @ORM\JoinColumn(nullable=true)
	 */
	private $class_session_enrolment_subject;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="attendance_did_by")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $blame_user;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\ClassSessionEnrolment", inversedBy="attendances")
	 * @ORM\JoinColumn(nullable=true)
	 */
	private $class_session_enrolment;

	/**
	 * @ORM\Column(type="smallint", nullable=true)
	 */
	private $attendance_status_type;

	/**
	 * @var \DateTime $created
	 *
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(type="datetime")
	 */
	private $created;

	/**
	 * @var \DateTime $updated
	 *
	 * @Gedmo\Timestampable(on="update")
	 * @ORM\Column(type="datetime")
	 */
	private $updated;


	public function getId(): ?int {
		return $this->id;
	}

	public function getComments(): ?string {
		return $this->comments;
	}

	public function setComments( ?string $comments ): self {
		$this->comments = $comments;

		return $this;
	}

	public function getDatetimeIn(): ?\DateTimeInterface {
		return $this->datetime_in;
	}

	public function setDatetimeIn( \DateTimeInterface $datetime_in ): self {
		$this->datetime_in = $datetime_in;

		return $this;
	}

	public function getDatetimeOut(): ?\DateTimeInterface {
		return $this->datetime_out;
	}

	public function setDatetimeOut( \DateTimeInterface $datetime_out ): self {
		$this->datetime_out = $datetime_out;

		return $this;
	}

	public function getUser(): ?User {
		return $this->user;
	}

	public function setUser( ?User $user ): self {
		$this->user = $user;

		return $this;
	}

	public function getAttendanceStatus(): ?AttendanceStatus {
		return $this->attendance_status;
	}

	public function setAttendanceStatus( ?AttendanceStatus $attendance_status ): self {
		$this->attendance_status = $attendance_status;

		return $this;
	}

	public function getClassSessionEnrolmentSubject(): ?ClassSessionEnrolmentSubjects {
		return $this->class_session_enrolment_subject;
	}

	public function setClassSessionEnrolmentSubject( ?ClassSessionEnrolmentSubjects $class_session_enrolment_subject ): self {
		$this->class_session_enrolment_subject = $class_session_enrolment_subject;

		return $this;
	}

	public function getBlameUser(): ?User {
		return $this->blame_user;
	}

	public function setBlameUser( ?User $blame_user ): self {
		$this->blame_user = $blame_user;

		return $this;
	}

	public function getClassSessionEnrolment(): ?ClassSessionEnrolment {
		return $this->class_session_enrolment;
	}

	public function setClassSessionEnrolment( ?ClassSessionEnrolment $class_session_enrolment ): self {
		$this->class_session_enrolment = $class_session_enrolment;

		return $this;
	}

	public function getAttendanceStatusType(): ?int {
		return $this->attendance_status_type;
	}

	public function setAttendanceStatusType( ?int $attendance_status_type ): self {
		$this->attendance_status_type = $attendance_status_type;

		return $this;
	}

	/**
	 * @return \DateTime
	 */
	public function getCreated(): \DateTime {
		return $this->created;
	}

	/**
	 * @param \DateTime $created
	 */
	public function setCreated( \DateTime $created ): void {
		$this->created = $created;
	}

	/**
	 * @return \DateTime
	 */
	public function getUpdated(): \DateTime {
		return $this->updated;
	}

	/**
	 * @param \DateTime $updated
	 */
	public function setUpdated( \DateTime $updated ): void {
		$this->updated = $updated;
	}
}
