<?php

namespace App\Controller;

use App\Entity\ClassFeeSchedule;
use App\Entity\ClassSessionEnrolment;
use App\Entity\ClassSessionEnrolmentFeeSchedule;
use App\Entity\Guardian;
use App\Entity\Tokens;
use App\Entity\User;
use App\Repository\ClassesRepository;
use App\Repository\ClassFeeScheduleRepository;
use App\Repository\ClassSessionEnrolmentFeeScheduleRepository;
use App\Repository\ClassSessionEnrolmentRepository;
use App\Repository\CustomFieldSectionsRepository;
use App\Repository\CustomFieldsRepository;
use App\Repository\GuardianRepository;
use App\Repository\StudentFeeRepository;
use App\Repository\UserRepository;
use App\Service\accounts\InvoiceService;
use App\Service\AppSettings;
use App\Service\CustomTokenManager;
use App\Service\Fees\FeeSchedulerService;
use App\Service\Guardian\GuardianService;
use App\Service\StudentClasses;
use App\Service\SubjectService;
use App\Service\DefaultFunction;
use App\Service\UserService;
use Doctrine\ORM\EntityManagerInterface;
use Nzo\UrlEncryptorBundle\Annotations\ParamDecryptor;
use Nzo\UrlEncryptorBundle\UrlEncryptor\UrlEncryptor;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Security\Http\Util\TargetPathTrait;
use Symfony\Contracts\Translation\TranslatorInterface;
use Symfony\Contracts\Translation\TranslatorTrait;


/**
 *
 * @IsGranted("ROLE_USER")
 * */
class UserController extends AbstractController
{

    /**
     * @var UserRepository
     */
    private $user_repository;
    /**
     * @var CustomFieldsRepository
     */
    private $custom_fields_repository;
    /**
     * @var CustomFieldSectionsRepository
     */
    private $custom_field_sections_repository;
    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var AppSettings
     */
    private $app_settings;
    /**
     * @var Security
     */
    private $security;
    /**
     * @var ClassesRepository
     */
    private $classes_repository;
    /**
     * @var SubjectService
     */
    private $subject_service;
    /**
     * @var StudentClasses
     */
    private $student_classes;
    /**
     * @var StudentFeeRepository
     */
    private $student_fee_repository;
    /**
     * @var FeeSchedulerService
     */
    private $fee_scheduler_service;
    /**
     * @var ClassSessionEnrolmentFeeScheduleRepository
     */
    private $class_session_enrolment_fee_schedule_repository;
    /**
     * @var ClassFeeScheduleRepository
     */
    private $class_fee_schedule_repository;
    /**
     * @var GuardianRepository
     */
    private $guardian_repository;
    /**
     * @var UrlEncryptor
     */
    private $url_encryptor;
    /**
     * @var ClassSessionEnrolmentRepository
     */
    private $class_session_enrolment_repository;
    /**
     * @var InvoiceService
     */
    private $invoice_service;
    /**
     * @var GuardianService
     */
    private $guardianService;
    /**
     * @var TranslatorInterface
     */
    private $translator;


    public function __construct(
        InvoiceService $invoice_service,
        ClassSessionEnrolmentRepository $class_session_enrolment_repository,
        UrlEncryptor $url_encryptor,
        GuardianRepository $guardian_repository,
        FeeSchedulerService $fee_scheduler_service,
        ClassSessionEnrolmentFeeScheduleRepository $class_session_enrolment_fee_schedule_repository,
        ClassFeeScheduleRepository $class_fee_schedule_repository,
        UserRepository $user_repository,
        StudentFeeRepository $student_fee_repository,
        CustomFieldsRepository $custom_fields_repository,
        CustomFieldSectionsRepository $custom_field_sections_repository,
        DefaultFunction $default_function,
        AppSettings $app_settings,
        Security $security,
        ClassesRepository $classes_repository,
        SubjectService $subject_service,
        StudentClasses $student_classes,
        GuardianService $guardianService,
        TranslatorInterface $translator
    ) {
        $this->user_repository = $user_repository;
        $this->custom_fields_repository = $custom_fields_repository;
        $this->custom_field_sections_repository = $custom_field_sections_repository;
        $this->default_function = $default_function;
        $this->app_settings = $app_settings;
        $this->security = $security;
        $this->classes_repository = $classes_repository;
        $this->subject_service = $subject_service;
        $this->student_classes = $student_classes;
        $this->student_fee_repository = $student_fee_repository;
        $this->fee_scheduler_service = $fee_scheduler_service;
        $this->class_session_enrolment_fee_schedule_repository = $class_session_enrolment_fee_schedule_repository;
        $this->class_fee_schedule_repository = $class_fee_schedule_repository;
        $this->guardian_repository = $guardian_repository;
        $this->url_encryptor = $url_encryptor;
        $this->class_session_enrolment_repository = $class_session_enrolment_repository;
        $this->invoice_service = $invoice_service;
        $this->guardianService = $guardianService;
        $this->translator = $translator;
    }

    /**
     * @Route("{_locale}/user/my-profile", name="my_profile")
     * PURPOSE: This method shows the list of custom and the list of section of custom fields.
     */
    public function index()
    {
        if ($this->getUser() instanceof Guardian) {
            $returningValue = $this->guardianProfile($this->getUser());
        } else {
            $returningValue = $this->server_user_info($this->getUser(), $this->getUser()->getCategory());
        }

        return $returningValue;

    }

    /**
     * @ParamDecryptor(params={"id"})
     * @Route("{_locale}/user/profile/{id}/{userFrom}", name="users_profile", requirements={"id","\d+"} ,
     *                                                  defaults={"userFrom"="userTable"})
     * @param GuardianService $guardianService
     * @param UserService $userService
     * @param                 $id
     * @param                 $userFrom
     *
     * @return Response
     */
    public function otherUserProfile(
        GuardianService $guardianService,
        UserService $userService,
        $id = null,
        $userFrom = null
    ) {
        if ($userFrom == 'userTable') {
            $user = $userService->get__user($id);
            ## fetching user from user table.
            if (($user instanceof User) && ($this->isGranted('ROLE_STUDENT_MANAGER') || $this->isGranted(
                        'ROLE_GUARDIAN'
                    ))) {
                return $this->server_user_info($user, $user->getCategory());
            } else {
                return new Response($this->translator->trans('You Must have Student Manager or Guardian ROLE'), 403);
            }
        } else {
            ## fetching user from guardian table.
            $guardian = $guardianService->getGuardian($id);
            if (($guardian instanceof Guardian) && ($this->isGranted('ROLE_GUARDIAN_MANAGER'))) {
                return $this->guardianProfile($guardian);
            } else {
                return new Response($this->translator->trans('You Must have Guardian Manager ROLE'), 403);
            }
        }

    }

    /**
     * @IsGranted("ROLE_STUDENT_MANAGER")
     * @Route("{_locale}/user/add-student", name="add_new_user")
     */
    public function add_new_student()
    {
        return $this->render(
            'Users/addUser.html.twig',
            [
                'guardian' => $this->guardian_repository->findAll(),
                'uniqueEmail' => uniqid('email_').'@fekara.net',
            ]
        );
    }

    /**
     * @IsGranted("ROLE_ADMIN")
     * @Route("{_locale}/user/add-teacher", name="add_new_teacher")
     */
    public function add_new_teacher()
    {
        return $this->server_user_info(new User(), 't');
    }

    /**
     * @IsGranted("ROLE_ADMIN")
     * @Route("{_locale}/user/add-admin-or-employee", name="add_new_admin_or_employee")
     */
    public function add_new_admin_or_employee()
    {
        return $this->server_user_info(new User(), 'a');
    }

    ## serve user information with according to the category
    private function server_user_info(User $User, string $category)
    {

        $bag = new ParameterBag();
        $bag->set('columns', 'class_session_enrolment.id');
        $bag->set('result_in_array', true);

        return $this->render(
            'Users/index.html.twig',
            [
                ## I'm using because same template is used in different method so, there codes is not changed.
                'userDetails' => $User,
                'customFields' => $this->custom_fields_repository->getUserBasedCustomField(
                    SecurityController::fieldsType[$category]
                ),
                'category' => $category,
                'activeClassesWithSession' => $this->classes_repository->getClassesOfActiveSession(),
                ## getting enrolled classes.
                'enrolledClasses' => !empty($User->getId()) ? $this->subject_service->get__enrolledSubjects(
                    $User->getId()
                ) : [],
                'classes' => $this->classes_repository->findAll(),
                'stu_fee' => $this->student_fee_repository->findAll(),
                'classFee' => null,
                'specialFeeSchedule' => $this->class_session_enrolment_fee_schedule_repository->get_special_fee_for_student(
                    $User->getId(),
                    $bag
                ),
            ]
        );

    }

    /**
     * @Route("{_locale}/users/requestHandler/remote-request/{query}", name="requestHandler")
     * @param Request $request
     * @param UserService $user_service
     * @param null $query
     *
     * @return JsonResponse
     */
    public function ajaxHandler(Request $request, UserService $user_service, $query = null)
    {

        ## if user is not logged in the redirect th e use rto login page.
        $response = 'OK';
        if (empty($query)) {
            ## get the query variable from the get request.
            $query = $request->query->get('query');
        }

        switch ($query) {
            case 'activeDeactiveUser':
                ## active & de-active request.
                $response = $user_service->activeDeactiveUser($request->request);
                break;
            case 'profileUpdate':
                ## update user profile's personal information.
                ## we've using this method to update user profile or create a new user as well.

                if ($request->request->get('category') == 'g') {
                    ## update guardian profile
                    $response = $this->guardianService->updateProfile(
                        $request->request,
                        $request->files,
                        $user_service
                    );
                } else {
                    ## user normal user profile.
                    $response = $user_service->updateProfile($request->request, $request->files);
                }

                if (is_string($response) && substr($response, 0, 2) === 'OK') {
                    $response = 'OK'.$this->generateUrl(
                            'users_profile',
                            ['id' => $this->url_encryptor->encrypt(substr($response, 2))]
                        );
                }
                break;
            case 'updatePassword':
                ## update password.
                $response = $user_service->updateUserPassword($request->request);
                break;
            case 'updateAccountInfo':
                ## update account info, like: active & deactivate user.
                $response = $user_service->updateAccountInfo($request->request);
                break;
            case 'updateCustomFieldData':
                ## update custom field data
                $response = $user_service->updateOtherInfo($request);
                break;
            case 'lockField':
                ## lock some fields
                $response = $user_service->lockField($request->request);
                break;
            case 'deleteUser':
                ## delete user
                $response = $user_service->deleteUser($request->request);
                break;
            case 'getTheSubjectsOfClass':
                ## get the subjects of the classes.
                $response = $this->subject_service->get__subjectsFromClassSubjectTable($request->request);
                $response = 'escape__fromErro_'.$this->renderView(
                        'subject/subjectSelectionDropdown.html.twig',
                        [
                            'classname' => $request->request->get('class_name'),
                            'class_reference' => $request->request->get('referece_'),
                            'subjects' => $response,
                            'enable_removal' => (bool)$request->request->get('removal', false),
                            'select__class' => $request->request->get('use___classes', ''),
                            'select__name_fr_c' => $request->request->get('select__name', 'subject'),
                        ]
                    );
                break;
            case 'enrollmentSubjectAndClass':
                dump($request->request);
                ## student enrolment in subject and class.
                $response = $this->student_classes->student___enrollmentInClasses(
                    $request->request,
                    $this->invoice_service
                );
                break;
            case 'studentSpecialFeeScheduler':
                ## save fee for the special student
                $response = $this->fee_scheduler_service->save_class_fee_schedule_bulk($request->request);
                ## purify the response
                $response = $this->default_function->purify_success_error_response_in_bulk_operation($response);
                break;
        }

        return new JsonResponse($response, 200);
    }

    /**
     * @Route("{_locale}/guardian/profile/", name="gurdian_profile")
     * @param Guardian $guardian
     *
     * @return Response
     */
    private function guardianProfile(Guardian $guardian)
    {
        return $this->render(
            'Users/index.html.twig',
            [
                'userDetails' => $guardian,
                'customFields' => $this->custom_fields_repository->getUserBasedCustomField(
                    SecurityController::fieldsType[$guardian->getCategory()]
                ),
                'category' => $guardian->getCategory(),
            ]
        );
    }

    /**
     *  API Controllers
     * @Route("api/{_locale}/user/my-profile", name="api_my_profile")
     * */
    public function getUserProfile()
    {
        dd('ff');
    }

}


