<?php


namespace App\Service\Virtucal;


use Firebase\JWT\JWT;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Contracts\HttpClient\HttpClientInterface;

trait ZoomJWT
{
    /**
     * @var HttpClientInterface
     */
    private $httpClient;

    /**
     * ZoomJWT constructor.
     * @param HttpClientInterface $httpClient
     */
    public function __construct(HttpClientInterface $httpClient)
    {
        $this->httpClient = $httpClient;
    }



    /**
     * Encode a string with URL-safe Base64.
     *
     * @param string $input The string you want encoded
     *
     * @return string The base64 encode of what you passed in
     */
    private function urlsafeB64Encode($input)
    {
        return \str_replace('=', '', \strtr(\base64_encode($input), '+/', '-_'));
    }

    private function jsonEncode($input)
    {
        $json = \json_encode($input);
        if ($errno = \json_last_error()) {
            static::handleJsonError($errno);
        } elseif ($json === 'null' && $input !== null) {
            throw new DomainException('Null result with non-null input');
        }
        return $json;
    }


    private function generateZoomToken()
    {
        $key = 'nWPF4vdITv2utRmBIUqgMg';
        $secret = 'r7snTAVGoaXSzDf8wbqo9sVUiYIRIN2HIVHT';
        $payload = [
            'iss' => $key,
            'exp' => strtotime('+1 minute'),
        ];

        // JWT::encode($payload, $secret);


        $alg = 'HS256';
        $header = array('typ' => 'JWT', 'alg' => $alg);

        if (isset($head) && \is_array($head)) {
            $header = \array_merge($head, $header);
        }

        $segments = array();
        $segments[] = $this->urlsafeB64Encode($this->jsonEncode($header));
        $segments[] = $this->urlsafeB64Encode($this->jsonEncode($payload));
        $signing_input = \implode('.', $segments);

        //hash_hmac SHA256
        $signature = hash_hmac('SHA256', $signing_input, $key, true);    
        $segments[] = $this->urlsafeB64Encode($signature);

        return \implode('.', $segments);
    }

    private function retrieveZoomUrl()
    {

        return 'https://api.zoom.us/v2/';
    }

    private function zoomRequest()
    {
        $jwt = $this->generateZoomToken();

        $jwt = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJuV1BGNHZkSVR2MnV0Um1CSVVxZ01nIiwiZXhwIjoxNjA3ODI5OTQ1fQ.bJj9IBK6PKQuUtsQ3QK0-nTdmZbSi7fUg-mR3KMMIUQ";
        return
            [
                'authorization' => 'Bearer '.$jwt,
                'content-type' => 'application/json',
            ];
    }

    public function zoomGet(string $path, array $query = [])
    {
        $url = $this->retrieveZoomUrl();
        $request = $this->zoomRequest();

        return $request->get($url.$path, $query);
    }

    public function zoomPost(string $path, array $body = [])
    {
        $url = $this->retrieveZoomUrl();

        return $this->httpClient->request(
            'POST',
            $url,
            [
                'headers' => $this->zoomRequest(),
            ]
        );


//        $request = $this->zoomRequest();
//        return $request->post($url.$path, $body);
    }

    public function zoomPatch(string $path, array $body = [])
    {
        $url = $this->retrieveZoomUrl();
        $request = $this->zoomRequest();

        return $request->patch($url.$path, $body);
    }

    public function zoomDelete(string $path, array $body = [])
    {
        $url = $this->retrieveZoomUrl();
        $request = $this->zoomRequest();

        return $request->delete($url.$path, $body);
    }

    public function toZoomTimeFormat(string $dateTime)
    {
        try {
            $date = new \DateTime($dateTime);

            return $date->format('Y-m-d\TH:i:s');
        } catch (\Exception $e) {

            return '';
        }
    }

    public function toUnixTimeStamp(string $dateTime, string $timezone)
    {
        try {
            $date = new \DateTime($dateTime, new \DateTimeZone($timezone));

            return $date->getTimestamp();
        } catch (\Exception $e) {
            return '';
        }
    }
}
