<?php


namespace App\Service\ScheduleMessagesService;


use App\Controller\FileServerController;
use App\Service\DefaultFunction;
use App\Service\FileManagment;
use App\Twig\AppExtension;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Snappy\Pdf;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\Routing\RouterInterface;
use function Symfony\Component\DependencyInjection\Loader\Configurator\service_locator;

class Files
{

    /**
     * @var DefaultFunction
     */
    private $defaultFunction;
    /**
     * @var Pdf
     */
    private $pdf;
    /**
     * @var ParameterBagInterface
     */
    private $parameter_bag;
    /**
     * @var FileManagment
     */
    private $fileManagement;
    const folderName = 'reports';
    const MessageSchedule = 'message_schedule';

    /**
     * @var FileServerController
     */
    private $fileServerController;
    /**
     * @var RouterInterface
     */
    private $router;
    /**
     * @var AppExtension
     */
    private $appExtension;

    public function __construct(
        FileManagment $fileManagement,
        DefaultFunction $defaultFunction,
        Pdf $pdf,
        AppExtension $appExtension
    ) {
        $this->defaultFunction = $defaultFunction;
        $this->pdf = $pdf;
        $this->fileManagement = $fileManagement;
        ## create pdf reports files.
        $this->createFolders();
        $this->appExtension = $appExtension;
    }


    /**
     * PURPOSE: Create Folders
     */
    public function createFolders()
    {
        $ar = [];
        $ar[] = $this->getDownloadPath();
        $ar[] = $this->getScheduleMessageAttachmentFolder();
        foreach ($ar as $key => $value) {
            if (!is_dir($value)) {
                mkdir($value);
            }
        }

    }

    /**
     * Get the path of schedule folder
     * */
    public function getScheduleMessageAttachmentFolder()
    {
        return $this->fileManagement->get_base_path(true).self::MessageSchedule;
    }

    /**
     * @return string
     *  PURPOSE: Get the path where we will download all reports so we can attached with them
     */
    public function getDownloadPath()
    {
        return $this->fileManagement->get_base_path(true).self::folderName;
    }

    /**
     * @param $targetedUrl
     *  PURPOSE: Download the PDF File
     */
    public function downloadPdfFile($targetedUrl)
    {
        try {
            $filename = random_int(1, 1000000).'_report.pdf';
        } catch (\Exception $e) {
            $filename = 'report.pdf';
        }

        $filename = $this->getDownloadPath().DIRECTORY_SEPARATOR.$filename;

        return $this->pdf->generate($targetedUrl, $filename, [], true);
    }

    /**
     * @param \Symfony\Component\HttpFoundation\ParameterBag $parameterBag
     *
     * @return array
     *  PURPOSE: Get the PDF File
     */
    public function getDownloadedFiles(\Symfony\Component\HttpFoundation\ParameterBag $parameterBag = null)
    {
        $fileArray = [
            'public' => true,
            'path' => self::folderName,
            'finderOrder' => 'changeTime',
            'need_only_file_relative_path' => true,
        ];

        $listOfFiles = $this->fileManagement->getUploadedFile($fileArray);
        $returnValue = $listOfFiles;

        ## filter the files.
        if ($parameterBag instanceof \Symfony\Component\HttpFoundation\ParameterBag) {
            $returnValue = [];

            ## get the last modified file
            if ($parameterBag->get('lastOne')) {
                $lastFile = $listOfFiles[array_key_last($listOfFiles)];
            }

            ## get the file url
            if ($parameterBag->get('lastOne') && $parameterBag->get('needURL')) {
                if ($parameterBag->get('needPath')) {
                    $returnValue['path'] = $lastFile;
                }
                $returnValue['url'] = $this->defaultFunction->generateURL(
                    'secure_file_server',
                    ['filePath' => $this->defaultFunction->encoder_decoder($lastFile, true)]
                );
            }
        }

        return $returnValue;
    }

    /**
     * @param $filePath
     *  PURPOSE: Copy downloaded file to the Message Schedule folder
     * @param $targetFolder
     */
    public function moveFileToScheduleMessage($filePath, $targetFolder)
    {
        $absolutePath = $this->fileManagement->getAbsolutePathOfFile($filePath);
        $targetAbsPath = $this->getScheduleMessageAttachmentFolder(
            ).DIRECTORY_SEPARATOR.$targetFolder.DIRECTORY_SEPARATOR;

        try {
            if (!is_dir($targetAbsPath)) {
                mkdir($targetAbsPath);
            }
        } catch (\Exception $exception) {
        }

        $targetAbsPath = $targetAbsPath.basename($filePath);
        copy($absolutePath, $targetAbsPath);
    }

    /**
     * Get the file from the Schedule Message folder
     * */
    public function getMessageScheduleAttachment(int $scheduleMessageId)
    {
        $args = [
            'absPath' => $this->getScheduleMessageAttachmentFolder().DIRECTORY_SEPARATOR.$scheduleMessageId,
        ];

        return $this->fileManagement->getUploadedFile($args);
    }

}
