<?php

namespace App\Repository;

use App\Entity\ClassSessionEnrolment;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\QueryBuilder;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBag;

/**
 * @method ClassSessionEnrolment|null find($id, $lockMode = null, $lockVersion = null)
 * @method ClassSessionEnrolment|null findOneBy(array $criteria, array $orderBy = null)
 * @method ClassSessionEnrolment[]    findAll()
 * @method ClassSessionEnrolment[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ClassSessionEnrolmentRepository extends ServiceEntityRepository
{

    /**
     * @var RegistryInterface
     */
    private $registry;

    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ClassSessionEnrolment::class);
        $this->registry = $registry;
    }


    ## search in the class session enrolment
    public function search(\Symfony\Component\HttpFoundation\ParameterBag $bag)
    {
        $queryBuilder = $this->createQueryBuilder('classSessionEnrolment');
        $queryBuilder->leftJoin(
            'classSessionEnrolment.classSessionEnrolmentSubjects',
            'classSessionEnrolmentSubjects'
        )->addSelect('classSessionEnrolmentSubjects');
        //$queryBuilder->leftJoin('classSessionEnrolment.user', 'users');

        ## active class session enrolment
        if ($bag->get('ClassEnrolmentDeleted') == 0 || $bag->get('ClassEnrolmentDeleted') == 1) {
            $queryBuilder->andWhere('classSessionEnrolment.is_deleted = :deletedRef')->setParameter(
                'deletedRef',
                $bag->get('ClassEnrolmentDeleted')
            );
        }

        ## search class relevant
        if (!empty($bag->get('class'))) {
            $queryBuilder->andWhere('classSessionEnrolment.class_session = :classSessionRef')->setParameter(
                'classSessionRef',
                $bag->get('class')
            );
        }
        ## search subject relevant
        if (!empty($bag->get('subject'))) {
            $queryBuilder->andWhere('classSessionEnrolmentSubjects.classSubject = :subjectRef')->setParameter(
                'subjectRef',
                $bag->get('subject')
            );
        }
        ## active class session enrolment subject
        if ($bag->get('ClassEnrolmentSubjectDeleted') == 0 || $bag->get('ClassEnrolmentSubjectDeleted') == 1) {
            $queryBuilder->andWhere('classSessionEnrolmentSubjects.is_deleted = :deletedSubjectRef')->setParameter(
                'deletedSubjectRef',
                $bag->get('ClassEnrolmentSubjectDeleted')
            );
        }


        return $queryBuilder->getQuery()->getResult();
    }

    public function getEnrolledClassesOfUsers(array $users)
    {
        $queryBuilder = $this->createQueryBuilder('classSessionEnrolment');
        ## userArray
        $queryBuilder->add(
            'where',
            $queryBuilder->expr()->in('classSessionEnrolment.user_id', $users)
        );
        $queryBuilder->andWhere('classSessionEnrolment.is_deleted = :isdel')->setParameter('isdel', 0);

        return $queryBuilder->getQuery()->getResult();
    }

    ## get the enrolled subject of specific user.
    public function get__enrolledSubjects(int $user_ref)
    {
        //return $this->createQueryBuilder()
    }

    ## get the list of students which are enrolled in the class.
    public function get__EntrolledStudentList(int $classId, $resultInArray = false)
    {
        $queryBuilder = $this->createQueryBuilder('class_session_enrolment')
            ->select('class_session_enrolment')
            ->leftJoin('class_session_enrolment.user_id', 'user')
            ->addSelect('user')
            ->where('class_session_enrolment.class_session = :classId')
            ->setParameter('classId', $classId)
            ->getQuery();


        if ($resultInArray) {
            $queryBuilder = $queryBuilder->getArrayResult();
        } else {
            $queryBuilder = $queryBuilder->getResult();
        }

        return $queryBuilder;

    }

    ## get__EntrolledStudentList logic
    public function get__EntrolledStudentList__logic(QueryBuilder $query_builder, $classId): QueryBuilder
    {
        return $query_builder->select('class_session_enrolment')
            ->leftJoin('class_session_enrolment.user_id', 'user')
            ->addSelect('user')
            ->where('class_session_enrolment.class_session = :classId')
            ->setParameter('classId', $classId);
    }

    ## getting special fee for the student if exits.
    public function get_special_fee_for_student(
        int $UserReference,
        \Symfony\Component\HttpFoundation\ParameterBag $requirements
    ) {
        $queryBuilder = $this->createQueryBuilder('class_session_enrolment');

        ## select specific column
        if (!empty($requirements->get('columns'))) {
            $queryBuilder->select('class_session_enrolment.id');
        }

        $queryBuilder = $queryBuilder->where('class_session_enrolment.user_id = :user')
            ->setParameter('user', $UserReference)
            ->getQuery();

        if ($requirements->get('result_in_array', false)) {
            $queryBuilder = $queryBuilder->getScalarResult();
        } else {
            $queryBuilder = $queryBuilder->getResult();
        }

        return $queryBuilder;
    }

    public function getActiveClassOfActiveSession__QueryBuilder()
    {
        return $this->createQueryBuilder('class_session_enrolment')
            ->leftJoin('class_session_enrolment.class_session', 'class_session')
            ->andwhere('class_session.active = 1')
            ->leftJoin('class_session.session', 'session')
            ->andWhere('session.active = 1');
    }

    ## get no of students enrolled in a active classes of active session.
    public function get__studentsOfActiveClassesOfActiveSession()
    {
        return $this->getActiveClassOfActiveSession__QueryBuilder()
            ->groupBy('class_session_enrolment.user_id')
            ->addGroupBy('class_session_enrolment.class_session')
            ->getQuery()
            ->getResult();
    }

    ## Check user has enrolled in the same class or not.
    public function duplicationCheck(\Symfony\Component\HttpFoundation\ParameterBag $CheckingBag)
    {
        $queryBuilder = $this->createQueryBuilder('classSessionEnrolment')->andWhere(
            'classSessionEnrolment.is_deleted = false'
        );

        if (!empty($CheckingBag->get('user_id'))) {
            $queryBuilder->andWhere('classSessionEnrolment.user_id = :userRef')->setParameter(
                'userRef',
                $CheckingBag->get('user_id')
            );
        }

        if (!empty($CheckingBag->get('session_id'))) {
            $queryBuilder->andWhere('classSessionEnrolment.class_session = :sessionRef')->setParameter(
                'sessionRef',
                $CheckingBag->get('session_id')
            );
        }

        return $queryBuilder->getQuery()->getResult();
    }

    /**
     * ATTENDANCE
     *
     * */

    ## load attendances
    ## column -- attendance_type 0 mean class based attendance and 1 for the subject based attendance.
    public function load____attendances(\Symfony\Component\HttpFoundation\ParameterBag $bag)
    {

        $connection = $this->getEntityManager()->getConnection();
        $in_date_sub_query = null;
        $class_session_enrolement_subject_sub_query = null;
        $parameters_to_add = [];

        ## if user want to filter their with respect to check_in_date
        if (!empty($bag->get('in_date'))) {


            try {
                $in__date = new \DateTime($bag->get('in_date'));
                $in__date = $in__date->format('Y-m-d').'%';

                ## sub query to filter out the date
                $in_date_sub_query = $connection->createQueryBuilder()
                    ->select('*,id as attendance_ref')
                    ->from('attendance')
                    ->andWhere('attendance.datetime_in LIKE :in_date');
                ## add variable value in the array
                $parameters_to_add['in_date'] = $in__date;
            } catch (\Exception $exception) {
                return $exception->getMessage();
            }

        }

        ## filtering attendance type. - ( subject wise attendance or non-subject wise attendance.)
        $parameters_to_add['attendance_type'] = 0;
        if (!empty($bag->get('active__classes'))) {
            $parameters_to_add['class_session_id'] = $bag->get('active__classes');
        }

        ## sub query to get the attendance status
        $attendance_status_sub_query = $connection->createQueryBuilder()
            ->select('*,id as attendance_status_id, name as attendance_status_name')
            ->from('attendance_status');

        ## get the user details which is attached in the class enrolement.
        $query____ = $connection->createQueryBuilder()
            ->select('*,c_s.id as class_session_enrolment_ref')
            ->from(
                'class_session_enrolment',
                'c_s'
            )// search by attendance type, Means, Class wise attendance or Subject wise attendance
            ->andWhere('c_s.attendance_type = :attendance_type')// matching class wise attendance
            ->andWhere('c_s.class_session_id = :class_session_id')->andWhere('c_s.is_deleted = 0');

        ## filter class results.
        if (!empty($bag->get('subject_wise_classes') && empty($bag->get('subject')))) {
            $query____ = $query____->andWhere('c_s.class_session_id = :class_session_id');
            ## filter subject wise and non subject wise classes.

            ## add variable value in the array
            $parameters_to_add['class_session_id'] = $bag->get('subject_wise_classes');

        }

        ## join with the user's table to the get user's info
        $query____->leftJoin('c_s', 'user', 'user', 'c_s.user_id_id = user.id');

        ## to the get the attendance status.
        $query____->leftJoin(
            'attendance',
            sprintf('(%s)', $attendance_status_sub_query),
            'attendance_status',
            'attendance.attendance_status_id = attendance_status.id'
        );

        ## add sub query if found.
        if (!empty($in_date_sub_query)) {
            $query____->leftJoin(
                'c_s',
                sprintf('(%s)', $in_date_sub_query->getSQL()),
                'attendance',
                'c_s.id = attendance.class_session_enrolment_id'
            );
        }

        ## get the list of the user on base of subjects and class.
        if (!empty($bag->get('subject'))) {
            // subject based attendance check
            $class_session_enrolement_subject_sub_query = $connection->createQueryBuilder()
                ->select('*,id as class_session_enrolment_subjects_id')
                ->from('class_session_enrolment_subjects')
                ->andWhere('class_session_enrolment_subjects.class_subject_id = :subject_ref');

            $query____->rightJoin(
                'c_s',
                sprintf('(%s)', $class_session_enrolement_subject_sub_query),
                'class_session_enrolment_subjects',
                'class_session_enrolment_subjects.class_session_entrolment_id = c_s.id'
            );
            ## add variable value in the array
            $parameters_to_add['subject_ref'] = $bag->get('subject');
            ## subject wise attendance.
            $parameters_to_add['attendance_type'] = 1;


//            $query____->where('attendance.class_session_enrolment_subject_id = :classSessionEnrolmentSubjectID');
//            $parameters_to_add['classSessionEnrolmentSubjectID'] = $bag->get('subject');
        }


        ## set query parameters.
        foreach ($parameters_to_add as $key => $value) {
            $query____->setParameter($key, $value);
        }


        $query____->getSQL();

        $s = $query____->execute();

        return $s->fetchAll();

    }


    /**
     * @param int $classRef
     * @param \Symfony\Component\HttpFoundation\ParameterBag|null $bag
     * @param AttendanceRepository $attendanceRepository
     * @return mixed
     *
     * ## get attendance report of class.
     */
    public function getAttendanceOfClass(
        int $classRef,
        AttendanceRepository $attendanceRepository,
        \Symfony\Component\HttpFoundation\ParameterBag $bag = null
    ) {

        $queryBuilder = $this->createQueryBuilder('class_session_enrolment')
            ->leftJoin('class_session_enrolment.attendances', 'attendance')
            ->addSelect('attendance')
            ->leftJoin('attendance.attendance_status', 'attendance_status')
            ->addSelect('attendance_status')
            ->leftJoin('class_session_enrolment.user_id', 'users')->addSelect('users')
            ->where('class_session_enrolment.class_session= :ref')
            ->setParameter('ref', $classRef);

        ## search attendance of class by date range
        $queryBuilder = $attendanceRepository->getAttendanceRangeQuery($bag, $queryBuilder);
        $queryBuilder->orderBy('attendance.datetime_in', 'ASC');

        return $queryBuilder->getQuery()->getResult();

    }

    ## List of all classes
    public function get__UniqueEnrolledClassesListInActiveSessionAndClasses(bool $InArray = false)
    {
        $queryBuilder = $this->getActiveClassOfActiveSession__QueryBuilder()
            ->distinct(true)
            ->select('IDENTITY(class_session_enrolment.class_session) as class_session_id')
            ->getQuery();

        if ($InArray) {
            $classSessionEnrolmentInArrayForm = $queryBuilder->getArrayResult();
        } else {
            $classSessionEnrolmentInArrayForm = $queryBuilder->getResult();
        }

        return $classSessionEnrolmentInArrayForm;

    }

    /**
     * @param bool $InArray
     *
     * @return array|\Doctrine\ORM\Query|QueryBuilder|mixed | array
     */
    public function get__UniqueEnrolledClassesListInActiveSessionAndClasses__Reference(bool $InArray = false)
    {
        $response = [];
        $classSessionEnrolmentInArrayForm = $this->get__UniqueEnrolledClassesListInActiveSessionAndClasses(true);
        $classSessionEnrolmentInArrayForm = array_column($classSessionEnrolmentInArrayForm, 'class_session_id');
        $classSessionEnrolmentInStringForm = implode(',', $classSessionEnrolmentInArrayForm);

        if (!empty($classSessionEnrolmentInStringForm)) {
            $queryBuilder__two = $this->createQueryBuilder('class_session_enrolment');
            $queryBuilder__two = $queryBuilder__two->add(
                'where',
                $queryBuilder__two->expr()
                    ->in('class_session_enrolment.class_session', $classSessionEnrolmentInStringForm)
            )
                ->getQuery();

            if ($InArray) {
                $queryBuilder__two = $queryBuilder__two->getArrayResult();
            } else {
                $queryBuilder__two = $queryBuilder__two->getResult();
            }

            $response = $queryBuilder__two;

        }

        return $response;

    }

    public function getLastEnrolledClassOUser($studentId)
    {
        return $this->createQueryBuilder('class_session_enrolment')->where(
            'class_session_enrolment.user_id = :studentId'
        )->setParameter('studentId', $studentId)->orderBy('class_session_enrolment.id', 'DESC')->setMaxResults(
            1
        )->getQuery()->getResult();
    }

}
