<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\VirtualClassRoomRepository")
 */
class VirtualClassRoom
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\OneToOne(targetEntity="App\Entity\Classes", inversedBy="virtualClassRoom")
     * @ORM\JoinColumn(nullable=false)
     */
    private $classes;

    /**
     * @ORM\OneToOne(targetEntity="App\Entity\ClassSubject", inversedBy="virtualClassRoom")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class_subjects;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $vcr_agenda;

    /**
     * @ORM\Column(type="datetime")
     */
    private $vcr_start_time;

    /**
     * @ORM\Column(type="string", length=70)
     */
    private $vcr_name;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $zoom_start_meeting_link;

    /**
     * @ORM\Column(type="text")
     */
    private $zoom_meeting_joinging_link;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $zoom_meeting_password;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $zoom_session_id;

    /**
     * @ORM\Column(type="text")
     */
    private $zoom_meeting_object;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getClasses(): ?Classes
    {
        return $this->classes;
    }

    public function setClasses(Classes $classes): self
    {
        $this->classes = $classes;

        return $this;
    }

    public function getClassSubjects(): ?ClassSubject
    {
        return $this->class_subjects;
    }

    public function setClassSubjects(ClassSubject $class_subjects): self
    {
        $this->class_subjects = $class_subjects;

        return $this;
    }

    public function getVcrAgenda(): ?string
    {
        return $this->vcr_agenda;
    }

    public function setVcrAgenda(string $vcr_agenda): self
    {
        $this->vcr_agenda = $vcr_agenda;

        return $this;
    }

    public function getVcrStartTime(): ?\DateTimeInterface
    {
        return $this->vcr_start_time;
    }

    public function setVcrStartTime(\DateTimeInterface $vcr_start_time): self
    {
        $this->vcr_start_time = $vcr_start_time;

        return $this;
    }

    public function getVcrName(): ?string
    {
        return $this->vcr_name;
    }

    public function setVcrName(string $vcr_name): self
    {
        $this->vcr_name = $vcr_name;

        return $this;
    }

    public function getZoomStartMeetingLink(): ?string
    {
        return $this->zoom_start_meeting_link;
    }

    public function setZoomStartMeetingLink(?string $zoom_start_meeting_link): self
    {
        $this->zoom_start_meeting_link = $zoom_start_meeting_link;

        return $this;
    }

    public function getZoomMeetingJoingingLink(): ?string
    {
        return $this->zoom_meeting_joinging_link;
    }

    public function setZoomMeetingJoingingLink(string $zoom_meeting_joinging_link): self
    {
        $this->zoom_meeting_joinging_link = $zoom_meeting_joinging_link;

        return $this;
    }

    public function getZoomMeetingPassword(): ?string
    {
        return $this->zoom_meeting_password;
    }

    public function setZoomMeetingPassword(string $zoom_meeting_password): self
    {
        $this->zoom_meeting_password = $zoom_meeting_password;

        return $this;
    }

    public function getZoomSessionId(): ?string
    {
        return $this->zoom_session_id;
    }

    public function setZoomSessionId(string $zoom_session_id): self
    {
        $this->zoom_session_id = $zoom_session_id;

        return $this;
    }

    public function getZoomMeetingObject(): ?string
    {
        return $this->zoom_meeting_object;
    }

    public function setZoomMeetingObject(string $zoom_meeting_object): self
    {
        $this->zoom_meeting_object = $zoom_meeting_object;

        return $this;
    }
}
