<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Translatable\Translatable;
use Symfony\Component\Serializer\Annotation\MaxDepth;

/**
 * @ORM\Entity(repositoryClass="App\Repository\EmailTemplatesRepository")
 */
class EmailTemplates implements Translatable
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=100)
     */
    private $name;

    /**
     * @Gedmo\Translatable()
     * @ORM\Column(type="string", length=150)
     *
     */
    private $subject;

    /**
     * @Gedmo\Translatable()
     * @ORM\Column(type="text")
     */
    private $content;

    /**
     * @ORM\Column(type="array", nullable=true)
     */
    private $variables = [];

    /**
     * @ORM\Column(type="datetime")
     */
    private $createdAt;

    /**
     * @ORM\Column(type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\OneToOne(targetEntity="App\Entity\ShortEmailTemplates", mappedBy="email_template_refer",
     *                                                              cascade={"persist", "remove"})
     * @MaxDepth(1)
     */
    private $shortEmailTemplates;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\EmailTemplateEvents", inversedBy="trigger_template")
     * @ORM\JoinColumn(nullable=false)
     * @MaxDepth(1)
     */
    private $emailTemplateEvents;

    /**
     * @ORM\Column(type="string", length=3)
     */
    private $assigned_to;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_active;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ScheduleMessage", mappedBy="email_template")
     */
    private $scheduleMessages;

    public function __construct()
    {
        $this->scheduleMessages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getSubject(): ?string
    {
        return $this->subject;
    }

    public function setSubject(string $subject): self
    {
        $this->subject = $subject;

        return $this;
    }

    public function getContent(): ?string
    {
        return $this->content;
    }

    public function setContent(string $content): self
    {
        $this->content = $content;

        return $this;
    }

    public function getVariables(): ?array
    {
        return $this->variables;
    }

    public function setVariables(?array $variables): self
    {
        $this->variables = $variables;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeInterface
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeInterface $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(\DateTimeInterface $updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function getShortEmailTemplates(): ?ShortEmailTemplates
    {
        return $this->shortEmailTemplates;
    }

    public function setShortEmailTemplates(ShortEmailTemplates $shortEmailTemplates): self
    {
        $this->shortEmailTemplates = $shortEmailTemplates;

        // set the owning side of the relation if necessary
        if ($this !== $shortEmailTemplates->getEmailTemplateRefer()) {
            $shortEmailTemplates->setEmailTemplateRefer($this);
        }

        return $this;
    }

    public function getEmailTemplateEvents(): ?EmailTemplateEvents
    {
        return $this->emailTemplateEvents;
    }

    public function setEmailTemplateEvents(?EmailTemplateEvents $emailTemplateEvents): self
    {
        $this->emailTemplateEvents = $emailTemplateEvents;

        return $this;
    }

    public function getAssignedTo(): ?string
    {
        return $this->assigned_to;
    }

    public function setAssignedTo(string $assigned_to): self
    {
        $this->assigned_to = $assigned_to;

        return $this;
    }

    public function getIsActive(): ?bool
    {
        return $this->is_active;
    }

    public function setIsActive(bool $is_active): self
    {
        $this->is_active = $is_active;

        return $this;
    }

    public function getEmailTemplatesEvents(): ?EmailTemplateEvents
    {
        return $this->emailTemplatesEvents;
    }

    public function setEmailTemplatesEvents(?EmailTemplateEvents $emailTemplatesEvents): self
    {
        $this->emailTemplatesEvents = $emailTemplatesEvents;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    /**
     * @return Collection|ScheduleMessage[]
     */
    public function getScheduleMessages(): Collection
    {
        return $this->scheduleMessages;
    }

    public function addScheduleMessage(ScheduleMessage $scheduleMessage): self
    {
        if (!$this->scheduleMessages->contains($scheduleMessage)) {
            $this->scheduleMessages[] = $scheduleMessage;
            $scheduleMessage->setEmailTemplate($this);
        }

        return $this;
    }

    public function removeScheduleMessage(ScheduleMessage $scheduleMessage): self
    {
        if ($this->scheduleMessages->contains($scheduleMessage)) {
            $this->scheduleMessages->removeElement($scheduleMessage);
            // set the owning side to null (unless already changed)
            if ($scheduleMessage->getEmailTemplate() === $this) {
                $scheduleMessage->setEmailTemplate(null);
            }
        }

        return $this;
    }
}
