<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassFeeScheduleRepository")
 */
class ClassFeeSchedule
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $title;

    /**
     * @ORM\Column(type="float")
     */
    private $amount;

    /**
     * @ORM\Column(type="datetime")
     */
    private $due_date;

    /**
     * @ORM\Column(type="datetime")
     */
    private $last_due_date;

    /**
     * @ORM\Column(type="datetime")
     */
    private $generation_date;

    /**
     * @ORM\Column(type="smallint")
     */
    private $process = 0;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Invoices", inversedBy="classFeeSchedules")
     * @ORM\JoinColumn(nullable=true)
     */
    private $invoice_id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="classFeeSchedules")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassFee", inversedBy="classFeeSchedules")
     * @ORM\JoinColumn(nullable=true)
     */
    private $classFee;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\StudentFee", inversedBy="classFeeSchedules")
     * @ORM\JoinColumn(nullable=true)
     */
    private $student_fee;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $is_admission_fee;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSubject", inversedBy="classFeeSchedules")
     */
    private $class_subject;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(float $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getDueDate(): ?\DateTimeInterface
    {
        return $this->due_date;
    }

    public function setDueDate(\DateTimeInterface $due_date): self
    {
        $this->due_date = $due_date;

        return $this;
    }

    public function getLastDueDate(): ?\DateTimeInterface
    {
        return $this->last_due_date;
    }

    public function setLastDueDate(\DateTimeInterface $last_due_date): self
    {
        $this->last_due_date = $last_due_date;

        return $this;
    }

    public function getGenerationDate(): ?\DateTimeInterface
    {
        return $this->generation_date;
    }

    public function setGenerationDate(\DateTimeInterface $generation_date): self
    {
        $this->generation_date = $generation_date;

        return $this;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    ## 1 means fee schedule is generated
    public function setProcess(int $process): self
    {
        $this->process = $process;

        return $this;
    }

    public function getInvoiceId(): ?Invoices
    {
        return $this->invoice_id;
    }

    public function setInvoiceId(?Invoices $invoice_id): self
    {
        $this->invoice_id = $invoice_id;

        return $this;
    }

    public function getClass(): ?Classes
    {
        return $this->class;
    }

    public function setClass(?Classes $class): self
    {
        $this->class = $class;

        return $this;
    }

    public function getClassFee(): ?ClassFee
    {
        return $this->classFee;
    }

    public function setClassFee(?ClassFee $fee): self
    {
        $this->classFee = $fee;

        return $this;
    }

    public function getStudentFee(): ?StudentFee
    {
        return $this->student_fee;
    }

    public function setStudentFee(?StudentFee $student_fee): self
    {
        $this->student_fee = $student_fee;

        return $this;
    }

    public function getIsAdmissionFee(): ?bool
    {
        return $this->is_admission_fee;
    }

    public function setIsAdmissionFee(?bool $is_admission_fee): self
    {
        $this->is_admission_fee = $is_admission_fee;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    public function getClassSubject(): ?ClassSubject
    {
        return $this->class_subject;
    }

    public function setClassSubject(?ClassSubject $class_subject): self
    {
        $this->class_subject = $class_subject;

        return $this;
    }

}
