<?php

namespace App\Controller;

use App\Entity\Attendance;
use App\Entity\EmailTemplateEvents;
use App\Entity\Tokens;
use App\Repository\EmailTemplateEventsRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\CsvEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use App\Chat\ChatOperations;
use App\DataFixtures\UserFixtures;
use App\Entity\Classes;
use App\Entity\ClassSessionEnrolment;
use App\Entity\ClassSubject;
use App\Entity\ClassTemplate;
use App\Entity\CustomFields;
use App\Entity\ExamsClasses;
use App\Entity\ExamsClassesStudent;
use App\Entity\Guardian;
use App\Entity\InternalChatGroups;
use App\Entity\LibrarySections;
use App\Entity\SMSGateways;
use App\Entity\StudentGrades;
use App\Entity\Subjects;
use App\Entity\User;
use App\Kernel;
use App\Repository\AllocateTeacherToClassAndSubjectsRepository;
use App\Repository\AppSettingsRepository;
use App\Repository\AttendanceRepository;
use App\Repository\ClassesRepository;
use App\Repository\ClassFeeScheduleRepository;
use App\Repository\ClassSessionEnrolmentFeeScheduleRepository;
use App\Repository\ClassSessionEnrolmentRepository;
use App\Repository\ClassTemplateRepository;
use App\Repository\CustomFieldsRepository;
use App\Repository\ExamsClassesRepository;
use App\Repository\ExamsClassesStudentRepository;
use App\Repository\GuardianRepository;
use App\Repository\InternalChatGroupsRepository;
use App\Repository\InternalChatRepository;
use App\Repository\InvoiceItemsRepository;
use App\Repository\InvoicesRepository;
use App\Repository\LibraryAssignedRepository;
use App\Repository\LibrarySectionsRepository;
use App\Repository\SAnswersRegardingCFRepository;
use App\Repository\SessionRepository;
use App\Repository\SMSGatewaysRepository;
use App\Repository\StudentGradesRepository;
use App\Repository\SubjectsRepository;
use App\Repository\TransactionsRepository;
use App\Repository\UserRepository;
use App\Repository\WhoCanUpdateCustomFieldRepository;
use App\Service\accounts\InvoiceService;
use App\Service\accounts\TransactionService;
use App\Service\AppSettings;
use App\Service\CustomTokenManager;
use App\Service\DefaultFunction;
use App\Service\EmailSettings\Base;
use App\Service\EmailSettings\Settings;
use App\Service\Fees\FeeSchedulerService;
use App\Service\Fees\StudentFeeService;
use App\Service\FileManagment;
use App\Service\Guardian\GuardianService;
use App\Service\LibraryService;
use App\Service\ScheduleMessagesService\Files;
use App\Service\ScheduleMessagesService\ThrowMessages;
use App\Service\SMSGateways\CreativeONSMS;
use App\Service\SMSGateways\OperationalionalGatewayClass;
use App\Service\StudentClasses;
use App\Service\Students\Grade\ClassGradeService;
use App\Service\Students\Grade\ClassGradeTemplateService;
use App\Service\Students\Grade\GradeBase;
use App\Service\StudentsEnrollment\Enrollments;
use App\Service\StudentSession;
use App\Service\Teacher\teacherAllocationService;
use App\Service\TriggerNotifications;
use App\Service\UserService;
use App\Twig\AppExtension;
use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Mapping\Driver\DatabaseDriver;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\NoResultException;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\CreateCommand;
use http\Client\Response;
use http\Env;
use http\Env\Request;
use Knp\Bundle\SnappyBundle\KnpSnappyBundle;
use Knp\Bundle\SnappyBundle\Snappy\Response\PdfResponse;
use Knp\Snappy\Pdf;
use Symfony\Bridge\Doctrine\Tests\Fixtures\DoctrineLoaderEntity;
use Symfony\Bridge\Twig\Tests\Extension\Subject;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpClient\HttpClient;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpKernel\KernelInterface;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mailer\Tests\SentMessageTest;
use Symfony\Component\Mime\Email;
use Symfony\Component\Routing\Annotation\Route;
use App\Service\SubjectService;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoder;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;
use function GuzzleHttp\Psr7\str;

/**
 *
 * @IsGranted("ROLE_USER")
 * */
class TestingController extends AbstractController
{

    /**
     * @var CustomTokenManager
     */
    private $custom_token_manager;
    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var UserRepository
     */
    private $user_repository;
    /**
     * @var TriggerNotifications
     */
    private $trigger_notifications;
    /**
     * @var UrlGeneratorInterface
     */
    private $url_generator;
    /**
     * @var InternalChatRepository
     */
    private $internal_chat_repository;
    /**
     * @var ChatOperations
     */
    private $chat_operations;
    /**
     * @var ClassSessionEnrolmentRepository
     */
    private $class_session_enrolment_repository;
    /**
     * @var ClassesRepository
     */
    private $classes_repository;
    /**
     * @var AttendanceRepository
     */
    private $attendance_repository;
    /**
     * @var TransactionsRepository
     */
    private $transactions_repository;
    /**
     * @var ExamsClassesStudentRepository
     */
    private $exams_classes_student_repository;
    /**
     * @var GuardianRepository
     */
    private $guardian_repository;
    /**
     * @var SessionRepository
     */
    private $session_repository;
    /**
     * @var TransactionService
     */
    private $transaction_service;
    /**
     * @var AppSettings
     */
    private $app_settings;
    /**
     * @var ExamsClassesRepository
     */
    private $exams_classes_repository;
    /**
     * @var StudentClasses
     */
    private $student_classes;
    /**
     * @var StudentFeeService
     */
    private $student_fee_service;
    /**
     * @var ClassFeeScheduleRepository
     */
    private $class_fee_schedule_repository;
    /**
     * @var InvoiceService
     */
    private $invoice_service;
    /**
     * @var FeeSchedulerService
     */
    private $fee_scheduler_service;
    /**
     * @var SubjectService
     */
    private $subject_service;
    /**
     * @var Enrollments
     */
    private $enrollments;
    /**
     * @var StudentSession
     */
    private $student_session;
    /**
     * @var KnpSnappyBundle
     */
    private $knpSnappyBundle;
    /**
     * @var Pdf
     */
    private $pdf;
    /**
     * @var AppExtension
     */
    private $appExtension;
    /**
     * @var AllocateTeacherToClassAndSubjectsRepository
     */
    private $allocateTeacherToClassAndSubjectsRepository;
    /**
     * @var FileManagment
     */
    private $fileManagmentService;
    /**
     * @var Filesystem
     */
    private $filesystem;
    /**
     * @var InvoicesRepository
     */
    private $invoicesRepository;
    /**
     * @var OperationalionalGatewayClass
     */
    private $operationalionalGatewayClass;
    /**
     * @var SMSGatewaysRepository
     */
    private $SMSGatewaysRepository;
    /**
     * @var CreativeONSMS
     */
    private $creativeONSMS;
    /**
     * @var UserFixtures
     */
    private $userFixtures;
    /**
     * @var ObjectManager
     */
    private $objectManager;
    /**
     * @var AppSettingsRepository
     */
    private $appSettingsRepository;
    /**
     * @var GradeBase
     */
    private $gradeBase;

    /**
     * TestingController constructor.
     *
     * @param GradeBase $gradeBase
     * @param AppSettingsRepository $appSettingsRepository
     * @param ObjectManager $objectManager
     * @param UserFixtures $userFixtures
     * @param Pdf $pdf
     * @param CreativeONSMS $creativeONSMS
     * @param OperationalionalGatewayClass $operationalionalGatewayClass
     * @param SMSGatewaysRepository $SMSGatewaysRepository
     * @param StudentSession $student_session
     * @param Enrollments $enrollments
     * @param AppExtension $appExtension
     * @param SubjectService $subject_service
     * @param FeeSchedulerService $fee_scheduler_service
     * @param InvoiceService $invoice_service
     * @param ClassFeeScheduleRepository $class_fee_schedule_repository
     * @param StudentClasses $student_classes
     * @param StudentFeeService $student_fee_service
     * @param ExamsClassesRepository $exams_classes_repository
     * @param AppSettings $app_settings
     * @param TransactionService $transaction_service
     * @param SessionRepository $session_repository
     * @param GuardianRepository $guardian_repository
     * @param CustomTokenManager $custom_token_manager
     * @param DefaultFunction $default_function
     * @param UserRepository $user_repository
     * @param TriggerNotifications $trigger_notifications
     * @param UrlGeneratorInterface $url_generator
     * @param InternalChatRepository $internal_chat_repository
     * @param ChatOperations $chat_operations
     * @param ClassSessionEnrolmentRepository $class_session_enrolment_repository
     * @param ClassesRepository $classes_repository
     * @param AttendanceRepository $attendance_repository
     * @param TransactionsRepository $transactions_repository
     * @param ExamsClassesStudentRepository $exams_classes_student_repository
     * @param AllocateTeacherToClassAndSubjectsRepository $allocateTeacherToClassAndSubjectsRepository
     * @param FileManagment $fileManagmentService
     * @param Filesystem $filesystem
     * @param InvoicesRepository $invoicesRepository
     */
    public function __construct(
        GradeBase $gradeBase,
        AppSettingsRepository $appSettingsRepository,
        ObjectManager $objectManager,
        UserFixtures $userFixtures,
        Pdf $pdf,
        CreativeONSMS $creativeONSMS,
        OperationalionalGatewayClass $operationalionalGatewayClass,
        SMSGatewaysRepository $SMSGatewaysRepository,
        StudentSession $student_session,
        Enrollments $enrollments,
        AppExtension $appExtension,
        SubjectService $subject_service,
        FeeSchedulerService $fee_scheduler_service,
        InvoiceService $invoice_service,
        ClassFeeScheduleRepository $class_fee_schedule_repository,
        StudentClasses $student_classes,
        StudentFeeService $student_fee_service,
        ExamsClassesRepository $exams_classes_repository,
        AppSettings $app_settings,
        TransactionService $transaction_service,
        SessionRepository $session_repository,
        GuardianRepository $guardian_repository,
        CustomTokenManager $custom_token_manager,
        DefaultFunction $default_function,
        UserRepository $user_repository,
        TriggerNotifications $trigger_notifications,
        UrlGeneratorInterface $url_generator,
        InternalChatRepository $internal_chat_repository,
        ChatOperations $chat_operations,
        ClassSessionEnrolmentRepository $class_session_enrolment_repository,
        ClassesRepository $classes_repository,
        AttendanceRepository $attendance_repository,
        TransactionsRepository $transactions_repository,
        ExamsClassesStudentRepository $exams_classes_student_repository,
        AllocateTeacherToClassAndSubjectsRepository $allocateTeacherToClassAndSubjectsRepository

        ,
        FileManagment $fileManagmentService,
        Filesystem $filesystem,
        InvoicesRepository $invoicesRepository
    ) {
        $this->custom_token_manager = $custom_token_manager;
        $this->default_function = $default_function;
        $this->user_repository = $user_repository;
        $this->trigger_notifications = $trigger_notifications;
        $this->url_generator = $url_generator;
        $this->internal_chat_repository = $internal_chat_repository;
        $this->chat_operations = $chat_operations;
        $this->class_session_enrolment_repository = $class_session_enrolment_repository;
        $this->classes_repository = $classes_repository;
        $this->attendance_repository = $attendance_repository;
        $this->transactions_repository = $transactions_repository;
        $this->exams_classes_student_repository = $exams_classes_student_repository;
        $this->guardian_repository = $guardian_repository;
        $this->session_repository = $session_repository;
        $this->transaction_service = $transaction_service;
        $this->app_settings = $app_settings;
        $this->exams_classes_repository = $exams_classes_repository;
        $this->student_classes = $student_classes;
        $this->student_fee_service = $student_fee_service;
        $this->class_fee_schedule_repository = $class_fee_schedule_repository;
        $this->invoice_service = $invoice_service;
        $this->fee_scheduler_service = $fee_scheduler_service;
        $this->subject_service = $subject_service;
        $this->enrollments = $enrollments;
        $this->student_session = $student_session;
        $this->pdf = $pdf;
        $this->appExtension = $appExtension;
        $this->allocateTeacherToClassAndSubjectsRepository = $allocateTeacherToClassAndSubjectsRepository;
        $this->fileManagmentService = $fileManagmentService;
        $this->filesystem = $filesystem;
        $this->invoicesRepository = $invoicesRepository;
        $this->operationalionalGatewayClass = $operationalionalGatewayClass;
        $this->SMSGatewaysRepository = $SMSGatewaysRepository;
        $this->creativeONSMS = $creativeONSMS;
        $this->userFixtures = $userFixtures;
        $this->objectManager = $objectManager;
        $this->appSettingsRepository = $appSettingsRepository;
        $this->gradeBase = $gradeBase;
    }


    /**
     * @Route("{_locale}/testing", name="testing")
     * @param ClassGradeTemplateService $classGradeTemplateService
     * @param StudentGradesRepository $studentGradesRepository
     * @param Base $Emailbase
     * @param Settings $settings
     * @param ThrowMessages $throwMessages
     * @param Files $files
     * @param UserService $userService
     * @param GuardianService $guardianService
     * @param teacherAllocationService $teacherAllocationService
     * @param AppExtension $appExtension
     * @param ValidatorInterface $validator
     * @return \App\Entity\ClassSubjectTemplate|\App\Entity\ClassSubjectTemplate[]|\App\Entity\EmailTemplateEvents|array|bool|PdfResponse|mixed|string|\Symfony\Component\HttpFoundation\Response|null
     * @throws \Symfony\Component\Mailer\Exception\TransportExceptionInterface
     * @throws TransportExceptionInterface
     */
    public function index(
        ClassGradeService $classGradeService,
        ClassGradeTemplateService $classGradeTemplateService,
        StudentGradesRepository $studentGradesRepository,
        Base $Emailbase,
        Settings $settings,
        ThrowMessages $throwMessages,
        Files $files,
        UserService $userService,
        GuardianService $guardianService,
        teacherAllocationService $teacherAllocationService,
        AppExtension $appExtension,
        ValidatorInterface $validator,
        ClassTemplateRepository $classTemplateRepository,
        \Swift_Mailer $swiftMailer,
        Base $EmailBase,
        ContainerInterface $container,
        EntityManagerInterface $entityManager,
        OperationalionalGatewayClass $operationalionalGatewayClass,
//        EmailTemplateEvents $emailTemplateEvents,
        EmailTemplateEventsRepository $emailTemplateEventsRepository,
        TriggerNotifications $triggerNotifications,
        UserRepository $userRepository,
        AttendanceRepository $attendanceRepository,
        GuardianRepository $guardianRepository,
        \Symfony\Component\HttpFoundation\Request $request
    ) {


        $attendances = $this->attendance_repository->reporting__attendances($request->query);

        ## variable data object
        $sendingData = [
            'attendances' => $attendances,
        ];


        foreach ($sendingData['attendances'] as $attendance) {
            /** @var Attendance $attendance */
            $attendance->sendSMSAboutAttendance($triggerNotifications);
        }

        dd('tes');

        $args = [
            'event_name' => 'DAILY_ATTENDANCE',
            'user' => $userRepository->find(1),
            'notification_type' => 'daily_attendance',
            'attendance' => $attendanceRepository->find(1),
            'guardian' => $guardianRepository->find(1),
            'attendance_status_name' => 'name',
        ];
        dd($triggerNotifications->triggerNotifications($args));

//        dump($attendance::getDailyAttendanceShortMessage($emailTemplateEventsRepository));

//        $emailTemplate = new EmailTemplateEvents();
//        dump($emailTemplate->getDailyAttendanceTemplate());


//        dump($emailTemplateEvents)

//        dump($emailTemplateEventsRepository->find(8)->getTriggerTemplate()->first()->getShortEmailTemplates());

//        dump($emailTemplateEvents->getDailyAttendanceTemplate($emailTemplateEventsRepository));

//        dd('test notification..');

        $bag = new ParameterBag();
        $bag->set('to', 923159292201);
        $bag->set('message', 'Getting message from real function');
        $bagResponse = $operationalionalGatewayClass->sendMessage($bag);
        dump($bagResponse);

        dd('--');

        $classs = $entityManager->getRepository(Classes::class)->find(1);
        $this->gradeBase->assignGradesToClass(1, $classs);
        dd('f');


        $client = HttpClient::create();
        $response = $client->request('GET', 'http://127.0.0.1:8000/api/testPatch/');
        $statusCode = $response->getStatusCode();

        dump($statusCode);
        try {
            dump($response->getContent());
        } catch (ClientExceptionInterface $e) {
        } catch (RedirectionExceptionInterface $e) {
        } catch (ServerExceptionInterface $e) {
        } catch (TransportExceptionInterface $e) {
            dump($e->getMessage());
        }

        dd('ff');

        $this->custom_token_manager;

//        dd(crypt(random_bytes(900), getenv('APP_SECRET') . '$2a$07$usesomesillystringforsalt$$1$rasmusle$' ));
//

//        $bag = new ParameterBag();
//        $this->custom_token_manager->save__token();

        $token = new Tokens();
        $entityManager->persist($token);
        $entityManager->flush();

        dd('fff');
        die();
        $filename = '/home/sulaman/Downloads/SampleCSVFile_2kb.csv';
        $filename = '/home/sulaman/Downloads/SacramentocrimeJanuary2006.csv';
        $filename = '/home/sulaman/Downloads/100-Sales-Records/100 Sales Records.csv';
        $filename = '/home/sulaman/Downloads/2020_04112019.csv';
        $filename = '/home/sulaman/Downloads/Asher2020-04112019.csv';
        $filename = '/home/sulaman/Downloads/الصفوف_2020-04112019.csv';
        $filename = '/home/sulaman/snap/skype/common/studentImport.csv';
        //$filename = '/home/sulaman/Downloads/studentImport.csv';

        $response = file_get_contents($filename);
        $encoders = new CsvEncoder();
        $decodeRes = $encoders->decode($response, 'csv');

        // dd($decodeRes);


//        $encoders = [new JsonEncoder()];
//        $defaultContext = [
//            AbstractNormalizer::CIRCULAR_REFERENCE_HANDLER => function ($object, $format, $context) {
//            },
//        ];
//        $normalizer = [new ObjectNormalizer(null, null, null, null, null, null, $defaultContext)];
//
//
//        $serializer = new Serializer($normalizer, $encoders);
//        $data = $serializer->serialize($response, 'csv');
//
//
//        dd($data);
//
//
//        dd(new JsonResponse($data, 200));


//        $container->get('serializer')->decode($data, 'csv')
        $serializer = $container->get('serializer');

        $serializer = new Serializer([new ObjectNormalizer()], [new CsvEncoder()]);
        $response = file_get_contents($filename);
        $decodeRes = $serializer->decode($response, 'csv');

        dump($decodeRes);
        dump($response);

        die();


        $data = $serializer->decode(file_get_contents('/home/sulaman/Downloads/SacramentocrimeJanuary2006.csv'), 'csv');
        dump($data);


        dump($this->appExtension->getUserEnabledLanguages());


        dd('----fe');
        $bag = new ParameterBag();
        $bag->set('receiver', 'symikhan70@gmail.com');
        $bag->set('message', 'actuall message from fekara server');
        $bag->set('subject', 'Subject message..');
        $bag->set('user', $this->getUser());
        $response = $EmailBase->sendEmail($bag);
        dd($response);


//        $email = (new Email())
//            ->from('hello@example.com')x
//            ->to('you@example.com')
//            //->cc('cc@example.com')
//            //->bcc('bcc@example.com')
//            //->replyTo('fabien@example.com')
//            //->priority(Email::PRIORITY_HIGH)
//            ->subject('Time for Symfony Mailer!')
//            ->text('Sending emails is fun again!')
//            ->html('<p>See Twig integration for better HTML integration!</p>');
//
//        /** @var SentMessageTest $sentEmail */
//        $sentEmail = $mailer->send($email);
//        $messageId = $sentEmail->getMessageId();
//
//        dump($sentEmail);
//        dump($messageId);

        // ...


        $message = (new \Swift_Message('Hello Email'))
            ->setFrom('mutalfekara@gmail.com')
            ->setTo('symikhan70@gmail.com')
            ->setBody(
                'Nice to having you... This is email Body.. .functionalll.. email body'
            );
        $reponse = $swiftMailer->send($message);
        dd($reponse);

        /*
                // For some users works using the gethostbyname function
                $smtp_host_ip = gethostbyname('smtp.gmail.com');
        // But for others only the smtp address
                $smtp_host_ip = 'smtp.gmail.com';

                $transport = \Swift_SmtpTransport::newInstance($smtp_host_ip, 465, 'ssl')->setUsername(
                    'symikhan8@gmail.com'
                )->setPassword('31rf6taNCxO8');

                dd($transport);
                $mailer = \Swift_Mailer::newInstance($transport);

                $message = \Swift_Message::newInstance()
                    ->setFrom(array("john@doe.com" => 'John Doe'))
                    ->setTo(array("john@doe.com" => 'John Doe'));
                $message->setBody('<h3>Contact message</h3>', 'text/html');

                $mailer->send($message);
        */


        die();
        $response = $classGradeService->calculateGradeFromMarksPercentage(11, 90);
        dump($response);

        die();


        $bag = new ParameterBag();
        $bag->set('___randsection', '231');
        $bag->set('active', 'on');
        $bag->set('gradeCat', 2);
        $bag->set('name', 'Noemy Stroman');
        $bag->set('number_s', '49');
        $bag->set('short_name', 'short name');
        $bag->set('subject_vise_attendance', 'on');
        $bag->set('subject_vise_fee', 'off');
        $bag->set('subjects', [124, 126]);
        $bag->set('seSon', [49, 50]);
        $response = $this->student_classes->saveClasses(
            $bag,
            $this->student_session,
            $classGradeTemplateService
        );
        dump($response);

        die();
        if (empty($info['message']) || empty($info['alertMessages'])) {
            return 'Required parameters are missing';
        }

        $results = array();
// Put your private key's passphrase here:
        $passphrase = '123456';
// $rout = Router::url($this->here, true);
        $rout = Router::url('/', true);
//    $applePushCertPath = ( preg_match( "/\bdev\b/i", $rout ) || preg_match( "/\bdevs\b/i", $rout ) || preg_match( "/\blocal\b/i", $rout ) ) ? ROOT . '/apple_push_notification_dev.pem' : ROOT . '/apple_push_notification_prod.pem';
//    $applePushCertPath = ( preg_match( "/\bdev\b/i", $rout ) || preg_match( "/\bdevs\b/i", $rout ) || preg_match( "/\blocal\b/i", $rout ) ) ? ROOT . '/apple_push_notification_prod.pem' : ROOT . '/apple_push_notification_prod.pem';
        $applePushCertPath = ROOT.'/apple_push_notification_prod.pem';
        $ctx = stream_context_create();
        stream_context_set_option($ctx, 'ssl', 'local_cert', $applePushCertPath);
        stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);
// Open a connection to the APNS server
        /*below rout is not working only on dev , not sure why*/
        $this->log('webCurrentUrl:'.json_encode($rout), 'PushDebug');
        $applePushGateway = (preg_match("/\bdev\b/i", $rout) || preg_match("/\bdevs\b/i", $rout)) ? Configure::read(
            'APPLE_SANDBOX_PUSH_GATEWAY'
        ) : Configure::read('APPLE_PRODUCTION_PUSH_GATEWAY');
        $this->log('IOSCurrentPushGatewayUrl:'.json_encode($applePushGateway), 'debug');
        $fp = stream_socket_client(
            $applePushGateway,
            $err,
            $errstr,
            60,
            STREAM_CLIENT_CONNECT | STREAM_CLIENT_PERSISTENT,
            $ctx
        );
        $this->log('Fp Connection for Ios is established', 'PushDebug');
        $this->log($fp, 'pushDebug');
        if ($fp) {
            // Create the payload body
            $body['aps'] = array(
                'alert' => empty($info['alertMessages']) ? $info['message'] : $info['alertMessages'],
                'sound' => 'default',
                "type" => empty($info['messageType']) ? null : $info['messageType'],
            );
            // Encode the payload as JSON
            $payload = json_encode($body);
            $this->log('PayLoad For IOS:', 'pushDebug');
            $this->log($body, 'pushDebug');
            $deviceToken = $info['user_token'];
            // Build the binary notification
            $msg = chr(0).pack('n', 32).pack('H*', $deviceToken).pack('n', strlen($payload)).$payload;
            // Send it to the server
            $result = (fwrite($fp, $msg, strlen($msg))) ? true : false;
            if ($result) {
                $this->log('IMSuccess-IOS :'.$payload, 'pushDebug');
            } else {
                $this->log('IMError-IOS :'.$payload, 'pushDebug');
            }
            $this->log('ServerResponseForIOS :'.$result, 'pushDebug');
            $this->log('IOSUserTokenData:'.json_encode($info['user_token']), 'pushDebug');
            $results['messageStatus'] = (!$result) ? 'Fail' : 'Success';
//       $results['recipient_id']  = $info['sendTo']['Register']['user_id'];
//       $results['deviceId']      = $info['sendTo']['Register']['gcm_regid'];
        } else {
            $results[0]['connectionStatus'] = "Failed to connect: $err $errstr".PHP_EOL;
        }
// Close the connection to the server
        fclose($fp);
        $this->log('IOSPushResult:', 'pushDebug');
        $this->log($results, 'PushDebug');

        return $results;


        try {
            $classGradeService->copyStudentClassGradeTemplateToClassGrade($classTemplateRepository->find(226));
        } catch (NoResultException $e) {
        } catch (NonUniqueResultException $e) {
        }
        dd('fe');


        $response = $classGradeTemplateService->copyStudentDefinedGradeToClassTemplateFromStudentGrade(2);
        dump($response);
        dd('---------------------------------');

        dd($studentGradesRepository->gradeCategoryGradeNameGradeMarksDuplicationCheck(2, 'ddA+', 100));


//		$author = new StudentGrades();
//		$author->setStudentGradeName('');
//		$errors = $validator->validate( $author );
//
//		if ( count( $errors ) > 0 ) {
//			/*
//			 * Uses a __toString method on the $errors variable which is a
//			 * ConstraintViolationList object. This gives us a nice string
//			 * for debugging.
//			 */
//			$errorsString = (string) $errors;
//
//			dd($errorsString);
//		}
//
//		return new Response( 'The author is valid! Yes!' );

        dump($this->gradeBase->saveGrades(new ParameterBag()));

        dd(' ====================================================================');

        dump($files->getMessageScheduleAttachment(1));


        $d = $throwMessages->triggerScheduleMessage();
        dump($d);
        dd('fe');


        $bag = new ParameterBag();
        $bag->set('subject', 'Testing Email');
        $bag->set('message', 'Testing Message');
        $bag->set('receiver', 'symikhan8@gmail.com');
        $response = $Emailbase->sendEmailUsingSwiftMailer($bag);
        dump($response);


        dd("die ehre");

        dump($settings->setMailURL());
        dump(getenv('MAILER_URL'));


        dump(getenv('MAILER_URL'));
        dump(putenv('MAILER_URL=null://localhost:9000'));
        dump(getenv('MAILER_URL'));


        dump($throwMessages->getScheduleMessageThatNeedToSend());

        dump($appExtension->getAppSettingNode('school_logo_path'));


        dd("wokring principle");
        $ar = [
            "3",
            "2",
        ];
        dump($avlue = $userService->getBulkUserListFromUserIds($ar));
        dump($guardianService->getGuardiansFromStudentRef($avlue));

        dump($teacherAllocationService->getTeacherFromStudentRef($avlue));

        dd('fee');

        $filePath = 'fekara/uploads/reports/hello12.pdf';
        $files->moveFileToScheduleMessage($filePath, 102);

        dd('die to here');

    }

}
