<?php

namespace App\Controller;

use App\Chat\ChatOperations;
use App\Repository\InternalChatGroupsRepository;
use App\Repository\InternalChatRepository;
use App\Repository\UserRepository;
use App\Service\UserService;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 * */
class InternatChatController extends AbstractController {

	/**
	 * @var UserRepository
	 */
	private $user_repository;
	/**
	 * @var ChatOperations
	 */
	private $chat_operations;
	/**
	 * @var InternalChatRepository
	 */
	private $internal_chat_repository;
	/**
	 * @var InternalChatGroupsRepository
	 */
	private $internal_chat_groups_repository;

	## chat list counter
	public $chatCounter;

	public function __construct( UserRepository $user_repository, ChatOperations $chat_operations, InternalChatRepository $internal_chat_repository, InternalChatGroupsRepository $internal_chat_groups_repository ) {
		$this->user_repository                 = $user_repository;
		$this->chat_operations                 = $chat_operations;
		$this->internal_chat_repository        = $internal_chat_repository;
		$this->internal_chat_groups_repository = $internal_chat_groups_repository;
	}

	/**
	 * @Route("{_locale}/chat", name="internat_chat")
	 */
	public function index() {
		## get the current logged in user
		$current_logged_in_user_id = $this->getUser()->getId();
		## list of all users
		$listOfUsers = $this->user_repository->get__all_users_except_current_loggedin_user( $current_logged_in_user_id );

		## return the view.
		return $this->chat__group__list( 'render', 'inbox__view.html.twig', $listOfUsers, $this->chat_operations->load__chatListOfUser( $current_logged_in_user_id, true ), $this->chat_operations->load__recentGroupList( $current_logged_in_user_id, true ) );
	}


	/**
	 * @Route("{_locale}/chat", name="internat_chat")
	 */
	public function index_messages() {
		$userID = $this->getUser()->getID();

		return $this->render( 'internat_chat/inbox__view.html.twig', [
			'inbox'    => $this->chat_operations->get__data__for_message( $userID, 'inbox' ),
			'UserList' => $this->user_repository->findAll(),
		] );
	}

	/**
	 * @Route("{_locale}/chat/requestHandler/{query}", name="requestHandler__internalchat", defaults={ "query":null })
	 * @param Request $request
	 *
	 * @param null    $query
	 *
	 * @return JsonResponse
	 */
	public function ajaxHandler( Request $request, $query = null ) {
		## get the query variable from the get request.
		if ( empty( $query ) ) {
			$query = $request->query->get( 'query' );
		}

		$response = null;

		switch ( $query ) {
			## used for the chat purposes
			case 'load___conversation':
				## load conversations/chat messages
				$response = $this->load__conversation( $request->request->get( 'u_' ), $request->request->get( 'u__', $this->getUser()
				                                                                                                           ->getId() ) );
				$response = $this->renderView( 'internat_chat/chat___messages__interface.html.twig', [
					'message__list' => $response,
					'to__name'      => $request->request->get( 'u_name' ),
					'to__ref'       => $request->request->get( 'u_' ),
				] );
				break;
			case 'save___chatMessage':
				## save chat message
				$response = $this->chat_operations->send__message( $request->request );
				break;
			case 'save_message_u':
				## save chat message with upload file.
				$response = $this->chat_operations->send__message( $request->request, $request->files );
				break;
			case 'web_worker':
				## web worker request to this route to load the newest chat messages and chat list
				$response_ = [];

				## if receiver is not empty
				if ( $request->query->get( 'ted' ) <> 'undefined' ) {
					$response = $this->load__conversation( $request->query->get( 'ted' ), $request->query->get( 'u__', $this->getUser()
					                                                                                                        ->getId() ), $request->query->get( 'm_af', null ) );

					## render the chat interface.
					$response = $this->renderView( 'internat_chat/chat___messages__interface.html.twig', [
						'message__list' => $response,
						'to__name'      => $request->query->get( 'fed' ),
					] );
					## store the chat html
					$response_['chatcontent'] = $response;
				}


				## get the chat list---
				$chatLIst         = $this->chat_operations->load__chatListOfUser( $this->getUser()->getId(), false );
				$counterChatLIst  = $this->chat_operations->get__chatListInSession( true );
				$groupList        = $this->chat_operations->load__recentGroupList( $this->getUser()->getId(), false );
				$counterGroupList = $this->chat_operations->get__chatListInSession( false );

				## if recent chat list or active group list is greater then the visible list then make the contant and get the result.
				if ( count( $chatLIst ) > $counterChatLIst || count( $groupList ) || $counterGroupList ) {
					## store the chat list + group list html
					$response_['chatLIst'] = $this->chat__group__list( 'renderView', 'chat__list__people.html.twig', null, $chatLIst, $groupList );
				}

				$response = $response_;
				//$response = count( $chatLIst ) . ' ' . $counterChatLIst . ' ' . count( $groupList ) . ' ' . $counterGroupList;

				break;
			case 'making__group':
				## making group.
				$response = $this->chat_operations->create__chatGroup( $request->request );
				break;
			## using in internal messaging system
			case 'load__only__ongoingMessages':

				if ( ! empty( $request->get( 'm_typ' ) ) ) {
					$response = $this->chat_operations->get__data__for_message( $this->getUser()
					                                                                 ->getId(), $request->get( 'm_typ' ) );
					$response = 'escape__fromErro_' . $this->renderView( 'internat_chat/inbox___list.html.twig', [
							'Messages' => $response,
							'type'     => $request->get( 'm_typ' ),
						] );
				}


				break;
			## get message details.
			case 'loadMessage':
				if ( $request->get( 'markMessageAsRead' ) == 1 ) {
					## mark message as read.
					$this->chat_operations->markMessageAsRead( $request->get( 'm__ref' ) );
				}
				## when user click on specific message then system loads, full details of this message.
				## load message.
				$response = $this->chat_operations->getMessage( $request->get( 'm__ref' ) );
				$response = 'escape__fromErro_' . $this->renderView( 'internat_chat/inbox__message__view.html.twig', [
						'Message' => $response,
					] );
				break;
			case 'MessageCounter':
				## check message counter.
				$response = $this->chat_operations->getMessageCounter( $this->getUser()->getID() );
				break;
			case 'BulkOperation':
				$response = $this->chat_operations->OperateBulkOperation( $request );
				break;
			default:
				$response = 'OK';
				break;
		}

		return new JsonResponse( $response, 200 );
	}

	## chat and group list
	private function chat__group__list( $render, $template = '', $ListOfUser = null, $ChatListOfUser = null, $groupList = null ) {
		return $this->$render( 'internat_chat/' . $template, [
			## get all the list of the users.
			'list__of_users'         => $ListOfUser,
			## load chat list of the user - to which I've communicate.
			'chat_list_of_users'     => $ChatListOfUser,
			## get the list of the user which is involved in the group
			'involvements_in_groups' => $groupList,
		] );
	}

	## load conversation
	private function load__conversation( $para_1, $para_2, $para3 = null ) {
		if ( ! is_integer( $para_1 ) && substr( $para_1, 0, 4 ) == 'g___' ) {
			## load group conversation
			$response = $this->internal_chat_repository->load_conversation_of_group( substr( $para_1, 4 ) );
		} else {
			## load private conversation
			$response = $this->internal_chat_repository->load_conversation_of_two_users( $para_1, $para_2, $para3 );
		}

		return $response;
	}

}
