<?php

namespace App\Controller;

use App\Entity\Classes;
use App\Entity\ClassFee;
use App\Entity\ClassFeeSchedule;
use App\Entity\ClassFeeTemplate;
use App\Entity\ClassSubject;
use App\Entity\ClassSubjectTemplate;
use App\Entity\ClassTemplate;
use App\Entity\StudentFee;
use App\Repository\ClassesRepository;
use App\Repository\ClassFeeRepository;
use App\Repository\StudentFeeRepository;
use App\Service\DefaultFunction;
use App\Service\Fees\FeeSchedulerService;
use App\Service\StudentClasses;
use App\Service\StudentSession;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Mapping\Entity;
use Nzo\UrlEncryptorBundle\Annotations\ParamDecryptor;
use Nzo\UrlEncryptorBundle\UrlEncryptor\UrlEncryptor;
use App\Service\Fees\StudentFeeService;
use App\Service\UserService;
use Doctrine\ORM\EntityNotFoundException;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 * */
class FeeController extends AbstractController
{

    /**
     * /**
     * @var StudentFeeRepository
     */
    private $student_fee_repository;
    /**
     * @var StudentFeeService
     */
    private $student_fee_service;
    /**
     * @var Classes
     */
    private $classes;
    /**
     * @var ClassesRepository
     */
    private $classes_repository;
    /**
     * @var ClassFeeRepository
     */
    private $class_fee_repository;
    /**
     * @var FeeSchedulerService
     */
    private $fee_scheduler_service;
    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var EntityManagerInterface
     */
    private $entityManager;

    public function __construct(
        StudentFeeRepository $student_fee_repository,
        DefaultFunction $default_function,
        StudentFeeService $student_fee_service,
        ClassesRepository $classes_repository,
        ClassFeeRepository $class_fee_repository,
        FeeSchedulerService $fee_scheduler_service,
        EntityManagerInterface $entityManager
    ) {
        $this->student_fee_repository = $student_fee_repository;
        $this->student_fee_service = $student_fee_service;
        $this->classes_repository = $classes_repository;
        $this->class_fee_repository = $class_fee_repository;
        $this->fee_scheduler_service = $fee_scheduler_service;
        $this->default_function = $default_function;
        $this->entityManager = $entityManager;
    }

    /**
     * @Route("{_locale}/fee", name="fee")
     */
    public
    function index()
    {
        return $this->render(
            'fee/index.html.twig',
            [
                'feeList' => $this->student_fee_repository->findBy([], ['is_deleted' => 'ASC']),
            ]
        );
    }

    /**
     * @Route("{_locale}/fee/add/{query}", name="add_fee", defaults={"query"=null}))
     * @ParamDecryptor(params={"query"})
     */
    public
    function add_fee(
        $query
    ) {
        $Entity = new StudentFee();

        ## if we found something in the query
        if ($query) {
            try {
                ## get the session.
                $Entity = $this->student_fee_repository->find($query);
                ## if found no record against the id then create new empty session
                if (!$Entity instanceof StudentFee) {
                    $Entity = new StudentFee();
                }
            } catch (\Exception $exception) {

            }
        }

        return $this->render(
            'fee/addFee.html.twig',
            [
                'studentFee' => $Entity,
            ]
        );
    }


## serve class_fee_template edit form
    protected
    function serve__classFeeTemplate(
        $fee_template_ref,
        $className
    ) {
        $ClassFeeTemplate = $this->student_fee_service->getFeeFromClassFeeTemplateTable($fee_template_ref);
        if (!$ClassFeeTemplate instanceof ClassFeeTemplate) {
            $ClassFeeTemplate = new ClassFeeTemplate();
        }

        return $this->renderView(
            'fee/editClassFeeTemplate.html.twig',
            [
                'classFeeTemplate' => $ClassFeeTemplate,
                'className' => $className,
            ]
        );
    }


## serve class_fee edit form
    protected
    function serve__classFee(
        $fee_ref,
        $className = null
    ) {
        $ClassFee = $this->student_fee_service->getFeeFromClassFeeTable($fee_ref);
        if (!$ClassFee instanceof ClassFee) {
            $ClassFee = new ClassFee();
        }

        return $this->renderView(
            'fee/editClassFeeTemplate.html.twig',
            [
                'classFeeTemplate' => $ClassFee,
                'className' => $className,
            ]
        );
    }


    /**
     * @Route("{_locale}/class/fee/schedule/{query}", name="class_fee_schedule", defaults={"query"=null}))
     * @param Request $request
     * @return Response
     */
    ## class fee schedule.
    public
    function class_fee_schedule(
        Request $request
    ) {
        $class_fee_schedule = new ClassFeeSchedule();
        $subjects = null;
        if (!empty($request->query->get('class_id'))) {
            $classDetails = $this->classes_repository->find($request->query->get('class_id'));
            if ($classDetails instanceof Classes && $classDetails->getSubjectwiseFee()) {
                $subjects = $classDetails->getClassSubject()->toArray();
            }
        }

        return $this->render(
            'fee/class_fee_schedule.html.twig',
            [
                ## get the class fee schedule.
                'classFeeSchedule' => $class_fee_schedule,
                ## get active classes from the classes table.
                'classes' => $this->classes_repository->findBy(['active' => true]),
                ## get the all fees from the student_fee table.
                'stu_fee' => $this->student_fee_repository->findAll(),
                ## class fee
                //'classFee'         => $this->class_fee_repository->findAll(),
                'classFee' => '',
                'subjects' => $subjects,
            ]
        );
    }

    /**
     * @Route("{_locale}/class/fees/list", name="class_fee_schedule_list")
     * @param StudentSession $studentSession
     * @param StudentClasses $studentClasses
     * @param Request $request
     * @return Response
     */
    public function classFeeScheduleList(
        StudentSession $studentSession,
        StudentClasses $studentClasses,
        Request $request
    ) {
        return $this->render(
            'fee/ClassFeeScheduler/classFeeSchedulerList.html.twig',
            [
                'classFeeScheduleList' => $this->fee_scheduler_service->getAllClassesFeeFromClassFeeScheduler(),
                'sessions' => $studentSession->getAllSessions(),
                'classes' => $studentClasses->getAllClasses($request->query),
            ]
        );
    }


    /**
     * @Route("{_locale}/fee/requestHandler/{query}", name="requestHandler_student_fee")
     */
    public
    function ajaxHandler(
        Request $request,
        $query = null
    ) {
        ## if user is not logged in the redirect th e use rto login page.
        $response = 'OK';


        if (empty($query)) {
            ## get the query variable from the get request.
            $query = $request->query->get('query');
        }


        switch ($query) {
            case 'addFee':
                ## add fees in the student_fee table
                $response = $this->student_fee_service->addEditfee($request->request);
                break;
            case 'DSF':
                ## delete student fee
                $response = $this->student_fee_service->deleteStudentFee((int)$request->request->get('DSF__R'), true);
                break;
            case 'getClassFeeTemplateForm':
                ## server edit classFeeTemplate table
                $response = 'escape__fromErro_'.$this->serve__classFeeTemplate(
                        $request->request->get('ref'),
                        $request->request->get('className')
                    );
                break;
            case 'updateClassFeeTemplateForm':
                $response = $this->student_fee_service->editFeeInClassFeeTemplateTable($request->request);
                break;
            case 'getClassFeeForm__forClassFeeTable':
                ## server class fee table data from ClassFeeTemplate table
//                $response = 'escape__fromErro_' . $this->serve__classFeeTemplate($request->request->get('ref__'), $request->request->get('className', ''));
                $response = 'escape__fromErro_'.$this->serve__classFee(
                        $request->request->get('ref__'),
                        $request->request->get('className')
                    );
                break;
            case 'updateClassFeeForm':
                $response = $this->student_fee_service->editFeeInClassFeeTable($request->request);
                break;
            case 'load__classFee_on_based_of_class':
                ## load classes fee on based of class
                $response = $this->fee_scheduler_service->loadClassFeeOnBaseOfClass((int)$request->get('c__r'));
                //				$response = 'escape__fromErro_' . $this->renderView( 'fee/load_fee_on_based_of_classes.html.twig', [
                //						'classFee' => $this->class_fee_repository->findBy( [ 'class' => $request->get( 'c__r' ) ] ),
                //					] );
                break;
            case 'load__subjectFee_on_based_of_class':
                if ($request->request->get('class_subject_id')) {
                    $response = $this->fee_scheduler_service->loadSubjectFeeOnBaseOfClass(
                        (int)$request->get('c__r'),
                        (int)$request->get('class_subject_id')
                    );
                }
                break;
            case 'sav__fee_scheduler':
                ## save fee scheduler in bulk
//                dump($request->request);
                $response = $this->fee_scheduler_service->save_class_fee_schedule_bulk($request->request);
                $response = $this->default_function->purify_success_error_response_in_bulk_operation($response);
                break;
            case 'd_cse_FS':
                ## delete class session enrolment fee schedule.
                $response = $this->fee_scheduler_service->delete_class_session_enrolment_fee_schedule(
                    $request->request->get('_09')
                );
                break;
            case 'showStudentFee':
                ## add student fee locally
                $response = 'escape__fromErro_'.$this->renderView(
                        'fee/StudentFee/loadStudentFeeLocally.html.twig',
                        [
                            'data' => $request->request,
                            'studentFeeRef' => $request->request->get('studentFeeRef'),
                            'studentFeeName' => $request->request->get('studentFeeName'),
                            'studentFeeAmount' => $request->request->get('studentFeeAmount'),
                            'studentFeeChargeAt' => $request->request->get('studentFeeChargeAt'),
                            'studentFeeGenerationDate' => $request->request->get('studentFeeGenerationDate'),
                            'studentFeeDueDate' => $request->request->get('studentFeeDueDate'),
                            'studentFeeLastDueDate' => $request->request->get('studentFeeLastDueDate'),
                        ]
                    );
                break;
            case 'delete__CSF':
                ## delete fee from Class fee scheduler table.
                $response = $this->fee_scheduler_service->deleteFeeFromClassFeeSchedulerTable(
                    (int)$request->request->get('CSF___r')
                );
                break;
            case 'dFCFT':
                ## delete fee from class fee template table.
                $response = $this->student_fee_service->deleteClassFeeTemplate(
                    (int)$request->request->get('ref'),
                    true
                );
                break;
            case 'dClassFee':
                ## delete fee from ClassFeeTable
                $response = $this->student_fee_service->deleteClassFee((int)$request->request->get('rOO'), true);
                break;

        }

        return new JsonResponse($response, 200);
    }

}
