<?php

namespace App\Repository;

use App\Entity\StudentGrades;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\QueryBuilder;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method StudentGrades|null find($id, $lockMode = null, $lockVersion = null)
 * @method StudentGrades|null findOneBy(array $criteria, array $orderBy = null)
 * @method StudentGrades[]    findAll()
 * @method StudentGrades[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class StudentGradesRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, StudentGrades::class);
    }

    /**
     * @param int|null $gradeCatId
     * @param $gradeName
     * @param $gradeMarks
     * Purpose: While saving validate, if same grade already exits or not.
     * @return bool
     */
    public function gradeCategoryGradeNameGradeMarksDuplicationCheck(?int $gradeCatId, $gradeName, $gradeMarks)
    {
        $queryResult = $this->createQueryBuilder('student_grades')->leftJoin(
            'student_grades.student_grade_category',
            'studentGradeCategory'
        )->where('studentGradeCategory.id = :studentGradeCatId')->setParameter(
            'studentGradeCatId',
            $gradeCatId
        )->andWhere(
            'student_grades.student_grade_name = :gradeName'
        )->andWhere('student_grades.student_grade_equal_or_greater_than_marks = :marks')->setParameter(
            'studentGradeCatId',
            $gradeCatId
        )->setParameter('gradeName', $gradeName)->setParameter('marks', $gradeMarks)->getQuery()->getResult();

        $response = false;
        if (count($queryResult)) {
            $response = true;
        }

        return $response;
    }
}
