<?php

namespace App\Repository;

use App\Entity\InvoiceItems;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method InvoiceItems|null find( $id, $lockMode = null, $lockVersion = null )
 * @method InvoiceItems|null findOneBy( array $criteria, array $orderBy = null )
 * @method InvoiceItems[]    findAll()
 * @method InvoiceItems[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class InvoiceItemsRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, InvoiceItems::class );
	}


	## get the total amount of the invoice.
	public function get_the_to_total_amount_regarding_invoice( int $invID ) {
		try {
			return $this->createQueryBuilder( 'invoice_items' )
			            ->select( 'SUM(invoice_items.inv_item_amount) as total_amount_of_invoice' )
			            ->where( 'invoice_items.invoice_reference = :inv_id' )
			            ->setParameter( 'inv_id', $invID )
			            ->getQuery()
			            ->getSingleScalarResult();
		} catch ( NonUniqueResultException $e ) {
			return $e->getMessage();
		}
	}
}
