<?php

namespace App\Repository;

use App\Entity\Assesment;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method Assesment|null find($id, $lockMode = null, $lockVersion = null)
 * @method Assesment|null findOneBy(array $criteria, array $orderBy = null)
 * @method Assesment[]    findAll()
 * @method Assesment[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class AssesmentRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, Assesment::class);
    }

    public function advanceSearch(ParameterBag $bag)
    {
        $queryBuilder = $this->createQueryBuilder('assesment');

        if ($bag->get('classes')) {
            $queryBuilder->add(
                'where',
                $queryBuilder->expr()
                    ->in('assesment.assesment_class', $bag->get('classes'))
            );
        }

        return $queryBuilder->getQuery()->getResult();

    }

    // /**
    //  * @return Assesment[] Returns an array of Assesment objects
    //  */
    /*
    public function findByExampleField($value)
    {
        return $this->createQueryBuilder('a')
            ->andWhere('a.exampleField = :val')
            ->setParameter('val', $value)
            ->orderBy('a.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
        ;
    }
    */

    /*
    public function findOneBySomeField($value): ?Assesment
    {
        return $this->createQueryBuilder('a')
            ->andWhere('a.exampleField = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
    */
}
