<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ScheduleMessageRepository")
 */
class ScheduleMessage {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $is_sent = false;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $is_cancel_before_sent = false;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $is_deleted = false;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	private $custom_message;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	private $custom_subject;

	/**
	 * @ORM\Column(type="datetime")
	 */
	private $sent_datetime;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\user", inversedBy="schedule_message_receiver")
	 * @ORM\JoinColumn(nullable=true)
	 */
	private $sent_to;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\EmailTemplates", inversedBy="scheduleMessages")
	 */
	private $email_template;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\ShortEmailTemplates", inversedBy="scheduleMessages")
	 */
	private $short_template;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\Guardian", inversedBy="scheduleMessages")
	 */
	private $guardian;

	public function getId(): ?int {
		return $this->id;
	}

	public function getIsSent(): ?bool {
		return $this->is_sent;
	}

	public function setIsSent( bool $is_sent ): self {
		$this->is_sent = $is_sent;

		return $this;
	}

	public function getIsCancelBeforeSent(): ?bool {
		return $this->is_cancel_before_sent;
	}

	public function setIsCancelBeforeSent( bool $is_cancel_before_sent ): self {
		$this->is_cancel_before_sent = $is_cancel_before_sent;

		return $this;
	}

	public function getIsDeleted(): ?bool {
		return $this->is_deleted;
	}

	public function setIsDeleted( bool $is_deleted ): self {
		$this->is_deleted = $is_deleted;

		return $this;
	}

	public function getCustomMessage(): ?string {
		return $this->custom_message;
	}

	public function setCustomMessage( ?string $custom_message ): self {
		$this->custom_message = $custom_message;

		return $this;
	}

	public function getCustomSubject(): ?string {
		return $this->custom_subject;
	}

	public function setCustomSubject( ?string $custom_subject ): self {
		$this->custom_subject = $custom_subject;

		return $this;
	}

	public function getSentDatetime(): ?\DateTimeInterface {
		return $this->sent_datetime;
	}

	public function setSentDatetime( \DateTimeInterface $sent_datetime ): self {
		$this->sent_datetime = $sent_datetime;

		return $this;
	}

	public function getSentTo(): ?user {
		return $this->sent_to;
	}

	public function setSentTo( ?user $sent_to ): self {
		$this->sent_to = $sent_to;

		return $this;
	}

	public function getEmailTemplate(): ?EmailTemplates {
		return $this->email_template;
	}

	public function setEmailTemplate( ?EmailTemplates $email_template ): self {
		$this->email_template = $email_template;

		return $this;
	}

	public function getShortTemplate(): ?ShortEmailTemplates {
		return $this->short_template;
	}

	public function setShortTemplate( ?ShortEmailTemplates $short_template ): self {
		$this->short_template = $short_template;

		return $this;
	}

	public function getGuardian(): ?Guardian {
		return $this->guardian;
	}

	public function setGuardian( ?Guardian $guardian ): self {
		$this->guardian = $guardian;

		return $this;
	}
}
