<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\SMSGatewaysRepository")
 */
class SMSGateways {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	private $sms_gw_name;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	private $sms_gw_header;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	private $sms_gw_footer;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $sms_gw_is_active;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $sms_gw_is_deleted = false;

	/**
	 * @ORM\Column(type="string", length=100)
	 */
	private $sms_gw_from;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	private $sms_gw_author_token;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	private $sms_gw_account_id;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	private $sms_gw_customer_id;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	private $sms_gw_service;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $endPoint;

	public function getId(): ?int {
         		return $this->id;
         	}

	public function getSmsGwName(): ?string {
         		return $this->sms_gw_name;
         	}

	public function setSmsGwName( string $sms_gw_name ): self {
         		$this->sms_gw_name = $sms_gw_name;
         
         		return $this;
         	}

	public function getSmsGwHeader(): ?string {
         		return $this->sms_gw_header;
         	}

	public function setSmsGwHeader( ?string $sms_gw_header ): self {
         		$this->sms_gw_header = $sms_gw_header;
         
         		return $this;
         	}

	public function getSmsGwFooter(): ?string {
         		return $this->sms_gw_footer;
         	}

	public function setSmsGwFooter( string $sms_gw_footer ): self {
         		$this->sms_gw_footer = $sms_gw_footer;
         
         		return $this;
         	}

	public function getSmsGwIsActive(): ?bool {
         		return $this->sms_gw_is_active;
         	}

	public function setSmsGwIsActive( bool $sms_gw_is_active ): self {
         		$this->sms_gw_is_active = $sms_gw_is_active;
         
         		return $this;
         	}

	public function getSmsGwIsDeleted(): ?bool {
         		return $this->sms_gw_is_deleted;
         	}

	public function setSmsGwIsDeleted( bool $sms_gw_is_deleted ): self {
         		$this->sms_gw_is_deleted = $sms_gw_is_deleted;
         
         		return $this;
         	}

	public function getSmsGwFrom(): ?string {
         		return $this->sms_gw_from;
         	}

	public function setSmsGwFrom( string $sms_gw_from ): self {
         		$this->sms_gw_from = $sms_gw_from;
         
         		return $this;
         	}

	public function getSmsGwAuthorToken(): ?string {
         		return $this->sms_gw_author_token;
         	}

	public function setSmsGwAuthorToken( string $sms_gw_author_token ): self {
         		$this->sms_gw_author_token = $sms_gw_author_token;
         
         		return $this;
         	}

	public function getSmsGwAccountId(): ?string {
         		return $this->sms_gw_account_id;
         	}

	public function setSmsGwAccountId( ?string $sms_gw_account_id ): self {
         		$this->sms_gw_account_id = $sms_gw_account_id;
         
         		return $this;
         	}

	public function getSmsGwCustomerId(): ?string {
         		return $this->sms_gw_customer_id;
         	}

	public function setSmsGwCustomerId( ?string $sms_gw_customer_id ): self {
         		$this->sms_gw_customer_id = $sms_gw_customer_id;
         
         		return $this;
         	}

	public function getSmsGwService(): ?string {
         		return $this->sms_gw_service;
         	}

	public function setSmsGwService( string $sms_gw_service ): self {
         		$this->sms_gw_service = $sms_gw_service;
         
         		return $this;
         	}

    public function getEndPoint(): ?string
    {
        return $this->endPoint;
    }

    public function setEndPoint(?string $endPoint): self
    {
        $this->endPoint = $endPoint;

        return $this;
    }
}
