<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\LibrarySectionsRepository")
 */
class LibrarySections {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=60)
	 */
	private $ls_name;

	/**
	 * @ORM\Column(type="smallint", nullable=true)
	 */
	private $ls_parent = 0;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\BooksLibrary", mappedBy="librarySections")
	 */
	private $library_books;

	public function __construct() {
		$this->library_books = new ArrayCollection();
	}


	public function getId(): ?int {
		return $this->id;
	}

	public function getLsName(): ?string {
		return $this->ls_name;
	}

	public function setLsName( string $ls_name ): self {
		$this->ls_name = $ls_name;

		return $this;
	}

	public function getLsParent(): ?int {
		return $this->ls_parent;
	}

	public function setLsParent( int $ls_parent ): self {
		$this->ls_parent = $ls_parent;

		return $this;
	}

	/**
	 * @return Collection|BooksLibrary[]
	 */
	public function getLibraryBooks(): Collection {
		return $this->library_books;
	}

	public function addLibraryBook( BooksLibrary $libraryBook ): self {
		if ( ! $this->library_books->contains( $libraryBook ) ) {
			$this->library_books[] = $libraryBook;
			$libraryBook->setLibrarySections( $this );
		}

		return $this;
	}

	public function removeLibraryBook( BooksLibrary $libraryBook ): self {
		if ( $this->library_books->contains( $libraryBook ) ) {
			$this->library_books->removeElement( $libraryBook );
			// set the owning side to null (unless already changed)
			if ( $libraryBook->getLibrarySections() === $this ) {
				$libraryBook->setLibrarySections( null );
			}
		}

		return $this;
	}


}
