<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassSubjectRepository")
 */
class ClassSubject
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $marks;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $pass_marks;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $credits;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $fee;


    /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
    private $subject_name;

    /**
     * @ORM\Column(type="string", length=30, nullable=true)
     */
    private $short_name;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="classSubject__")
     * @ORM\JoinColumn(nullable=false)
     */
    private $classes__;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSubjectTemplate", inversedBy="classSubjects")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class_subject_template__;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSessionEnrolmentSubjects", mappedBy="classSubject",
     *                                                                         orphanRemoval=true)
     */
    private $class_session_enrolment_subject;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ExamsClasses", mappedBy="ClassSubject")
     */
    private $examsClasses;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ExamsClassesStudent", mappedBy="class_subject")
     */
    private $examsClassesStudents;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\AllocateTeacherToClassAndSubjects", mappedBy="class_subject")
     */
    private $allocateTeacherToClassAndSubjects;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassFeeSchedule", mappedBy="class_subject")
     */
    private $classFeeSchedules;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Subjects", inversedBy="classSubjects")
     * @ORM\JoinColumn(nullable=false)
     */
    private $subject;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassTimeTableSegments", mappedBy="class_subject")
     */
    private $classTimeTableSegments;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Assesment", mappedBy="assessment_subject")
     */
    private $assesments;

    /**
     * @ORM\OneToOne(targetEntity="App\Entity\VirtualClassRoom", mappedBy="class_subjects", cascade={"persist", "remove"})
     */
    private $virtualClassRoom;


    public function __construct()
    {
        //$this->class_subject_template = new ArrayCollection();
        $this->classSessionEnrolmentSubjects_ = new ArrayCollection();
        $this->class_session_enrolment_subject = new ArrayCollection();
        $this->examsClasses = new ArrayCollection();
        $this->examsClassesStudents = new ArrayCollection();
        $this->allocateTeacherToClassAndSubjects = new ArrayCollection();
        $this->classFeeSchedules = new ArrayCollection();
        $this->classTimeTableSegments = new ArrayCollection();
        $this->assesments = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getMarks(): ?int
    {
        return $this->marks;
    }

    public function setMarks(?int $marks): self
    {
        $this->marks = $marks;

        return $this;
    }

    public function getPassMarks(): ?int
    {
        return $this->pass_marks;
    }

    public function setPassMarks(?int $pass_marks): self
    {
        $this->pass_marks = $pass_marks;

        return $this;
    }

    public function getCredits(): ?int
    {
        return $this->credits;
    }

    public function setCredits(?int $credits): self
    {
        $this->credits = $credits;

        return $this;
    }

    public function getFee(): ?float
    {
        return $this->fee;
    }

    public function setFee(?float $fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    /*
     * @return Collection|subjects[]
     */
    /*public function getSubject(): Collection {
        return $this->subject;
    }

    public function addSubject( subjects $subject ): self {
        if ( ! $this->subject->contains( $subject ) ) {
            $this->subject[] = $subject;
        }

        return $this;
    }

    public function removeSubject( subjects $subject ): self {
        if ( $this->subject->contains( $subject ) ) {
            $this->subject->removeElement( $subject );
        }

        return $this;
    }*/

    /*
     * @deprecated 25-07-2019
     * @return Collection|ClassSubjectTemplate[]
     */
    /*public function getClassSubjectTemplate(): Collection {
        return $this->class_subject_template;
    }

    public function addClassSubjectTemplate( ClassSubjectTemplate $classSubjectTemplate ): self {
        if ( ! $this->class_subject_template->contains( $classSubjectTemplate ) ) {
            $this->class_subject_template[] = $classSubjectTemplate;
        }

        return $this;
    }

    public function removeClassSubjectTemplate( ClassSubjectTemplate $classSubjectTemplate ): self {
        if ( $this->class_subject_template->contains( $classSubjectTemplate ) ) {
            $this->class_subject_template->removeElement( $classSubjectTemplate );
        }

        return $this;
    }*/

    public function getSubjectName(): ?string
    {
        return $this->subject_name;
    }

    public function setSubjectName(?string $subject_name): self
    {
        $this->subject_name = $subject_name;

        return $this;
    }

    public function getShortName(): ?string
    {
        return $this->short_name;
    }

    public function setShortName(?string $short_name): self
    {
        $this->short_name = $short_name;

        return $this;
    }

    public function getClasses(): ?Classes
    {
        return $this->classes__;
    }

    public function setClasses(?Classes $classes__): self
    {
        $this->classes__ = $classes__;

        return $this;
    }

    public function getClassSubjectTemplate(): ?ClassSubjectTemplate
    {
        return $this->class_subject_template__;
    }

    public function setClassSubjectTemplate(?ClassSubjectTemplate $class_subject_template__): self
    {
        $this->class_subject_template__ = $class_subject_template__;

        return $this;
    }

    /**
     * @return Collection|ClassSessionEnrolmentSubjects[]
     */
    public function getClassSessionEnrolmentSubject(): Collection
    {
        return $this->class_session_enrolment_subject;
    }

    public function addClassSessionEnrolmentSubject(ClassSessionEnrolmentSubjects $classSessionEnrolmentSubject): self
    {
        if (!$this->class_session_enrolment_subject->contains($classSessionEnrolmentSubject)) {
            $this->class_session_enrolment_subject[] = $classSessionEnrolmentSubject;
            $classSessionEnrolmentSubject->setClassSubject($this);
        }

        return $this;
    }

    public function removeClassSessionEnrolmentSubject(ClassSessionEnrolmentSubjects $classSessionEnrolmentSubject): self
    {
        if ($this->class_session_enrolment_subject->contains($classSessionEnrolmentSubject)) {
            $this->class_session_enrolment_subject->removeElement($classSessionEnrolmentSubject);
            // set the owning side to null (unless already changed)
            if ($classSessionEnrolmentSubject->getClassSubject() === $this) {
                $classSessionEnrolmentSubject->setClassSubject(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ExamsClasses[]
     */
    public function getExamsClasses(): Collection
    {
        return $this->examsClasses;
    }

    public function addExamsClass(ExamsClasses $examsClass): self
    {
        if (!$this->examsClasses->contains($examsClass)) {
            $this->examsClasses[] = $examsClass;
            $examsClass->setClassSubject($this);
        }

        return $this;
    }

    public function removeExamsClass(ExamsClasses $examsClass): self
    {
        if ($this->examsClasses->contains($examsClass)) {
            $this->examsClasses->removeElement($examsClass);
            // set the owning side to null (unless already changed)
            if ($examsClass->getClassSubject() === $this) {
                $examsClass->setClassSubject(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ExamsClassesStudent[]
     */
    public function getExamsClassesStudents(): Collection
    {
        return $this->examsClassesStudents;
    }

    public function addExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if (!$this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents[] = $examsClassesStudent;
            $examsClassesStudent->setClassSubject($this);
        }

        return $this;
    }

    public function removeExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if ($this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents->removeElement($examsClassesStudent);
            // set the owning side to null (unless already changed)
            if ($examsClassesStudent->getClassSubject() === $this) {
                $examsClassesStudent->setClassSubject(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    /**
     * @return Collection|AllocateTeacherToClassAndSubjects[]
     */
    public function getAllocateTeacherToClassAndSubjects(): Collection
    {
        return $this->allocateTeacherToClassAndSubjects;
    }

    public function addAllocateTeacherToClassAndSubject(AllocateTeacherToClassAndSubjects $allocateTeacherToClassAndSubject): self
    {
        if (!$this->allocateTeacherToClassAndSubjects->contains($allocateTeacherToClassAndSubject)) {
            $this->allocateTeacherToClassAndSubjects[] = $allocateTeacherToClassAndSubject;
            $allocateTeacherToClassAndSubject->setClassSubject($this);
        }

        return $this;
    }

    public function removeAllocateTeacherToClassAndSubject(AllocateTeacherToClassAndSubjects $allocateTeacherToClassAndSubject): self
    {
        if ($this->allocateTeacherToClassAndSubjects->contains($allocateTeacherToClassAndSubject)) {
            $this->allocateTeacherToClassAndSubjects->removeElement($allocateTeacherToClassAndSubject);
            // set the owning side to null (unless already changed)
            if ($allocateTeacherToClassAndSubject->getClassSubject() === $this) {
                $allocateTeacherToClassAndSubject->setClassSubject(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassFeeSchedule[]
     */
    public function getClassFeeSchedules(): Collection
    {
        return $this->classFeeSchedules;
    }

    public function addClassFeeSchedule(ClassFeeSchedule $classFeeSchedule): self
    {
        if (!$this->classFeeSchedules->contains($classFeeSchedule)) {
            $this->classFeeSchedules[] = $classFeeSchedule;
            $classFeeSchedule->setClassSubject($this);
        }

        return $this;
    }

    public function removeClassFeeSchedule(ClassFeeSchedule $classFeeSchedule): self
    {
        if ($this->classFeeSchedules->contains($classFeeSchedule)) {
            $this->classFeeSchedules->removeElement($classFeeSchedule);
            // set the owning side to null (unless already changed)
            if ($classFeeSchedule->getClassSubject() === $this) {
                $classFeeSchedule->setClassSubject(null);
            }
        }

        return $this;
    }

    public function getSubject(): ?Subjects
    {
        return $this->subject;
    }

    public function setSubject(?Subjects $subject): self
    {
        $this->subject = $subject;

        return $this;
    }

    /**
     * @return Collection|ClassTimeTableSegments[]
     */
    public function getClassTimeTableSegments(): Collection
    {
        return $this->classTimeTableSegments;
    }

    public function addClassTimeTableSegment(ClassTimeTableSegments $classTimeTableSegment): self
    {
        if (!$this->classTimeTableSegments->contains($classTimeTableSegment)) {
            $this->classTimeTableSegments[] = $classTimeTableSegment;
            $classTimeTableSegment->setClassSubject($this);
        }

        return $this;
    }

    public function removeClassTimeTableSegment(ClassTimeTableSegments $classTimeTableSegment): self
    {
        if ($this->classTimeTableSegments->contains($classTimeTableSegment)) {
            $this->classTimeTableSegments->removeElement($classTimeTableSegment);
            // set the owning side to null (unless already changed)
            if ($classTimeTableSegment->getClassSubject() === $this) {
                $classTimeTableSegment->setClassSubject(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Assesment[]
     */
    public function getAssesments(): Collection
    {
        return $this->assesments;
    }

    public function addAssesment(Assesment $assesment): self
    {
        if (!$this->assesments->contains($assesment)) {
            $this->assesments[] = $assesment;
            $assesment->setAssessmentSubject($this);
        }

        return $this;
    }

    public function removeAssesment(Assesment $assesment): self
    {
        if ($this->assesments->contains($assesment)) {
            $this->assesments->removeElement($assesment);
            // set the owning side to null (unless already changed)
            if ($assesment->getAssessmentSubject() === $this) {
                $assesment->setAssessmentSubject(null);
            }
        }

        return $this;
    }

    public function getVirtualClassRoom(): ?VirtualClassRoom
    {
        return $this->virtualClassRoom;
    }

    public function setVirtualClassRoom(VirtualClassRoom $virtualClassRoom): self
    {
        $this->virtualClassRoom = $virtualClassRoom;

        // set the owning side of the relation if necessary
        if ($this !== $virtualClassRoom->getClassSubjects()) {
            $virtualClassRoom->setClassSubjects($this);
        }

        return $this;
    }


}
