<?php

namespace App\Controller;

use App\Repository\AttendanceStatusRepository;
use App\Repository\UserRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 * @IsGranted("ROLE_ADMIN")
 * */
class AdminController extends AbstractController
{


    /**
     * @var UserRepository
     */
    private $user_repository;
    /**
     * @var AttendanceStatusRepository
     */
    private $attendanceStatusRepository;

    public function __construct(UserRepository $user_repository, AttendanceStatusRepository $attendanceStatusRepository)
    {
        $this->user_repository = $user_repository;
        $this->attendanceStatusRepository = $attendanceStatusRepository;
    }

    // Admin identifier
    const userCategory = 'a';

    /**
     * @Route("/{_locale}/admins/manage-admins/", name="admin_list")
     * ## get all admins list
     */
    public function index()
    {
        return $this->render('admin/index.html.twig', [
            'list' => $this->user_repository->findBy(['category' => self::userCategory], ['id' => 'DESC']),
        ]);
    }


    /**
     * @Route("/{_locale}/admins/mark-attendance/", name="admin_mark_attendance")
     * ## get the teacher's list
     * @param Request $request
     * @return Response
     */
    public function markAttendance(Request $request)
    {
        $bag = new ParameterBag();
        $bag->set('in_date', $request->get('in_date'));
        $bag->set('userCatRef', self::userCategory);

        return $this->render('teacher/markAttendance.html.twig', [
            '__user_list' => $this->user_repository->loadAttendanceOfTeacherAndStaff($bag),
            'attendance__status' => $this->attendanceStatusRepository->findBy(['enable' => 1]),
            'userCategory' => self::userCategory,
            'in_date' => $bag->get('in_date'),
        ]);
    }
}
