<?php


namespace App\Service\ScheduleMessagesService;


use App\Entity\ScheduleMessage;
use App\Entity\User;
use App\Repository\ScheduleMessageRepository;
use App\Service\DefaultFunction;
use App\Service\Guardian\GuardianService;
use App\Service\Teacher\teacherAllocationService;
use App\Service\UserService;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Snappy\Pdf;
use Symfony\Component\HttpFoundation\ParameterBag;

class Base extends Files {

	/**
	 * @var DefaultFunction
	 */
	public $defaultFunction;
	/**
	 * @var Pdf
	 */
	public $pdf;
	/**
	 * @var EntityManagerInterface
	 */
	public  $entityManager;
	/**
	 * @var ScheduleMessageRepository
	 */
	protected  $scheduleMessageRepository;
	/**
	 * @var UserService
	 */
	public  $userService;
	/**
	 * @var GuardianService
	 */
	public  $guardianService;
	/**
	 * @var teacherAllocationService
	 */
	public  $teacherAllocationService;
	/**
	 * @var Files
	 */
	public  $files;

	/**
	 * Base constructor.
	 *
	 * @param DefaultFunction           $defaultFunction
	 * @param Pdf                       $pdf
	 * @param EntityManagerInterface    $entityManager
	 * @param ScheduleMessageRepository $scheduleMessageRepository
	 * @param UserService               $userService
	 * @param GuardianService           $guardianService
	 * @param teacherAllocationService  $teacherAllocationService
	 * @param Files                     $files
	 */
	public function __construct( DefaultFunction $defaultFunction, Pdf $pdf, EntityManagerInterface $entityManager, ScheduleMessageRepository $scheduleMessageRepository, UserService $userService, GuardianService $guardianService, teacherAllocationService $teacherAllocationService, Files $files ) {
		$this->defaultFunction           = $defaultFunction;
		$this->pdf                       = $pdf;
		$this->entityManager             = $entityManager;
		$this->scheduleMessageRepository = $scheduleMessageRepository;
		$this->userService               = $userService;
		$this->guardianService           = $guardianService;
		$this->teacherAllocationService  = $teacherAllocationService;
		$this->files                     = $files;
	}


	/**
	 * @param ParameterBag $bag
	 *
	 * @return array|mixed
	 */
	public function validateScheduleMessage( ParameterBag $bag ) {
		$returnAr = [];

		if ( empty( $bag->get( 'pathOfFile' ) ) ) {
			$returnAr = $this->defaultFunction->push_error( $returnAr, 'Report file is missing' );
		}

		if ( empty( $bag->get( 'students' ) ) && ! is_array( $bag->get( 'students' ) ) ) {
			$returnAr = $this->defaultFunction->push_error( $returnAr, 'Please select Student' );
		}

		return $returnAr;
	}

	/**
	 * @param ParameterBag $request
	 *
	 * @return array|mixed|string|null
	 */
	public function saveScheduleMessage( \Symfony\Component\HttpFoundation\ParameterBag $request ) {
		if ( ! empty( $validationResponse = $this->validateScheduleMessage( $request ) ) ) {
			return $validationResponse;
		}

		$returnResponse = null;
		$Entity         = null;
		if ( $request->get( '_smI' ) ) {
			$Entity = $this->getScheduleMessage( $request->get( '_smI' ) );
		}

		if ( ! $Entity instanceof ScheduleMessage ) {
			$Entity = new ScheduleMessage();
		}

		$listOfStudents = $this->userService->getBulkUserListFromUserIds( (array) $request->get( 'students' ) );
		$listOfAdmins   = $this->userService->getBulkUserListFromUserIds( (array) $request->get( 'administrators' ) );
		$listOfUser     = array_merge( $listOfStudents, $listOfAdmins );


		## check what list of user get.
		## get the list of attached teacher with the selected student
		if ( $request->get( 'teachersOfSelectedStudent' ) === 'on' ) {
			$listOfTeacher = $this->teacherAllocationService->getTeacherFromStudentRef( $listOfStudents );
			$listOfUser    = array_merge( $listOfUser, $listOfTeacher );
		}

		## get the list of attached guardian with the selected student
		if ( $request->get( 'guardiansOfSelectedStudent' ) === 'on' ) {
			$listOfGuardians = $this->guardianService->getGuardiansFromStudentRef( $listOfStudents );
			$listOfUser      = array_merge( $listOfUser, $listOfGuardians );
		}

		try {

			foreach ( $listOfUser as $key => $value ) {
				$Entity = new ScheduleMessage();
				$Entity->setCustomMessage( $request->get( 'appendMessage' ) );
				$Entity->setCustomSubject( $request->get( 'appendSubject' ) );
				if ( $value instanceof User ) {
					$Entity->setSentTo( $value );
				} else {
					$Entity->setGuardian( $value );
				}
				$Entity->setSentDatetime( $this->defaultFunction->convert_datetimeStringIntoObject( $request->get( 'sentDate' ) . ' ' . $request->get( 'sentTime' ) ) );
				$this->entityManager->persist( $Entity );
				$this->entityManager->flush();
				## copy file to the
				$this->files->moveFileToScheduleMessage( $request->get( 'pathOfFile' ), $Entity->getId() );
			}

			$returnResponse = 'OK';
		} catch ( \Exception $exception ) {
			$returnResponse = $exception->getMessage();
		}


		return $returnResponse;
	}

	/**
	 * @param int|null $id
	 *
	 * @return ScheduleMessage|string|null
	 * PURPOSE: Get the schedule message
	 */
	public function getScheduleMessage( int $id = null ) {
		$response = null;
		try {
			if ( ! empty( $id ) ) {
				$response = $this->scheduleMessageRepository->find( $id );
			}
		} catch ( \Exception $exception ) {
			$response = $exception->getMessage();
		}

		return $response;
	}

	/**
	 * PURPOSE: return the all schedule messages.
	 * */
	public function getScheduleMessages() {
		return $this->scheduleMessageRepository->findAll();
	}
}