<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Timestampable\Traits\Timestampable;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassTimeTableRepository")
 */
class ClassTimeTable
{
    use Timestampable;
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="time")
     * @Assert\NotBlank()
     */
    private $start_time;

    /**
     * @ORM\Column(type="time")
     * @Assert\Time()
     */
    private $end_time;

    /**
     * @ORM\Column(type="time", nullable=true)
     * @Assert\Time()
     */
    private $break_mints;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="classTimeTables")
     * @Assert\NotBlank()
     */
    private $class_ownership;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="classTimeTableOwnerShipTow")
     */
    private $class_ownership_two;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="classTimeTables")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotBlank()
     */
    private $class;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassTimeTableSegments", mappedBy="class_time_table", orphanRemoval=true)
     */
    private $classTimeTableSegments;

    /**
     * @ORM\Column(type="datetime")
     * @Assert\NotBlank()
     * @Gedmo\Timestampable(on="create")
     */
    private $created_at;

    /**
     * @ORM\Column(type="datetime")
     * @Assert\NotBlank()
     * @Gedmo\Timestampable(on="update")
     */
    private $updated_at;

    public function __construct()
    {
        $this->classTimeTableSegments = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStartTime(): ?\DateTimeInterface
    {
        return $this->start_time;
    }

    public function setStartTime(\DateTimeInterface $start_time): self
    {
        $this->start_time = $start_time;
        return $this;
    }

    public function getEndTime(): ?\DateTimeInterface
    {
        return $this->end_time;
    }

    public function setEndTime(\DateTimeInterface $end_time): self
    {
        $this->end_time = $end_time;

        return $this;
    }

    public function getBreakMints(): ?\DateTimeInterface
    {
        return $this->break_mints;
    }

    public function setBreakMints(?\DateTimeInterface $break_mints): self
    {
        $this->break_mints = $break_mints;

        return $this;
    }

    public function getClassOwnership(): ?User
    {
        return $this->class_ownership;
    }

    public function setClassOwnership(?User $class_ownership): self
    {
        $this->class_ownership = $class_ownership;

        return $this;
    }

    public function getClassOwnershipTwo(): ?User
    {
        return $this->class_ownership_two;
    }

    public function setClassOwnershipTwo(?User $class_ownership_two): self
    {
        $this->class_ownership_two = $class_ownership_two;

        return $this;
    }

    public function getClass(): ?Classes
    {
        return $this->class;
    }

    public function setClass(?Classes $class): self
    {
        $this->class = $class;

        return $this;
    }

    /**
     * @return Collection|ClassTimeTableSegments[]
     */
    public function getClassTimeTableSegments(): Collection
    {
        return $this->classTimeTableSegments;
    }

    public function addClassTimeTableSegment(ClassTimeTableSegments $classTimeTableSegment): self
    {
        if (!$this->classTimeTableSegments->contains($classTimeTableSegment)) {
            $this->classTimeTableSegments[] = $classTimeTableSegment;
            $classTimeTableSegment->setClassTimeTable($this);
        }

        return $this;
    }

    public function removeClassTimeTableSegment(ClassTimeTableSegments $classTimeTableSegment): self
    {
        if ($this->classTimeTableSegments->contains($classTimeTableSegment)) {
            $this->classTimeTableSegments->removeElement($classTimeTableSegment);
            // set the owning side to null (unless already changed)
            if ($classTimeTableSegment->getClassTimeTable() === $this) {
                $classTimeTableSegment->setClassTimeTable(null);
            }
        }

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeInterface
    {
        return $this->created_at;
    }

    public function setCreatedAt(\DateTimeInterface $created_at): self
    {
        $this->created_at = $created_at;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->updated_at;
    }

    public function setUpdatedAt(\DateTimeInterface $updated_at): self
    {
        $this->updated_at = $updated_at;

        return $this;
    }
}
