<?php

namespace App\Controller;

use App\Entity\ClassTimeTable;
use App\Entity\ClassTimeTableSegments;
use App\Repository\ClassTimeTableRepository;
use App\Repository\UserRepository;
use App\Service\DefaultFunction;
use App\Service\SubjectService;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use http\Env\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 * */
class ClassTimeTableController extends AbstractController
{

    /**
     * @var EntityManager
     */
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    /**
     * @Route("/class/ownership/{id}", name="class_owner_ship", defaults={"id"=null})
     * @param UserRepository $userRepository
     * @param \Symfony\Component\HttpFoundation\Request $request
     * @param DefaultFunction $defaultFunction
     * @param null $id
     * @return Response
     */
    public function index(
        UserRepository $userRepository,
        \Symfony\Component\HttpFoundation\Request $request,
        DefaultFunction $defaultFunction,
        $id = null
    ) {

        ## when s
        if ($request->isMethod('POST')) {
            try {


                $ClassTimeTable = null;

                ## if request to edit an existing record
                if (!empty($request->request->get('id'))) {
                    $ClassTimeTable = $this->entityManager->getRepository('App:ClassTimeTable')->find(
                        $request->request->get('id')
                    );
                }


                ## if classTimeTable is not initiate then create san object.
                if (!$ClassTimeTable instanceof ClassTimeTable) {
                    $ClassTimeTable = new ClassTimeTable();
                }

                ## set Class
                $ClassTimeTable->setClass(
                    $this->entityManager->getRepository('App:Classes')->find($request->request->get('class'))
                );
                ## set Class Start Time
                $ClassTimeTable->setStartTime(
                    $defaultFunction->convert_datetimeStringIntoObject($request->request->get('start_time'))
                );
                ## set class end time
                $ClassTimeTable->setEndTime(
                    $defaultFunction->convert_datetimeStringIntoObject($request->request->get('end_time'))
                );
                ## set break mints
                $ClassTimeTable->setBreakMints(
                    $defaultFunction->convert_datetimeStringIntoObject($request->request->get('break_mints'))
                );
                ## set teachers ownership.
                if (!empty($request->request->get('owners')[0])) {
                    $ClassTimeTable->setClassOwnership(
                        $this->entityManager->getRepository('App:User')->find($request->request->get('owners')[0])
                    );
                }

                ## set second teacher ownership.
                if (!empty($request->request->get('owners')[1])) {
                    $ClassTimeTable->setClassOwnershipTwo(
                        $this->entityManager->getRepository('App:User')->find($request->request->get('owners')[1])
                    );
                }

                $this->entityManager->persist($ClassTimeTable);
                $this->entityManager->flush();
                $this->addFlash('classOwnerShipFlashSuccess', 'Class OwnerShip has assigned to Teacher');

                return $this->redirectToRoute('class_owner_ship_list');
            } catch (\Exception $exception) {
                $this->addFlash('classOwnerShipFlashError', $exception->getMessage());
            }
        }

        ##
        $classTimeTable = new ClassTimeTable();
        if ($id) {
            $classTimeTable = $this->entityManager->getRepository('App:ClassTimeTable')->find($id);
        }

        return $this->render(
            'class/ownership/class_ownership.html.twig',
            [
                'classTimeTable' => $classTimeTable,
                'active_classes' => $this->entityManager->getRepository('App:Classes')->getActiveClassesOfActiveSession(
                    false
                ),
                'teachers' => $userRepository->findBy(
                    ['category' => TeacherController::userCategory, 'is_active' => 1, 'is_deleted' => 0],
                    ['id' => 'DESC']
                ),
            ]
        );
    }


    /**
     * @Route("/class/owner-ship", name="class_owner_ship_list")
     * @return Response
     */
    public function list_of_ClassOwnerShip()
    {
        return $this->render(
            'class/ownership/class_ownership_list.html.twig',
            [
                'classOwnerShips' => $this->entityManager->getRepository('App:ClassTimeTable')->findAll(),
            ]
        );
    }

    /**
     * @Route("/subject/owner-ship/{class_owner_ship_id}/{class_id}", name="subject_ownership", defaults={"class_owner_ship_id":null, "class_id":null})
     * @param SubjectService $subjectService
     * @param int $class_id
     * @param $class_owner_ship_id
     * @param \Symfony\Component\HttpFoundation\Request $request
     * @param DefaultFunction $defaultFunction
     * @return Response
     */
    public function assign_teachers_to_class_lecture(
        SubjectService $subjectService,
        int $class_id,
        $class_owner_ship_id,
        \Symfony\Component\HttpFoundation\Request $request,
        DefaultFunction $defaultFunction
    ) {

        if ($request->isMethod('POST')) {


            for ($x = 0; $x < count($request->request->get('classSubject')); $x++) {
                try {

                    if (empty($request->request->get('teacher')[$x])) {
                        $this->addFlash('classOwnerShipFlashError', 'Teacher is not selected');
                    } else {

                        $classTimeTableSegment = null;

                        if ($request->request->get('class_time_table_segment_id')) {
                            $classTimeTableSegment = $this->entityManager->getRepository(
                                'App:ClassTimeTableSegments'
                            )->find($request->request->get('class_time_table_segment_id'));
                        }

                        if (!$classTimeTableSegment instanceof ClassTimeTableSegments) {
                            $classTimeTableSegment = new ClassTimeTableSegments();
                        }


                        $classTimeTableSegment->setLectureDay(
                            $request->request->get('lectureDay')[$x]
                        );

                        ## Set Class Subject
                        $classTimeTableSegment->setClassSubject(
                            $this->entityManager->getRepository('App:ClassSubject')->find(
                                $request->request->get('classSubject')[$x]
                            )
                        );
                        $classTimeTableSegment->setClassTimeTable(
                            $this->entityManager->getRepository('App:ClassTimeTable')->find(
                                $request->request->get('classOwnerShip')
                            )
                        );
                        $classTimeTableSegment->setClass(
                            $this->entityManager->getRepository('App:Classes')->find($request->request->get('classId'))
                        );
                        $classTimeTableSegment->setTeacher(
                            $this->entityManager->getRepository('App:User')->find($request->request->get('teacher')[$x])
                        );
                        $classTimeTableSegment->setTeacherBackup(
                            $this->entityManager->getRepository('App:User')->find(
                                $request->request->get('teacher_two')[$x]
                            )
                        );
                        $classTimeTableSegment->setLectureName($request->request->get('lectureName')[$x]);
                        $classTimeTableSegment->setLectureDuration($request->request->get('lectureDuration')[$x]);
                        $classTimeTableSegment->setLectureStartTime(
                            $defaultFunction->convert_datetimeStringIntoObject(
                                $request->request->get('letctureStartTime')[$x]
                            )
                        );
                        $classTimeTableSegment->setLectureEndTime(
                            $defaultFunction->convert_datetimeStringIntoObject(
                                $request->request->get('letctureEndTime')[$x]
                            )
                        );
                        $classTimeTableSegment->setLectureDescription($request->request->get('lecturePurpose')[$x]);
                        $this->entityManager->persist($classTimeTableSegment);
                        $this->entityManager->flush();
                        $this->addFlash('classOwnerShipFlashSuccess', 'Subjects Time has been Scheduled ');
                    }
                } catch (\Exception $exception) {
                    $this->addFlash('classOwnerShipFlashError', $exception->getMessage());
                }
            }
        }

        ## if request to edit the single time table of subject
        if ($request->request->get('class_time_table_segment_id')) {
            return $this->redirectToRoute(
                'edit_single_time_table',
                [
                    'class_time_table_segment_id' => $request->request->get('class_time_table_segment_id'),
                ]
            );
        }


        return $this->render(
            'subject/ownership/ownership.html.twig',
            [
                'class_subject' => $this->entityManager->getRepository('App:ClassSubject')->findBy(
                    [
                        'classes__' => $class_id,
                        'is_deleted' => 0,
                    ]
                ),
                'teachers' => $this->entityManager->getRepository('App:User')->findBy(
                    [
                        'category' => TeacherController::userCategory,
                        'is_active' => 1,
                        'is_deleted' => 0,
                    ]
                ),
                'class' => $this->entityManager->getRepository('App:Classes')->find($class_id),
                'classTimeTable' => $this->entityManager->getRepository('App:ClassTimeTable')->find(
                    $class_owner_ship_id
                ),
            ]
        );
    }


    /**
     * @Route("/subject/owner-ship-list", name="subject_ownership_list")
     */
    public function assign_teachers_to_class_subject_lecture_list()
    {
        return $this->render(
            'class/TimeTable/class_time_table_list.html.twig',
            [
                'class_time_table' => $this->entityManager->getRepository('App:ClassTimeTableSegments')->findAll(),
            ]
        );
    }

    /**
     * @Route("/class-time-table/edit/{class_time_table_segment_id}", name="edit_single_time_table")
     * @param $class_time_table_segment_id
     * @return Response
     */
    public function edit_single_time_table($class_time_table_segment_id)
    {
        return $this->render(
            'class/TimeTable/edit_single_time_table.html.twig',
            [
                'class_time_table' => $this->entityManager->getRepository('App:ClassTimeTableSegments')->find(
                    $class_time_table_segment_id
                ),
                'teachers' => $this->entityManager->getRepository('App:User')->findBy(
                    [
                        'category' => TeacherController::userCategory,
                        'is_active' => 1,
                        'is_deleted' => 0,
                    ]
                ),
            ]
        );
    }
}
