<?php

namespace App\Command;

use App\Chat\Chat;
use App\Chat\ChatOperations;
use App\Chat\IoSecureServer;
use App\Service\DefaultFunction;
use Ratchet\Http\HttpServer;
use Ratchet\Server\IoServer;
use Ratchet\WebSocket\WsServer;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class WebSocketStratCommand extends Command {

	protected static $defaultName = 'WebSocketStrat';

	public function __construct( string $name = null ) {
		parent::__construct( $name );
	}


	protected function configure() {
		$this->setDescription( 'Start websocket server' );
	}

	protected function execute( InputInterface $input, OutputInterface $output ) {
		$io = new SymfonyStyle( $input, $output );

		## show results to console.
		$output->writeln( [
			'Chat socket',// A line
			'============',// Another line
			'Starting chat, open your browser.',// Empty line
		] );

		//$server = IoServer::factory( new HttpServer( new WsServer( new Chat() ) ), 8080 );
		$server = IoSecureServer::factory( new HttpServer( new WsServer( new Chat()) ), 8080 );
		$server->run();
	}
}
