<?php


namespace App\Service\SMSGateways;


use App\Entity\SMSGateways;

abstract class SMSGateWayInterface
{

    /**
     * @param SMSGateways $SMSGateways
     *
     * @param array $assets
     *
     * @return mixed
     * PURPOSE: Send Message to the user
     */
    abstract function sendMessage(SMSGateways $SMSGateways, array $assets);

    /**
     * @param SMSGateways $SMSGateways
     *
     * @return mixed
     * PURPOSE: Get SMS Api
     */
    public function getApiKey(SMSGateways $SMSGateways)
    {
        $returnResponse = null;
        if (!empty($SMSGateways->getSmsGwAuthorToken())) {
            $returnResponse = $SMSGateways->getSmsGwAuthorToken();
        }

        return $returnResponse;
    }

    /**
     * @param SMSGateways $SMSGateways
     *
     * @return mixed
     * PURPOSE: Get Account ID
     */
    public function getAccountId(SMSGateways $SMSGateways)
    {
        $returnResponse = null;
        if (!empty($SMSGateways->getSmsGwAccountId())) {
            $returnResponse = $SMSGateways->getSmsGwAccountId();
        }

        return $returnResponse;
    }


    /**
     * @param SMSGateways $SMSGateways
     *
     * @return mixed
     * PURPOSE: Get SMS Mask
     */
    public function getSMSMask(SMSGateways $SMSGateways)
    {
        $returnResponse = null;
        if (!empty($SMSGateways->getSmsGwFrom())) {
            $returnResponse = $SMSGateways->getSmsGwFrom();
        }

        return $returnResponse;
    }


    /**
     * @param SMSGateways $SMSGateways
     * Get the end point where we want to send request.
     *
     * @return string
     */
    public function endPoints(SMSGateways $SMSGateways)
    {
        $returnResponse = null;
        if (!empty($SMSGateways->getEndPoint())) {
            $returnResponse = $SMSGateways->getEndPoint();
        }

        return $returnResponse;
    }


    /**
     * @param $phoneNumber
     * Validating Phone Number
     *
     * @return string|null
     */
    public function validatePhoneNumber($phoneNumber)
    {
        $returnResponse = null;
        if (!empty($phoneNumber)) {
            $returnResponse = strtr(
                $phoneNumber,
                [
                    '+' => '',
                    ' ' => '',
                ]
            );
        }

        return $returnResponse;
    }


    /**
     * @param             $message
     *
     * @param SMSGateways $SMSGateways
     *
     * @return string|null
     */
    public function validateMessage($message, SMSGateways $SMSGateways)
    {
        $returnResponse = null;
        if (!empty($message)) {
//            $returnResponse = $SMSGateways->getSmsGwHeader().'\n'.$message.'\n'.$SMSGateways->getSmsGwFooter();
            $returnResponse = $message;
            $returnResponse = strip_tags($returnResponse);
        }

        return $returnResponse;
    }


    public function logging($message, $phoneNumber)
    {
        $projectDir = realpath(dirname(__DIR__.'/../../../../'));
        $logFile = $projectDir.'/sendMessagesLogs.log';

        file_put_contents(
            $logFile,
            $message.' to '.$phoneNumber.' phone'.PHP_EOL,
            FILE_APPEND
        );
    }

}
