<?php


namespace App\Service\Attendance;


use App\Entity\Attendance;
use App\Entity\AttendanceStatus;
use App\Entity\ClassSessionEnrolment;
use App\Entity\ClassSessionEnrolmentSubjects;
use App\Entity\User;
use App\Repository\AttendanceRepository;
use App\Repository\AttendanceStatusRepository;
use App\Repository\ClassSessionEnrolmentRepository;
use App\Repository\ClassSessionEnrolmentSubjectsRepository;
use App\Service\DefaultFunction;
use App\Service\StudentsEnrollment\Enrollments;
use App\Service\UserService;
use Doctrine\DBAL\Exception\ForeignKeyConstraintViolationException;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Tools\Console\Helper\EntityManagerHelper;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage;
use Symfony\Component\Security\Csrf\TokenStorage\TokenStorageInterface;
use Symfony\Component\Validator\Constraints\Date;

class Base
{


    private $errorArray = [];


    /**
     * @var AttendanceStatusRepository
     */
    private $attendance_status_repository;
    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;
    /**
     * @var AttendanceRepository
     */
    private $attendance_repository;
    /**
     * @var UserService
     */
    private $user_service;
    /**
     * @var TokenStorageInterface
     */
    private $token_storage;
    /**
     * @var ClassSessionEnrolmentRepository
     */
    private $class_session_enrolment_repository;
    /**
     * @var ClassSessionEnrolmentSubjectsRepository
     */
    private $class_session_enrolment_subjects_repository;
    /**
     * @var Enrollments
     */
    private $enrollments;

    /**
     * Base constructor.
     *
     * @param AttendanceStatusRepository $attendance_status_repository
     * @param DefaultFunction $default_function
     * @param EntityManagerInterface $entity_manager
     * @param AttendanceRepository $attendance_repository
     * @param UserService $user_service
     * @param \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface $token_storage
     * @param ClassSessionEnrolmentRepository $class_session_enrolment_repository
     * @param ClassSessionEnrolmentRepository $class_session_enrolment_repository
     */
    public function __construct(AttendanceStatusRepository $attendance_status_repository, DefaultFunction $default_function, EntityManagerInterface $entity_manager, AttendanceRepository $attendance_repository, UserService $user_service, \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface $token_storage, ClassSessionEnrolmentRepository $class_session_enrolment_repository, ClassSessionEnrolmentSubjectsRepository $class_session_enrolment_subjects_repository, Enrollments $enrollments)
    {
        $this->attendance_status_repository = $attendance_status_repository;
        $this->default_function = $default_function;
        $this->entity_manager = $entity_manager;
        $this->attendance_repository = $attendance_repository;
        $this->user_service = $user_service;
        $this->token_storage = $token_storage;
        $this->class_session_enrolment_repository = $class_session_enrolment_repository;
        $this->class_session_enrolment_subjects_repository = $class_session_enrolment_subjects_repository;
        $this->enrollments = $enrollments;
    }



    /*
     *  ========= Attendance Status
     *
     * */

    ## get the attendance status
    public function getAttendanceStatus($attendanceStatusId)
    {
        ## if attendance is not given or null
        if (empty($attendanceStatusId)) {
            return 'Invalid attendance status id.';
        }

        try {
            $response = $this->attendance_status_repository->find($attendanceStatusId);
        } catch (\Exception $exception) {
            $response = $this->default_function->push_error($this->errorArray, $exception->getMessage());
        }

        return $response;
    }

    ## save attendance status
    public function saveAttendanceStatus(ParameterBag $bag)
    {

        if (!empty($bag->get('___rand__attedance__type_ref'))) {
            ## add new attendance status.
            $attendanceType = $this->getAttendanceStatus($bag->get('___rand__attedance__type_ref'));

            ## if attendance status is not found the return him back.
            if (!$attendanceType instanceof AttendanceStatus) {
                $this->errorArray = $this->default_function->push_error($this->errorArray, 'Invalid attendance status to edit');
            }

        } else {
            ## update existing attendance status.
            $attendanceType = new AttendanceStatus();
        }


        ## return back if we''ve any error.
        if (!empty($this->errorArray)) {
            return $this->errorArray;
        }

        try {

            $attendanceType->setName($bag->get('name'));
            $attendanceType->setDescription($bag->get('description'));

            if ($bag->get('enable_disable__') == 'on') {
                $attendanceType->setEnable(true);
            } else {
                $attendanceType->setEnable(false);
            }

            $attendanceType->setType($bag->get('status'));

            $this->entity_manager->persist($attendanceType);
            $this->entity_manager->flush();

        } catch (\Exception $exception) {
            $this->errorArray = $this->default_function->push_error($this->errorArray, $exception->getMessage());
        }

        if (empty($this->errorArray)) {
            return 'OK';
        } else {
            return $this->errorArray;
        }

    }

    ## delete attendance status
    public function deleteAttendanceStatus($reference)
    {
        /** @var AttendanceStatus $attendanceStatus */
        $attendanceStatus = $this->getAttendanceStatus($reference);
        $response = null;
        if ($attendanceStatus instanceof AttendanceStatus) {
            try {

                ## disable the attendance status
                $attendanceStatus->setEnable(false);
                $this->entity_manager->persist($attendanceStatus);
                $this->entity_manager->flush();

                ## remove the attendance status
                $this->entity_manager->remove($attendanceStatus);
                $this->entity_manager->flush();
                $response = 'OK';

            } catch (ForeignKeyConstraintViolationException $exception) {
                $response = 'This status has attached to multiple attendances, That\'s why system hide this status';
            }

        } else {
            $response = 'No, such attendance status in the list';
        }


        return $response;

    }

    ## get attendance
    public function getAttendance(int $id)
    {
        $response = null;
        try {
            $response = $this->attendance_repository->find($id);
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;
    }

    /**
     *  ========= Attendance
     *
     * */
    ## edit or add the attendance.
    public function saveAttendance(ParameterBag $request)
    {
        $returnResponse = [];
        $Attendance = null;

        if (!empty($request->get('r___ref_re'))) {
            $Attendance = $this->getAttendance($request->get('r___ref_re'));
        }

        ## if attendance is not found
        if (!$Attendance instanceof Attendance) {
            $Attendance = new Attendance();
        }


        ## get the user who's attendance going to mapped.
        $User = $this->user_service->pre__userCheck($request);

        ## if user is not found in the data then sent an error
        if (!$User instanceof User) {
            $returnResponse = $this->default_function->push_error($returnResponse, 'Trying to add attendance of that user, which is not in registered.');
        }

        ## return back if we had an error
        if (!empty($returnResponse)) {
            return $returnResponse;
        }

        ## get the attendance status.
        $AttendanceStatus = $this->getAttendanceStatus($request->get('__attendance__status'));
        ## if attendance status is invalid.
        if (!$AttendanceStatus instanceof AttendanceStatus) {
            $returnResponse = $this->default_function->push_error($returnResponse, 'Try to add invalid, attendance status');
        }

        ## return back if we had an error
        if (!empty($returnResponse)) {
            return $returnResponse;
        }

        ## get the blame user - who is adding a user attendance.
        /** @var User $blameuser */
        $blameuser = $this->token_storage->getToken()->getUser();

        ## get in and out time for the attendance.
        try {
            $in__datetime = new \DateTime($request->get('in___date'));
            $out__datetime = new \DateTime($request->get('out__date'));
        } catch (\Exception $exception) {
            $in__datetime = new \DateTime('now');
            $out__datetime = new \DateTime('now');
        }


        $ClassSessionEnrollment = null;
        $ClassSessionEnrollmentSubject = null;

        ## when try to add new record in the attendance table.
        if (!empty($request->get('c___'))) {
            $request->set('is_deleted', false);
            ## get the classSessionEnrollment for which attendance is marking.
            $ClassSessionEnrollment = $this->enrollments->get___classSessionEnrollmentOfUser($request);
        }

        ## if subjects are selected.
        if (!empty($request->get('s___ref'))) {
            ## get the classSessionSubjectEnrollment for which attendance is marking.
            $ClassSessionEnrollmentSubject = isset($this->enrollments->getEnrolledUserOnBaseOfSubjects($request)[0]) ? $this->enrollments->getEnrolledUserOnBaseOfSubjects($request)[0] : null;
        }

        ## return back if we had an error
        if (!empty($returnResponse)) {
            return $returnResponse;
        }


        ## save data in the table.
        try {

            $Attendance->setUser($User);
            $Attendance->setAttendanceStatus($AttendanceStatus);
            $Attendance->setAttendanceStatusType($AttendanceStatus->getType());
            $Attendance->setClassSessionEnrolmentSubject($ClassSessionEnrollmentSubject);
            $Attendance->setBlameUser($blameuser);
            $Attendance->setClassSessionEnrolment($ClassSessionEnrollment);
            $Attendance->setComments($request->get('a___notes'));
            $Attendance->setDatetimeIn($in__datetime);
            $Attendance->setDatetimeOut($out__datetime);
            $this->entity_manager->persist($Attendance);
            $this->entity_manager->flush();
        } catch (\Exception $exception) {
            $returnResponse = $this->default_function->push_error($returnResponse, $exception->getMessage());
        }


        if (empty($returnResponse)) {
            ## if error is not captured
            if ($request->get('returnOkIfGoesWell')) {
                $returnResponse = 'OK';
            } else {
                $returnResponse = $Attendance;
            }
        }

        return $returnResponse;

    }

    ## save attendance in the bulk
    public
    function bulkSaveAttendance(ParameterBag $bag)
    {

        $f_response = null;
//        if (is_array($bag->get('r___ref_re'))) {
        $response = [];
        ## if user wants to save the attendance in the bulk

        foreach ($bag as $key => $value) {
            $singleBag = new ParameterBag();
            $singleBag->set('r___ref_re', empty($value['r___ref_re']) ? 0 : $value['r___ref_re']);
            $singleBag->set('__attendance__status', $value['__attendance__status']);
            $singleBag->set('a___notes', $value['a___notes']);
            $singleBag->set('s___ref', empty($value['s___ref']) ? 0 : $value['s___ref']);
            $singleBag->set('in___date', $value['in___date']);
            $singleBag->set('in__time', $value['in__time']);
            $singleBag->set('out__date', $value['out__date']);
            $singleBag->set('out_time', $value['out_time']);
            $singleBag->set('id', $value['id']);
            $singleBag->set('c___', empty($value['c___']) ? 0 : $value['c___']);
            $singleBag->set('returnOkIfGoesWell', true);
            $response_ = $this->saveAttendance($singleBag);
            $response = $this->default_function->push_error($response, $response_);
            //$response = $this->default_function->push_error($response, );
        }
        $f_response = $this->default_function->purify_success_error_response_in_bulk_operation($response);


        return $f_response;
    }

    ## load attendance
    public
    function load__attendances(ParameterBag $bag)
    {

    }

    /**
     *  Attendance reporting - moulding data in the form
     * */
    public function mouldingAttendanceDataIntoClassBasedDateRangeReport($dataBaseRecords) {

    }


}