<?php

namespace App\Repository;

use App\Entity\PaymentMethods;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method PaymentMethods|null find( $id, $lockMode = null, $lockVersion = null )
 * @method PaymentMethods|null findOneBy( array $criteria, array $orderBy = null )
 * @method PaymentMethods[]    findAll()
 * @method PaymentMethods[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class PaymentMethodsRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, PaymentMethods::class );
	}

	## find Not One By
	## this method is used to find out there where "$value" of specific column is not equal to, of special user.
	public function findNotOneBy( string $key, $value, int $PMID ) {

		return $this->createQueryBuilder( 'paymentMethods' )
		            ->where( sprintf( 'paymentMethods.%s= :value', $key ) )
		            ->andWhere( 'paymentMethods.id != :pMID' )
		            ->setParameter( 'value', $value )
		            ->setParameter( 'pMID', $PMID )
		            ->getQuery()
		            ->getResult();

	}

	// /**
	//  * @return PaymentMethods[] Returns an array of PaymentMethods objects
	//  */
	/*
	public function findByExampleField($value)
	{
		return $this->createQueryBuilder('p')
			->andWhere('p.exampleField = :val')
			->setParameter('val', $value)
			->orderBy('p.id', 'ASC')
			->setMaxResults(10)
			->getQuery()
			->getResult()
		;
	}
	*/

	/*
	public function findOneBySomeField($value): ?PaymentMethods
	{
		return $this->createQueryBuilder('p')
			->andWhere('p.exampleField = :val')
			->setParameter('val', $value)
			->getQuery()
			->getOneOrNullResult()
		;
	}
	*/
}
