<?php

namespace App\Repository;

use App\Entity\ClassTemplate;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method ClassTemplate|null findOneBy(array $criteria, array $orderBy = null)
 * @method ClassTemplate[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ClassTemplateRepository extends ServiceEntityRepository
{

    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ClassTemplate::class);
    }


    /**
     * @param $id
     * @param null $lockMode
     * @param null $lockVersion
     * @return mixed|object|null
     * @throws NonUniqueResultException
     * @throws \Doctrine\ORM\NoResultException
     */
    public function find($id, $lockMode = null, $lockVersion = null)
    {
        return $this->createQueryBuilder('class_template')
            ->where('class_template.id = :id')
            ->setParameter('id', $id)
            ->getQuery()
            ->getSingleResult();
    }

    public function findAll()
    {
        return $this->createQueryBuilder('class_template')->getQuery()->getResult();
    }

    ## duplication check
    public function duplicationCheck(\Symfony\Component\HttpFoundation\ParameterBag $bagDuplication)
    {
        ## query Builder
        $queryBuilder = $this->createQueryBuilder('class_template');

        if (!empty($bagDuplication->get('name'))) {
            $queryBuilder->andWhere('class_template.name = :name')->setParameter('name', $bagDuplication->get('name'));
        }

        if (!empty($bagDuplication->get('whereNotIn'))) {
            $queryBuilder->andWhere('class_template.id <> :notCheck')->setParameter('notCheck', $bagDuplication->get('whereNotIn'));
        }

        $queryBuilder->andWhere('class_template.is_deleted = false');
        return $queryBuilder->getQuery()->getResult();

    }

    ## find all non deleted records.
    public function findAllNonDeleted()
    {
        return $this->createQueryBuilder('class_template')->andWhere('class_template.is_deleted = false')->getQuery()->getResult();
    }

    ## list of al class templates
    public function listOfClassTemplate(bool $parse__YesNoToBoolean)
    {
        ## class template  query builder
        $queryBuilder = $this->createQueryBuilder('class_template');

        ## ignore delete records
        if (!$parse__YesNoToBoolean) {
            $queryBuilder = $queryBuilder->andWhere('class_template.is_deleted = 0');
        }
        return $queryBuilder->orderBy('class_template.is_deleted', 'ASC')->getQuery()->getResult();
    }


}
