<?php

namespace App\Repository;

use App\Entity\Attendance;
use App\Entity\ClassSessionEnrolment;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\QueryBuilder;
use mysql_xdevapi\Exception;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method Attendance|null find($id, $lockMode = null, $lockVersion = null)
 * @method Attendance|null findOneBy(array $criteria, array $orderBy = null)
 * @method Attendance[]    findAll()
 * @method Attendance[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class AttendanceRepository extends ServiceEntityRepository
{

    /**
     * @var ClassSessionEnrolmentRepository
     */
    private $class_session_enrolment_repository;
    /**
     * @var RegistryInterface
     */
    private $registry;
    /**
     * @var ClassSessionEnrolmentSubjectsRepository
     */
    private $class_session_enrolment_subjects_repository;

    public function __construct(
        RegistryInterface $registry,
        ClassSessionEnrolmentRepository $class_session_enrolment_repository,
        ClassSessionEnrolmentSubjectsRepository $class_session_enrolment_subjects_repository
    ) {
        parent::__construct($registry, Attendance::class);
        $this->class_session_enrolment_repository = $class_session_enrolment_repository;
        $this->registry = $registry;
        $this->class_session_enrolment_subjects_repository = $class_session_enrolment_subjects_repository;
    }

    ## load attendances
    public function load__attendances(ParameterBag $bag)
    {

        $connection = $this->getEntityManager()->getConnection();
        $return___ar = [];
        $derived_attendance = null;

        ## query builder
        $queryBuilder = $this->createQueryBuilder('attendance');

        ## search of the in date.
        if (!empty($bag->get('in_date'))) {

            try {
                $in__date = new \DateTime($bag->get('in_date'));
                $in__date = $in__date->format('Y-m-d').'%';

                $queryBuilder->andWhere('attendance.datetime_in LIKE :in_date');
                $queryBuilder->setParameter('in_date', $in__date);
            } catch (\Exception $exception) {
                return $exception->getMessage();
            }
        }

        ## search for the class.
        if (!empty($bag->get('active__classes'))) {
            $ClassList = $this->class_session_enrolment_repository->get__EntrolledStudentList(
                $bag->get('active__classes'),
                false
            );
            $derived_attendance = $ClassList;
        }

        ## search for the subjects.
        if (!empty($bag->get('subject'))) {
            $StudentList = $this->class_session_enrolment_subjects_repository->get__EnrolledStudentList(
                $bag->get('subject')
            );
            $derived_attendance = $StudentList;
        }

        ## push data into the array.
        array_push($return___ar, $derived_attendance);
        ## list of all attendances.
        array_push($return___ar, $queryBuilder->getQuery()->getResult());

        return $return___ar;

    }

    ## attendance reporting has three aspects
    ## 1. Date Search
    ## 1.1 Marking attendance in & out time, Attendance marking or updating time.
    ## 2. Class Base Search
    ## 3. Student Base Search
    public function reporting__attendances(ParameterBag $bag)
    {

        $queryBuilder = $this->createQueryBuilder('attendance');
        $queryBuilder->leftJoin('attendance.class_session_enrolment', 'class_session_enrolment');
        $queryBuilder->leftJoin('attendance.class_session_enrolment_subject', 'class_session_enrolment_subject');
        $queryBuilder->leftJoin('attendance.user', 'user');

        if ($bag->get('userArray')) {
            $queryBuilder->add(
                'where',
                $queryBuilder->expr()->in('attendance.user', $bag->get('userArray'))
            );
        }

        ## Date based search
        ## attendance  from - to time.
        if (!empty($bag->get('attend_inTime'))) {
            ## InTime Search
            $queryBuilder->andWhere('attendance.datetime_in LIKE :attend_inTime');
            $queryBuilder->setParameter('attend_inTime', date('Y-m-d', strtotime($bag->get('attend_inTime'))).'%');
        }

        if (!empty($bag->get('attend_outTime'))) {
            ## OutTime Search
            $queryBuilder->andWhere('attendance.datetime_out LIKE :attend_outTime');
            $queryBuilder->setParameter('attend_outTime', date('Y-m-d', strtotime($bag->get('attend_inTime'))).'%');
        }

        ## Class session enrolment based search
        if (!empty($bag->get('class_session_enrolment'))) {
            $queryBuilder->andwhere('attendance.class_session_enrolment = :class_session_enrol');
            $queryBuilder->setParameter('class_session_enrol', $bag->get('class_session_enrolment'));
        }

        ## class based search
        if (!empty($bag->get('class'))) {
            $queryBuilder->andwhere('class_session_enrolment.class_session = :classRef');
            $queryBuilder->setParameter('classRef', $bag->get('class'));
        }

        if (!empty($bag->get('class_session_enrolmentINOperator'))) {
            $queryBuilder->add(
                'where',
                $queryBuilder->expr()
                    ->in('attendance.class_session_enrolment', $bag->get('class_session_enrolmentINOperator'))
            );
        }

        ## Subject Enrollment based search
        if (!empty($bag->get('subject_enrolment'))) {
            $queryBuilder->andwhere('attendance.class_session_enrolment_subject = :class_session_subject_enrol');
            $queryBuilder->setParameter('class_session_subject_enrol', $bag->get('subject_enrolment'));
        }

        ## classSubject based search
        if (!empty($bag->get('classSubject'))) {
            $queryBuilder->andwhere('class_session_enrolment_subject.classSubject = :classSubjectRef');
            $queryBuilder->setParameter('classSubjectRef', $bag->get('classSubject'));
        }

        ## Student based search
        if (!empty($bag->get('student__based'))) {
            $queryBuilder->andwhere('attendance.user = :student');
            $queryBuilder->setParameter('student', $bag->get('student__based'));
        }

        ## Attendance status, find present and absent and other which is added by user or custom added.\
        if (!empty($bag->get('attendance__status'))) {
            $queryBuilder->andwhere('attendance.attendance_status = :attendance__status');
            $queryBuilder->setParameter('attendance__status', $bag->get('attendance__status'));
        }

        ## Attendance Mark by this user.
        if (!empty($bag->get('attendance__markBy'))) {
            $queryBuilder->andwhere('attendance.blame_user = :attendance__markBy');
            $queryBuilder->setParameter('attendance__markBy', $bag->get('attendance__markBy'));
        }

        if ($bag->get('userCategory')) {
            $queryBuilder->andWhere('user.category = :userCategory')->setParameter(
                'userCategory',
                $bag->get('userCategory')
            );
        }

        ## get attendance range
        $queryBuilder = $this->getAttendanceRangeQuery($bag, $queryBuilder);

        return $queryBuilder->getQuery()->getResult();
    }

    ## Attendance Stats
    ## Still viewing on dashboard.
    public function get__attendanceStats__NoOfClassSessionEnrolmentOfActiveClassesAndActiveSession()
    {
        ## get the no of class session enrolment, of active classes., return data in array.
        $arrayOfClasses = $this->class_session_enrolment_repository->get__UniqueEnrolledClassesListInActiveSessionAndClasses__Reference(
            true
        );
        $arrayOfClasses = array_column($arrayOfClasses, 'id');
        $stringOfClasses = implode(',', $arrayOfClasses);

        $Bag = new ParameterBag();
        $Bag->set('class_session_enrolmentINOperator', $stringOfClasses);
        $Bag->set('attendance_markingDate', date('Y/m/d').' -');
        $AttendanceOfMarkOfClasses = $this->reporting__attendances($Bag);


        return $AttendanceOfMarkOfClasses;
    }

    ## Today's no of user persent in the active classes of active sessions.
    public function get__AttendanceOFPresentStudentAtTheActiveClassesOfActiveSessions()
    {
        return $this->class_session_enrolment_repository->getActiveClassOfActiveSession__QueryBuilder()
            ->leftJoin(
                'class_session_enrolment.attendances',
                'attendances',
                'class_session_enrolment.user_id_id = attendance.user_id and class_session_enrolment.id = attendance.class_session_enrolment_id'
            )
            ->where('attendances.id is not null')
            ->andWhere('attendances.created LIKE :attendaceMarkingDate')
            ->setParameter('attendaceMarkingDate', date('Y-m-d').'%')
            ->groupBy('class_session_enrolment.user_id')
            ->addGroupBy('class_session_enrolment.class_session')
            ->getQuery()
            ->getResult();

    }

    /**
     * @param ParameterBag $bag
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     * ## get the query attendance date range
     */
    public function getAttendanceRangeQuery(ParameterBag $bag, QueryBuilder $queryBuilder)
    {
        ## attendance  from - to time.
        if (!empty($bag->get('attendance_markingDate'))) {

            ## Convert string into an array
            $attendanceDate = explode(' / ', $bag->get('attendance_markingDate'));
            ## if array is created and duration date is exits then search in database
            if (is_array($attendanceDate) && !empty($attendanceDate[0] && !empty($attendanceDate[1]))) {
                ## InTime Search
                ## used in the duration
                $queryBuilder->andWhere('attendance.datetime_in BETWEEN :attendanceFrom and :attendanceTo');
                $queryBuilder->setParameter('attendanceFrom', date('Y-m-d', strtotime(trim($attendanceDate[0]))).'%');
                $queryBuilder->setParameter('attendanceTo', date('Y-m-d', strtotime(trim($attendanceDate[1]))).'%');

            } else {
                if (is_array($attendanceDate) && !empty($attendanceDate[0] && empty($attendanceDate[1]))) {
                    ## for only single date
                    $queryBuilder->where('attendance.datetime_in like :attendanceMarkingDate');
                    $queryBuilder->setParameter(
                        'attendanceMarkingDate',
                        date('Y-m-d', strtotime(trim($attendanceDate[0]))).'%'
                    );
                }
            }
        }

        return $queryBuilder;

    }

    public function getTodayAttendanceOfUser($userId)
    {
        return $this->createQueryBuilder('attendance')->where('attendance.user  = :userId')->setParameter(
            'userId',
            $userId
        )->andWhere('DATE(attendance.datetime_in) = DATE(NOW())')->getQuery()->getResult();
    }
}
