<?php


namespace App\Form\Model;

use Symfony\Component\Validator\Constraints as Assert;


class AddingCustomFieldsToUserFormModel {

	public $id;

	/**
	 * @Assert\NotBlank(message="Please type Field Label")
	 */
	public $label;

	/**
	 * @Assert\NotBlank(message="Please select field type")
	 */
	public $type;

	/**
	 *
	 */
	public $is_require;

	/**
	 */
	public $placeholder;

	/**
	 */
	public $admin;

	/**
	 */
	public $teacher;

	/**
	 */
	public $student;

	public $help_message;

	/**
	 *
	 * PURPOSE: If we choose dropdown or radio type input then we've to show some value in it.
	 * In the dropdown we've multiple options & also in the radio type input.
	 */
	public $options = [];


	public $visible_to;
	public $visible_in_registration_form;
	public $visible_in_registration_form_of;
	private $allowed_extension;

	public $section;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId( $id ): void {
		$this->id = $id;
	}


	/**
	 * @return mixed
	 */
	public function getLabel() {
		return $this->label;
	}

	/**
	 * @param mixed $label
	 */
	public function setLabel( $label ): void {
		$this->label = $label;
	}

	/**
	 * @return mixed
	 */
	public function getType() {
		return $this->type;
	}

	/**
	 * @param mixed $type
	 */
	public function setType( $type ): void {
		$this->type = $type;
	}

	/**
	 * @return mixed
	 */
	public function getIsRequire() {
		return $this->is_require;
	}

	/**
	 * @param mixed $is_require
	 */
	public function setIsRequire( $is_require ): void {
		$this->is_require = $is_require;
	}

	/**
	 * @return mixed
	 */
	public function getPlaceholder() {
		return $this->placeholder;
	}

	/**
	 * @param mixed $placeholder
	 */
	public function setPlaceholder( $placeholder ): void {
		$this->placeholder = $placeholder;
	}

	/**
	 * @return mixed
	 */
	public function getAdmin() {
		return $this->admin;
	}

	/**
	 * @param mixed $admin
	 */
	public function setAdmin( $admin ): void {
		$this->admin = $admin;
	}

	/**
	 * @return mixed
	 */
	public function getTeacher() {
		return $this->teacher;
	}

	/**
	 * @param mixed $teacher
	 */
	public function setTeacher( $teacher ): void {
		$this->teacher = $teacher;
	}

	/**
	 * @return mixed
	 */
	public function getStudent() {
		return $this->student;
	}

	/**
	 * @param mixed $student
	 */
	public function setStudent( $student ): void {
		$this->student = $student;
	}

	/**
	 * @return mixed
	 */
	public function getOptions() {
		return $this->options;
	}

	/**
	 * @param mixed $options
	 */
	public function setOptions( $options ): void {
		$this->options = $options;
	}


	/**
	 * @return mixed
	 */
	public function getVisibleTo() {
		return $this->visible_to;
	}

	/**
	 * @param mixed $visible_to
	 */
	public function setVisibleTo( $visible_to ): void {
		$this->visible_to = $visible_to;
	}

	/**
	 * @return mixed
	 */
	public function getVisibleInRegistrationFormOf() {
		return $this->visible_in_registration_form_of;
	}

	/**
	 * @param mixed $visible_in_registration_form_of
	 */
	public function setVisibleInRegistrationFormOf( $visible_in_registration_form_of ): void {
		$this->visible_in_registration_form_of = $visible_in_registration_form_of;
	}

	/**
	 * @return mixed
	 */
	public function getAllowedExtension() {
		return $this->allowed_extension;
	}

	/**
	 * @param mixed $allowed_extension
	 */
	public function setAllowedExtension( $allowed_extension ): void {
		$this->allowed_extension = $allowed_extension;
	}

	/**
	 * @return mixed
	 */
	public function getSection() {
		return $this->section;
	}

	/**
	 * @param mixed $section
	 */
	public function setSection( $section ): void {
		$this->section = $section;
	}

	/**
	 * @return mixed
	 */
	public function getHelpMessage() {
		return $this->help_message;
	}

	/**
	 * @param mixed $help_message
	 */
	public function setHelpMessage( $help_message ): void {
		$this->help_message = $help_message;
	}

}   