<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\PaymentMethodsRepository")
 */
class PaymentMethods
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $pm_type;

    /**
     * @ORM\Column(type="boolean")
     */
    private $pm_is_default;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Invoices", mappedBy="payment_method")
     */
    private $invoices;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Transactions", mappedBy="payment_method_reference")
     */
    private $transactions;

    public function __construct()
    {
        $this->invoices = new ArrayCollection();
        $this->transactions = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPmType(): ?string
    {
        return $this->pm_type;
    }

    public function setPmType(string $pm_type): self
    {
        $this->pm_type = $pm_type;

        return $this;
    }

    public function getPmIsDefault(): ?bool
    {
        return $this->pm_is_default;
    }

    public function setPmIsDefault(bool $pm_is_default): self
    {
        $this->pm_is_default = $pm_is_default;

        return $this;
    }

    /**
     * @return Collection|Invoices[]
     */
    public function getInvoices(): Collection
    {
        return $this->invoices;
    }

    public function addInvoice(Invoices $invoice): self
    {
        if (!$this->invoices->contains($invoice)) {
            $this->invoices[] = $invoice;
            $invoice->setPaymentMethod($this);
        }

        return $this;
    }

    public function removeInvoice(Invoices $invoice): self
    {
        if ($this->invoices->contains($invoice)) {
            $this->invoices->removeElement($invoice);
            // set the owning side to null (unless already changed)
            if ($invoice->getPaymentMethod() === $this) {
                $invoice->setPaymentMethod(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Transactions[]
     */
    public function getTransactions(): Collection
    {
        return $this->transactions;
    }

    public function addTransaction(Transactions $transaction): self
    {
        if (!$this->transactions->contains($transaction)) {
            $this->transactions[] = $transaction;
            $transaction->setPaymentMethodReference($this);
        }

        return $this;
    }

    public function removeTransaction(Transactions $transaction): self
    {
        if ($this->transactions->contains($transaction)) {
            $this->transactions->removeElement($transaction);
            // set the owning side to null (unless already changed)
            if ($transaction->getPaymentMethodReference() === $this) {
                $transaction->setPaymentMethodReference(null);
            }
        }

        return $this;
    }
}
