<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InventoryStockLocationRepository")
 */
class InventoryStockLocation
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $inventory_stock_location_name;

    /**
     * @ORM\Column(type="string", length=10, nullable=true)
     */
    private $inventory_stock_location_num;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InvtStockItems", mappedBy="inventory_item_location")
     */
    private $invtStockItems;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InventoryItemsUsage", mappedBy="inv_item_usage_location")
     */
    private $inventoryItemsUsages;

    public function __construct()
    {
        $this->invtStockItems = new ArrayCollection();
        $this->inventoryItemsUsages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getInventoryStockLocationName(): ?string
    {
        return $this->inventory_stock_location_name;
    }

    public function setInventoryStockLocationName(string $inventory_stock_location_name): self
    {
        $this->inventory_stock_location_name = $inventory_stock_location_name;

        return $this;
    }

    public function getInventoryStockLocationNum(): ?string
    {
        return $this->inventory_stock_location_num;
    }

    public function setInventoryStockLocationNum(?string $inventory_stock_location_num): self
    {
        $this->inventory_stock_location_num = $inventory_stock_location_num;

        return $this;
    }

    /**
     * @return Collection|InvtStockItems[]
     */
    public function getInvtStockItems(): Collection
    {
        return $this->invtStockItems;
    }

    public function addInvtStockItem(InvtStockItems $invtStockItem): self
    {
        if (!$this->invtStockItems->contains($invtStockItem)) {
            $this->invtStockItems[] = $invtStockItem;
            $invtStockItem->setInventoryItemLocation($this);
        }

        return $this;
    }

    public function removeInvtStockItem(InvtStockItems $invtStockItem): self
    {
        if ($this->invtStockItems->contains($invtStockItem)) {
            $this->invtStockItems->removeElement($invtStockItem);
            // set the owning side to null (unless already changed)
            if ($invtStockItem->getInventoryItemLocation() === $this) {
                $invtStockItem->setInventoryItemLocation(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|InventoryItemsUsage[]
     */
    public function getInventoryItemsUsages(): Collection
    {
        return $this->inventoryItemsUsages;
    }

    public function addInventoryItemsUsage(InventoryItemsUsage $inventoryItemsUsage): self
    {
        if (!$this->inventoryItemsUsages->contains($inventoryItemsUsage)) {
            $this->inventoryItemsUsages[] = $inventoryItemsUsage;
            $inventoryItemsUsage->setInvItemUsageLocation($this);
        }

        return $this;
    }

    public function removeInventoryItemsUsage(InventoryItemsUsage $inventoryItemsUsage): self
    {
        if ($this->inventoryItemsUsages->contains($inventoryItemsUsage)) {
            $this->inventoryItemsUsages->removeElement($inventoryItemsUsage);
            // set the owning side to null (unless already changed)
            if ($inventoryItemsUsage->getInvItemUsageLocation() === $this) {
                $inventoryItemsUsage->setInvItemUsageLocation(null);
            }
        }

        return $this;
    }
}
