<?php

namespace App\Controller;

use App\Service\FileManagment;
use App\Service\Students\Import\ImportStudentService;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Bundle\MakerBundle\FileManager;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Serializer\Encoder\CsvEncoder;

/**
 * @IsGranted("ROLE_USER")
 * */
class ImportCSVController extends AbstractController
{
    /**
     * @var FileManagment
     */
    private $fileManagement;


    /**
     * ImportCSVController constructor.
     * @param FileManagment $fileManagement
     */
    public function __construct(FileManagment $fileManagement)
    {
        $this->fileManagement = $fileManagement;
        ## import taking too much time to import data, that's why we are keeping max execution time limit to 0...
        ini_set('max_execution_time', 0);
    }

    /**
     * @Route("/{_locale}/importCsv/students", name="import_student_by_csv")
     * @param Request $request
     * @param ImportStudentService $importStudentService
     * @return Response
     */
    public function importStudents(Request $request, ImportStudentService $importStudentService)
    {
        $importResponse = $importStudentService->getCSVFileDataIntoArray($request, $this->fileManagement);
        if (empty($importResponse) && !is_array($importResponse)) {
            $importResponse = [];
        }

        $this->addFlash('importCSVResult', json_encode($importResponse));
        return $this->redirectToRoute('student_list');
    }
}