<?php


namespace App\Service;


use App\Entity\InventoryCategory;
use App\Entity\InventoryItemsUsage;
use App\Entity\InventoryStock;
use App\Entity\InventoryStockLocation;
use App\Entity\InvtStockItems;
use App\Entity\LibraryBooksCategory;
use App\Repository\InventoryCategoryRepository;
use App\Repository\InventoryItemsUsageRepository;
use App\Repository\InventoryStockLocationRepository;
use App\Repository\InventoryStockRepository;
use App\Repository\InvtStockItemsRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\ParameterBag;
use Twig\Environment;

class SchoolInventoryService {


	/**
	 * @var DefaultFunction
	 */
	private $default_function;
	/**
	 * @var InventoryCategoryRepository
	 */
	private $inventory_category_repository;
	/**
	 * @var EntityManagerInterface
	 */
	private $entity_manager;
	/**
	 * @var Environment
	 */
	private $templating;
	/**
	 * @var InventoryStockLocationRepository
	 */
	private $inventory_stock_location_repository;
	/**
	 * @var InventoryStockRepository
	 */
	private $inventory_stock_repository;
	/**
	 * @var InvtStockItemsRepository
	 */
	private $invt_stock_items_repository;
	/**
	 * @var InventoryItemsUsageRepository
	 */
	private $inventory_items_usage_repository;

	public function __construct( DefaultFunction $default_function, InventoryCategoryRepository $inventory_category_repository, EntityManagerInterface $entity_manager, Environment $templating, InventoryStockLocationRepository $inventory_stock_location_repository, InventoryStockRepository $inventory_stock_repository, InvtStockItemsRepository $invt_stock_items_repository, InventoryItemsUsageRepository $inventory_items_usage_repository ) {
		$this->default_function                    = $default_function;
		$this->inventory_category_repository       = $inventory_category_repository;
		$this->entity_manager                      = $entity_manager;
		$this->templating                          = $templating;
		$this->inventory_stock_location_repository = $inventory_stock_location_repository;
		$this->inventory_stock_repository          = $inventory_stock_repository;
		$this->invt_stock_items_repository         = $invt_stock_items_repository;
		$this->inventory_items_usage_repository    = $inventory_items_usage_repository;
	}

	/*
	 * Inventory category
	 * */

	## validate inventory category
	public function validate__inventory_category( ParameterBag $request ) {
		$response = [];

		## if category name is missing throw an error.
		if ( empty( $request->get( 'c___name' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please Type a Category Name' );
		}

		return $response;
	}

	## add or update inventory category
	public function add_edit_category( \Symfony\Component\HttpFoundation\ParameterBag $request ) {
		$response = [];

		$validate__response = $this->validate__inventory_category( $request );
		if ( ! empty( $validate__response ) ) {
			return $validate__response;
		}

		## deciding what to do, add or edit a category
		if ( empty( $request->get( 'ca___f' ) ) ) {
			## add new category
			$InventoryCategory = new InventoryCategory();
		} else {
			## edit/update an existing category
			try {
				$InventoryCategory = $this->inventory_category_repository->find( $request->get( 'ca___f' ) );
			} catch ( \Exception $exception ) {
				$InventoryCategory = null;
			}
			## book category is not found then create a new instance
			if ( ! $InventoryCategory instanceof InventoryCategory ) {
				$InventoryCategory = new InventoryCategory();
			}
		}

		## save the category name
		$InventoryCategory->setInvtCatName( $request->get( 'c___name' ) );
		## save the category desc
		$InventoryCategory->setInvtCatNotes( $request->get( 'c___des' ) );
		## save the category code
		$InventoryCategory->setInvtCatCode( $request->get( 'c___code' ) );

		## try to add in database.
		try {
			$this->entity_manager->persist( $InventoryCategory );
			$this->entity_manager->flush();
			$response = 'escape__fromErro_' . $InventoryCategory->getId() . '_af_d_f_____' . $this->templating->render( 'school_inventory/inventory_category___list_view.html.twig', [ 'category_list' => [ $InventoryCategory ], ] );
		} catch ( \Exception $exception ) {
			$response = $this->default_function->push_error( $response, $exception->getMessage() );

		}

		return $response;
	}

	## get the category
	public function get__the__inventory__category( int $reference ) {
		$response = null;
		if ( ! empty( $reference ) ) {
			try {
				$response = $this->inventory_category_repository->find( $reference );
			} catch ( \Exception $exception ) {
				$response = $exception->getMessage();
			}
		}

		return $response;
	}


	/*
	 *
	 * Inventory stock
	 * */
	## validate inventory category
	public function validate__inventory_stock( ParameterBag $request ) {
		$response = [];

		## if name of the inventory stock is missing then throw an error.
		if ( empty( $request->get( 'is__n' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please Inventory Stock' );
		}
		## if category of the inventory stock is empty then throw an error.
		if ( empty( $request->get( 'is__c' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please Inventory Stock' );
		}

		return $response;
	}

	## add or update inventory stock
	public function add_edit_inventory_stock( ParameterBag $request ) {
		$response = [];

		$validate__response = $this->validate__inventory_stock( $request );
		if ( ! empty( $validate__response ) ) {
			return $validate__response;
		}

		## deciding what to do, add or edit
		if ( empty( $request->get( 'is__f' ) ) ) {
			## adding new inventorys
			$InventoryStock = new InventoryStock();
		} else {
			## edit/update an existing inventory
			try {
				$InventoryStock = $this->inventory_stock_repository->find( $request->get( 'is__f' ) );
			} catch ( \Exception $exception ) {
				$InventoryStock = null;
			}
			## book category is not found then create a new instance
			if ( ! $InventoryStock instanceof InventoryStock ) {
				$InventoryStock = new InventoryStock();
			}
		}

		## save the inventory category
		$inventory__category_repponse = $this->get__the__inventory__category( $request->get( 'is__c' ) );
		if ( ! $inventory__category_repponse instanceof InventoryCategory ) {
			$response = $this->default_function->push_error( $response, $inventory__category_repponse );
		} else {
			## set the category of inventory
			$InventoryStock->setInvtCat( $inventory__category_repponse );
		}

		## if we've an error then throw
		if ( ! empty( $response ) ) {
			return $response;
		}

		## save the inventory stock name
		$InventoryStock->setInvtStockName( $request->get( 'is__n' ) );
		## save the inventory description
		$InventoryStock->setInvtStockNotes( $request->get( 'c___des' ) );
		## save the inventory cost
		$InventoryStock->setInvtStockCost( (int) $request->get( 'is__co' ) );
		## save the inventory purchase date
		$InventoryStock__purchase_date = null;
		try {
			$InventoryStock__purchase_date = new \DateTime( $request->get( 'is__pd' ) );
		} catch ( \Exception $exception ) {
		}

		if ( empty( $InventoryStock__purchase_date ) ) {
			$InventoryStock__purchase_date = new \DateTime( 'now' );
		}
		$InventoryStock->setInvtPurchaseStockDatetime( $InventoryStock__purchase_date );

		## try to add in database.
		try {
			$this->entity_manager->persist( $InventoryStock );
			$this->entity_manager->flush();
			$response = 'escape__fromErro_' . $InventoryStock->getId() . '_af_d_f_____' . $this->templating->render( 'school_inventory/inventory_stock__list_view.html.twig', [ 'inventory__stock' => [ $InventoryStock ], ] );
		} catch ( \Exception $exception ) {
			$response = $this->default_function->push_error( $response, $exception->getMessage() );

		}

		return $response;
	}

	## get the inventory stock
	public function get__the__inventory__stock( int $reference ) {
		$response = null;
		if ( ! empty( $reference ) ) {
			try {
				$response = $this->inventory_stock_repository->find( $reference );
			} catch ( \Exception $exception ) {
				$response = $exception->getMessage();
			}
		}

		return $response;
	}

	/*
	 * Inventory stock list
	 * */

	## validate inventory stock items
	public function validate__inventory_items( ParameterBag $request ) {
		$response = [];

		## if serial number is not entered then thrown an error
		if ( empty( $request->get( 'inl__se' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please type inventory item serial number' );
		} else {
			## serial number should not be duplicate.
			## only check when user is adding.
			if ( empty( $request->get( 'inlI__f' ) ) ) {
				$response__ = $this->invt_stock_items_repository->findOneBy( [ 'invt_stock_item_serial_num' => $request->get( 'inl__se' ) ] );
				if ( $response__ instanceof InvtStockItems ) {
					$response = $this->default_function->push_error( $response, 'This serial number is already exits' );
				}
			}
		}


		## if inventory is not selected then thrown an error.
		if ( empty( $request->get( 'inv__' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please select inventory' );
		}

		return $response;
	}

	## add edit inventory list items.
	public function add_edit_inventory_stock_item( ParameterBag $request ) {
		$response = [];

		$validate__response = $this->validate__inventory_items( $request );
		if ( ! empty( $validate__response ) ) {
			return $validate__response;
		}

		## deciding what to do, add or edit
		if ( empty( $request->get( 'inlI__f' ) ) ) {
			## adding new inventorys
			$InvtStockItems = new InvtStockItems();
		} else {
			## edit/update an existing inventory
			try {
				$InvtStockItems = $this->invt_stock_items_repository->find( $request->get( 'inlI__f' ) );
			} catch ( \Exception $exception ) {
				$InvtStockItems = null;
			}
			## Inventory stock is not found then create a new instance
			if ( ! $InvtStockItems instanceof InvtStockItems ) {
				$InvtStockItems = new InvtStockItems();
			}
		}

		## save the inventory stock
		$inventory__stock_reponse = $this->get__the__inventory__stock( $request->get( 'inv__' ) );
		if ( ! $inventory__stock_reponse instanceof InventoryStock ) {
			$response = $this->default_function->push_error( $response, $inventory__stock_reponse );
		} else {
			## set the category of inventory
			$InvtStockItems->setInventoryStock( $inventory__stock_reponse );
		}


		## save the inventory location.
		$inventory__stock_location_response = $this->get__the__inventory__stock_items__location( $request->get( 'inv__loc' ) );
		if ( ! $inventory__stock_location_response instanceof InventoryStockLocation ) {
			$response = $this->default_function->push_error( $response, $inventory__stock_location_response );
		} else {
			## set the inventory location
			$InvtStockItems->setInventoryItemLocation( $inventory__stock_location_response );
		}

		## if we've an error then throw
		if ( ! empty( $response ) ) {
			return $response;
		}


		## save the inventory stock serial number
		$InvtStockItems->setInvtStockItemSerialNum( $request->get( 'inl__se' ) );
		## save the inventory list qty
		//$InvtStockItems->setInvtStockItemQty( $request->get( 'inv___sQ' ) );

		## try to add in database.
		try {
			$this->entity_manager->persist( $InvtStockItems );
			$this->entity_manager->flush();
			$response = 'escape__fromErro_' . $InvtStockItems->getId() . '_af_d_f_____' . $this->templating->render( 'school_inventory/inventory__stock__items___list __view.html.twig', [ 'inventory__stock__items' => [ $InvtStockItems ], ] );
		} catch ( \Exception $exception ) {
			$response = $this->default_function->push_error( $response, $exception->getMessage() );

		}

		return $response;
	}

	## get the inventory stock item
	public function get__the__inventory__stock__item( int $reference ) {
		$response = null;
		if ( ! empty( $reference ) ) {
			try {
				$response = $this->invt_stock_items_repository->find( $reference );
			} catch ( \Exception $exception ) {
				$response = $exception->getMessage();
			}
		}

		return $response;
	}

	/*
	 * Inventory Items locations.
	 * */
	## validate inventory location
	public function validate__inventory_location( ParameterBag $request ) {
		$response = [];

		## if location is missing throw an error.
		if ( empty( $request->get( 'l__n' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please Type a location Name' );
		}

		if ( ! empty( $request->get( 'l__no' ) ) && strlen( $request->get( 'l__no' ) ) > 10 ) {
			$response = $this->default_function->push_error( $response, 'Location no must be less than 10' );
		}

		return $response;
	}

	## add or update inventory location
	public function add_edit_location( \Symfony\Component\HttpFoundation\ParameterBag $request ) {
		$response = [];

		$validate__response = $this->validate__inventory_location( $request );
		if ( ! empty( $validate__response ) ) {
			return $validate__response;
		}

		## deciding what to do, add or edit a category
		if ( empty( $request->get( 'l___f' ) ) ) {
			## add new category
			$InventoryStockItemLocation = new InventoryStockLocation();
		} else {
			## edit/update an existing category
			try {
				$InventoryStockItemLocation = $this->inventory_stock_location_repository->find( $request->get( 'l___f' ) );
			} catch ( \Exception $exception ) {
				$InventoryStockItemLocation = null;
			}
			## book category is not found then create a new instance
			if ( ! $InventoryStockItemLocation instanceof InventoryStockLocation ) {
				$InventoryStockItemLocation = new InventoryStockLocation();
			}
		}

		## save the location name
		$InventoryStockItemLocation->setInventoryStockLocationName( $request->get( 'l__n' ) );
		## save the location number
		$InventoryStockItemLocation->setInventoryStockLocationNum( $request->get( 'l__no' ) );

		## try to add in database.
		try {
			$this->entity_manager->persist( $InventoryStockItemLocation );
			$this->entity_manager->flush();
			$response = 'escape__fromErro_' . $InventoryStockItemLocation->getId() . '_af_d_f_____' . $this->templating->render( 'school_inventory/inventory_stock__items__location___list_view.html.twig', [ 'location_list' => [ $InventoryStockItemLocation ], ] );
		} catch ( \Exception $exception ) {
			$response = $this->default_function->push_error( $response, $exception->getMessage() );

		}

		return $response;
	}

	## get the inventory location
	public function get__the__inventory__stock_items__location( int $reference ) {
		$response = null;
		if ( ! empty( $reference ) ) {
			try {
				$response = $this->inventory_stock_location_repository->find( $reference );
			} catch ( \Exception $exception ) {
				$response = $exception->getMessage();
			}
		}

		return $response;
	}


	/*
	 * Inventory Item usage.
	 * */

	## valdiate, before adding usage of any stock in the database.
	public function validate__inventory_usage( ParameterBag $request ) {
		$response = [];

		## if location of usage is missing, thrown an error.
		if ( empty( $request->get( 'u____loc' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Where this inventory will use?' );
		}

		## before saving usage, we have to check which think is using is Full stock is using or items in the stock is using.
		if ( empty( $request->get( 'u___inv' ) ) && empty( $request->get( 'u____inv__l' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please select inventory stock or inventory item' );
		}

		## who many qty is using in that place
		if ( empty( $request->get( 'u__q' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please select inventory stock or inventory item' );
		}

		return $response;
	}

	## add or edit inventory usage.
	public function add__edit__inventory__usage( ParameterBag $request ) {
		$response = [];

		$validate__response = $this->validate__inventory_usage( $request );
		if ( ! empty( $validate__response ) ) {
			return $validate__response;
		}

		## deciding what to do, add or edit a category
		if ( empty( $request->get( 'us___lf' ) ) ) {
			## add new category
			$InventoryItemsUsage = new InventoryItemsUsage();
		} else {
			## edit/update an existing category
			try {
				$InventoryItemsUsage = $this->inventory_items_usage_repository->find( $request->get( 'us___lf' ) );
			} catch ( \Exception $exception ) {
				$InventoryItemsUsage = null;
			}
			## book category is not found then create a new instance
			if ( ! $InventoryItemsUsage instanceof InventoryItemsUsage ) {
				$InventoryItemsUsage = new InventoryItemsUsage();
			}
		}


		## getting the item location.
		$inv__loca = $this->get__the__inventory__stock_items__location( $request->get( 'u____loc' ) );
		if ( ! $inv__loca instanceof InventoryStockLocation ) {
			$response = $this->default_function->push_error( $response, $inv__loca );
		}


		## getting what is the use choose.. Is he/she saving stock or stock items.
		if ( $request->get( 'choosen____' ) === 'on' ) {
			## adding a stock.
			$inv__stock = $this->get__the__inventory__stock( $request->get( 'u___inv' ) );
			if ( ! $inv__stock instanceof InventoryStock ) {
				$response = $this->default_function->push_error( $response, $inv__stock );
			}
		} else {
			## adding stock item.
			$inv__stock__item = $this->get__the__inventory__stock__item( $request->get( 'u____inv__l' ) );
			if ( ! $inv__stock__item instanceof InvtStockItems ) {
				$response = $this->default_function->push_error( $response, $inv__stock__item );
			}

		}

		## save item usage location... where it will use.
		$inv__loca = $this->get__the__inventory__stock_items__location( $request->get( 'u____loc' ) );
		if ( ! $inv__loca instanceof InventoryStockLocation ) {
			$response = $this->default_function->push_error( $response, $inv__loca );
		}

		## return if error
		if ( ! empty( $response ) ) {
			return $response;
		}

		## save issue date.
		$issue__date = null;
		$return_date = null;
		try {
			$issue__date = new \DateTime( $request->get( 'isue__date' ) );
			$rtn__date   = new \DateTime( $request->get( 'rtn__date' ) );
		} catch ( \Exception $exception ) {
			$issue__date = null;
		}

		if ( empty( $issue__date ) ) {
			$issue__date = new \DateTime( 'now' );
		}


		## save the location
		$InventoryItemsUsage->setInvItemUsageLocation( $inv__loca );
		## save the issue date
		$InventoryItemsUsage->setIssueDate( $issue__date );

		if ( ! empty( $inv__stock__item ) ) {
			## save the inventory stock item
			$InventoryItemsUsage->setInventoryStockItem( $inv__stock__item );
		}

		if ( ! empty( $inv__stock ) ) {
			## save the inventory stock
			$InventoryItemsUsage->setInventoryStock( $inv__stock );
		}

		$InventoryItemsUsage->setQtyGiven( $request->get( 'u__q' ) );


		if ( $rtn__date instanceof \DateTime ) {
			## set return date.
			$InventoryItemsUsage->setReturnDate( $rtn__date );
		}


		## try to add in database.
		try {
			$this->entity_manager->persist( $InventoryItemsUsage );
			$this->entity_manager->flush();
			$response = 'escape__fromErro_' . $InventoryItemsUsage->getId() . '_af_d_f_____' . $this->templating->render( 'school_inventory/inventory__stock__items__usage_history__list_view.html.twig', [ 'usage__list' => [ $InventoryItemsUsage ], ] );
		} catch ( \Exception $exception ) {
			$response = $this->default_function->push_error( $response, $exception->getMessage() );
		}

		return $response;
	}
}