<?php

namespace App\Repository;

use App\Entity\ClassGradeTemplate;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method ClassGradeTemplate|null find($id, $lockMode = null, $lockVersion = null)
 * @method ClassGradeTemplate|null findOneBy(array $criteria, array $orderBy = null)
 * @method ClassGradeTemplate[]    findAll()
 * @method ClassGradeTemplate[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ClassGradeTemplateRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ClassGradeTemplate::class);
    }

    /**
     * @param int|null $gradeCatId
     * @param $gradeName
     * @param $gradeMarks
     * Purpose: While saving validate, if same grade already exits or not.
     * @param $classTemplateId
     * @return bool
     */
    public function gradeCategoryGradeNameGradeMarksDuplicationCheck(
        ?int $gradeCatId,
        $gradeName,
        $gradeMarks,
        $classTemplateId
    ) {
        $queryResult = $this->createQueryBuilder('class_grade_template')->leftJoin(
            'class_grade_template.student_grade_category',
            'studentGradeCategory'
        )->where('studentGradeCategory.id = :studentGradeCatId')->setParameter(
            'studentGradeCatId',
            $gradeCatId
        )->andWhere('class_grade_template.class_template = :classTemplate')->setParameter(
            'classTemplate',
            $classTemplateId
        )->andWhere(
            'class_grade_template.grade_name = :gradeName'
        )->andWhere('class_grade_template.marks_equal_or_greater_than = :marks')->setParameter(
            'gradeName',
            $gradeName
        )->setParameter('marks', $gradeMarks)->getQuery()->getResult();

        $response = false;
        if (count($queryResult)) {
            $response = true;
        }

        return $response;
    }

    ## delete Grade on Base of Class Template
    public function deleteGradeOnBaseOfClassTemplate(?int $getId)
    {
        return $this->createQueryBuilder('class_grade_template')->delete()->where(
            'class_grade_template.class_template = :classTemplate'
        )->setParameter(
            'classTemplate',
            $getId
        )->getQuery()->getResult();
    }
}
