<?php

namespace App\Repository;

use App\Entity\AllocateTeacherToClassAndSubjects;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method AllocateTeacherToClassAndSubjects|null find($id, $lockMode = null, $lockVersion = null)
 * @method AllocateTeacherToClassAndSubjects|null findOneBy(array $criteria, array $orderBy = null)
 * @method AllocateTeacherToClassAndSubjects[]    findAll()
 * @method AllocateTeacherToClassAndSubjects[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class AllocateTeacherToClassAndSubjectsRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, AllocateTeacherToClassAndSubjects::class);
    }

    /**
     * @param $teacherId
     * @param $ClassId
     * @param null $subjetID
     * @return AllocateTeacherToClassAndSubjects[] Returns an array of AllocateTeacherToClassAndSubjects objects
     * PURPOSE: duplication check,
     */
    public function duplicationCheck($teacherId, $ClassId, $subjetID = null)
    {
        $queryBuilder = $this->createQueryBuilder('allocateTeacher');

        $queryBuilder->andWhere('allocateTeacher.teacher = :teacherRef')
            ->setParameter('teacherRef', $teacherId);

        $queryBuilder->andWhere('allocateTeacher.class = :classRef')
            ->setParameter('classRef', $ClassId);

        if (empty($subjetID)) {
            $queryBuilder->andWhere('allocateTeacher.class_subject IS NULL');
        } else {
            $queryBuilder->andWhere('allocateTeacher.class_subject = :classSubjectRef')
                ->setParameter('classSubjectRef', $subjetID);
        }

        try {
            $response = $queryBuilder
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $e) {
            $response = $e->getMessage();
        }

        return $response;
    }

    ## get unique teacher allocation
    public function getUniqueClassAllocationByTeacherID(int $teacherID)
    {
        $ClassesList = $this->createQueryBuilder('allocateTeacher')->select('allocateTeacher')
            ->where('allocateTeacher.teacher = :teacherRef')
            ->setParameter('teacherRef', $teacherID)->addGroupBy('allocateTeacher.class')
            ->getQuery()->getResult();

        $temp_ar = [];
        foreach ($ClassesList as $value) {
            /** @var  AllocateTeacherToClassAndSubjects $value */
            array_push($temp_ar, $value->getClass()->getId());
        }

        return $temp_ar;
    }


    ## get the list of students which are currently allocated in the Class
    public function getListOfStudentsAllocateToTeacher(int $teacherRef)
    {
        return
            $this->createQueryBuilder('teacherAllocation')->select('teacherAllocation')
                ->leftJoin('teacherAllocation.class', 'class')
                ->leftJoin('class.classSessionEnrolments', 'classSessionEnrolment')
                ->leftJoin('classSessionEnrolment.user_id', 'userIm')
                ->andwhere('teacherAllocation.teacher = :teacherRefPara')
                ->andWhere('classSessionEnrolment.id is not null')
                ->setParameter('teacherRefPara', $teacherRef)
                ->getQuery()->getResult();
    }

    ## list of allocated teacher + search.
    public function listOfAllocatedTeacher(
        $parse__YesNoToBoolean,
        \Symfony\Component\HttpFoundation\ParameterBag $bag = null
    ) {
        ##  query builder
        $queryBuilder = $this->createQueryBuilder('allocateTeacherToClassAndSubjects');

        ## left join with to strong connection.
        $queryBuilder->leftJoin('allocateTeacherToClassAndSubjects.class_subject', 'ClassSubject')->addSelect(
            'ClassSubject'
        );
        $queryBuilder->leftJoin('allocateTeacherToClassAndSubjects.teacher', 'teacher')->addSelect('teacher');
        $queryBuilder->leftJoin('allocateTeacherToClassAndSubjects.class', 'classes');

        ## parameter bag....
        if ($bag instanceof ParameterBag) {
            ## search classes of specific session.
            if ($bag->get('session')) {
                $queryBuilder->andWhere('classes.session.id = :session')->setParameter('session', $bag->get('session'));
            }
            ## search class
            if ($bag->get('class')) {
                $queryBuilder->andWhere('allocateTeacherToClassAndSubjects.class = :class')->setParameter(
                    'class',
                    $bag->get('class')
                );
            }
            ## subject
            if ($bag->get('subject')) {
                $queryBuilder->andWhere('allocateTeacherToClassAndSubjects.class_subject = :subject')->setParameter(
                    'subject',
                    $bag->get('subject')
                );
            }
            ## teacher
            if ($bag->get('teacher')) {
                $queryBuilder->andWhere('teacher.id = :teacher')->setParameter('teacher', $bag->get('teacher'));
            }
        }

        ## ignore delete records
        if (!$parse__YesNoToBoolean) {
            $queryBuilder = $queryBuilder->andWhere('allocateTeacherToClassAndSubjects.is_deleted = 0');
        }

        return $queryBuilder->orderBy('allocateTeacherToClassAndSubjects.is_deleted', 'ASC')->getQuery()->getResult();
    }

}
