<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InventoryStockRepository")
 */
class InventoryStock {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=50)
	 */
	private $invt_stock_name;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	private $invt_stock_notes;

	/**
	 * @ORM\Column(type="smallint")
	 */
	private $invt_stock_cost;

	/**
	 * @ORM\Column(type="datetime")
	 */
	private $invt_stock_purchase_datetime;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\InventoryCategory", inversedBy="inventoryStocks")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $invt_cat;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\InvtStockItems", mappedBy="inventory_stock")
	 */
	private $invtStockItems;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InventoryItemsUsage", mappedBy="inventory__stock")
     */
    private $inventoryItemsUsages;

	public function __construct() {
               		$this->invtStockItems = new ArrayCollection();
                 $this->inventoryItemsUsages = new ArrayCollection();
               	}

	public function getId(): ?int {
               		return $this->id;
               	}

	public function getInvtStockName(): ?string {
               		return $this->invt_stock_name;
               	}

	public function setInvtStockName( string $invt_stock_name ): self {
               		$this->invt_stock_name = $invt_stock_name;
               
               		return $this;
               	}

	public function getInvtStockNotes(): ?string {
               		return $this->invt_stock_notes;
               	}

	public function setInvtStockNotes( string $invt_stock_notes ): self {
               		$this->invt_stock_notes = $invt_stock_notes;
               
               		return $this;
               	}

	public function getInvtStockCost(): ?int {
               		return $this->invt_stock_cost;
               	}

	public function setInvtStockCost( int $invt_stock_cost ): self {
               		$this->invt_stock_cost = $invt_stock_cost;
               
               		return $this;
               	}

	public function getInvtPurchaseStockDatetime(): ?\DateTimeInterface {
               		return $this->invt_stock_purchase_datetime;
               	}

	public function setInvtPurchaseStockDatetime( \DateTimeInterface $invt_stock_datetime ): self {
               		$this->invt_stock_purchase_datetime = $invt_stock_datetime;
               
               		return $this;
               	}

	public function getInvtCat(): ?InventoryCategory {
               		return $this->invt_cat;
               	}

	public function setInvtCat( ?InventoryCategory $invt_cat ): self {
               		$this->invt_cat = $invt_cat;
               
               		return $this;
               	}

	/**
	 * @return Collection|InvtStockItems[]
	 */
	public function getInvtStockItems(): Collection {
               		return $this->invtStockItems;
               	}

	public function addInvtStockItem( InvtStockItems $invtStockItem ): self {
               		if ( ! $this->invtStockItems->contains( $invtStockItem ) ) {
               			$this->invtStockItems[] = $invtStockItem;
               			$invtStockItem->setInventoryStock( $this );
               		}
               
               		return $this;
               	}

	public function removeInvtStockItem( InvtStockItems $invtStockItem ): self {
               		if ( $this->invtStockItems->contains( $invtStockItem ) ) {
               			$this->invtStockItems->removeElement( $invtStockItem );
               			// set the owning side to null (unless already changed)
               			if ( $invtStockItem->getInventoryStock() === $this ) {
               				$invtStockItem->setInventoryStock( null );
               			}
               		}
               
               		return $this;
               	}

    /**
     * @return Collection|InventoryItemsUsage[]
     */
    public function getInventoryItemsUsages(): Collection
    {
        return $this->inventoryItemsUsages;
    }

    public function addInventoryItemsUsage(InventoryItemsUsage $inventoryItemsUsage): self
    {
        if (!$this->inventoryItemsUsages->contains($inventoryItemsUsage)) {
            $this->inventoryItemsUsages[] = $inventoryItemsUsage;
            $inventoryItemsUsage->setInventoryStock($this);
        }

        return $this;
    }

    public function removeInventoryItemsUsage(InventoryItemsUsage $inventoryItemsUsage): self
    {
        if ($this->inventoryItemsUsages->contains($inventoryItemsUsage)) {
            $this->inventoryItemsUsages->removeElement($inventoryItemsUsage);
            // set the owning side to null (unless already changed)
            if ($inventoryItemsUsage->getInventoryStock() === $this) {
                $inventoryItemsUsage->setInventoryStock(null);
            }
        }

        return $this;
    }
}
