<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InternalChatGroupsGuardianRepository")
 */
class InternalChatGroupsGuardian
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\InternalChatGroups", inversedBy="internalChatGroupsGuardians")
     * @ORM\JoinColumn(nullable=false)
     */
    private $icg;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Guardian", inversedBy="internal_chat_groups__involvements")
     * @ORM\JoinColumn(nullable=false)
     */
    private $guardians;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getIcg(): ?InternalChatGroups
    {
        return $this->icg;
    }

    public function setIcg(?InternalChatGroups $icg): self
    {
        $this->icg = $icg;

        return $this;
    }

    public function getGuardians(): ?Guardian
    {
        return $this->guardians;
    }

    public function setGuardians(?Guardian $guardians): self
    {
        $this->guardians = $guardians;

        return $this;
    }
}
