<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ExaminersRepository")
 */
class Examiners
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="examiners")
     * @ORM\JoinColumn(nullable=false)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ExamsClasses", inversedBy="examiners")
     * @ORM\JoinColumn(nullable=false)
     */
    private $exams_classes;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getExamsClasses(): ?ExamsClasses
    {
        return $this->exams_classes;
    }

    public function setExamsClasses(?ExamsClasses $exams_classes): self
    {
        $this->exams_classes = $exams_classes;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }
}
