<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;

class EmailTemplateEvents extends Fixture {

	private $faker;
	public const EmailTemplateEventReference = 'emailTemplateEventReference';

	public function load( ObjectManager $manager ) {
		$this->faker = Factory::create();
		for ( $x = 0; $x < 10; $x++ ) {
			$emailTemplateEvents = new \App\Entity\EmailTemplateEvents();

			if ( $x == 0 ) {
				$eventName = 'USER_REGISTRATION';
			} else if ( $x == 1 ) {
				$eventName = 'REPORT_NOTIFICATION';
			} else {
				$eventName = $this->faker->text( 5 );
			}

			$emailTemplateEvents->setEventName( $eventName );


			$this->addReference( self::EmailTemplateEventReference . '_' . $x, $emailTemplateEvents );


			$manager->persist( $emailTemplateEvents );
		}


		$manager->flush();
	}
}
