<?php

namespace App\Controller;

use App\Entity\ClassTemplate;
use App\Entity\ExamsClasses;
use App\Entity\User;
use App\Entity\VirtualClassRoom;
use App\Repository\ClassesRepository;
use App\Repository\ClassFeeTemplateRepository;
use App\Repository\ClassSubjectRepository;
use App\Repository\ClassTemplateRepository;
use App\Repository\SessionRepository;
use App\Repository\StudentFeeRepository;
use App\Repository\SubjectsRepository;
use App\Repository\UserRepository;
use App\Repository\VirtualClassRoomRepository;
use App\Service\Exams\ExamsService;
use App\Service\Fees\FeeSchedulerService;
use App\Service\Fees\StudentFeeService;
use App\Service\StudentClasses;
use App\Service\Students\Grade\GradeBase;
use App\Service\StudentSession;
use App\Service\SubjectService;
use App\Service\Virtucal\ZoomJWT;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Nzo\UrlEncryptorBundle\Annotations\ParamDecryptor;
use Nzo\UrlEncryptorBundle\UrlEncryptor\UrlEncryptor;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Debug\Tests\Fixtures\VirtualClass;
use Symfony\Component\HttpClient\HttpClient;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

/**
 * @IsGranted("ROLE_USER")
 * */
class VirtualClassRoomController extends AbstractController
{
    /**
     * @var FeeSchedulerService
     */
    private $feeSchedulerService;
    /**
     * @var SubjectService
     */
    private $subjectService;
    /**
     * @var ClassTemplateRepository
     */
    private $classTemplateRepository;
    /**
     * @var SubjectsRepository
     */
    private $subjects_repository;
    /**
     * @var StudentFeeRepository
     */
    private $student_fee_service;
    /**
     * @var ClassFeeTemplateRepository
     */
    private $classFeeTemplateRepository;
    /**
     * @var SessionRepository
     */
    private $sessionRepository;
    /**
     * @var ClassesRepository
     */
    private $classesRepository;
    /**
     * @var UrlEncryptor
     */
    private $url_encryptor;
    /**
     * @var ClassSubjectRepository
     */
    private $classSubjectRepository;
    /**
     * @var ExamsService
     */
    private $examsService;
    /**
     * @var UserRepository
     */
    private $userRepository;


    use ZoomJWT;


    const MEETING_TYPE_INSTANT = 1;
    const MEETING_TYPE_SCHEDULE = 2;
    const MEETING_TYPE_RECURRING = 3;
    const MEETING_TYPE_FIXED_RECURRING_FIXED = 8;
    /**
     * @var EntityManagerInterface
     */
    private $entityManager;


    /**
     * VirtualClassRoomController constructor.
     * @param FeeSchedulerService $feeSchedulerService
     * @param SubjectService $subjectService
     * @param ClassTemplateRepository $classTemplateRepository
     * @param SubjectsRepository $subjectsRepository
     * @param StudentFeeRepository $student_fee_repository
     * @param ClassFeeTemplateRepository $classFeeTemplateRepository
     * @param SessionRepository $sessionRepository
     * @param ClassesRepository $classesRepository
     * @param UrlEncryptor $url_encryptor
     * @param ClassSubjectRepository $classSubjectRepository
     */
    public function __construct(
        FeeSchedulerService $feeSchedulerService,
        SubjectService $subjectService,
        ClassTemplateRepository $classTemplateRepository,
        SubjectsRepository $subjectsRepository,
        StudentFeeRepository $student_fee_repository,
        ClassFeeTemplateRepository $classFeeTemplateRepository,
        SessionRepository $sessionRepository,
        ClassesRepository $classesRepository,
        UrlEncryptor $url_encryptor,
        ClassSubjectRepository $classSubjectRepository,
        ExamsService $examsService,
        UserRepository $userRepository,
        EntityManagerInterface $entityManager
    )
    {
        $this->feeSchedulerService = $feeSchedulerService;
        $this->subjectService = $subjectService;
        $this->classTemplateRepository = $classTemplateRepository;
        $this->subjects_repository = $subjectsRepository;
        $this->student_fee_service = $student_fee_repository;
        $this->classFeeTemplateRepository = $classFeeTemplateRepository;
        $this->sessionRepository = $sessionRepository;
        $this->classesRepository = $classesRepository;
        $this->url_encryptor = $url_encryptor;
        $this->classSubjectRepository = $classSubjectRepository;
        $this->examsService = $examsService;
        $this->userRepository = $userRepository;
        $this->entityManager = $entityManager;
    }

    /**
     * @IsGranted("ROLE_ADMIN")
     * @Route("/virtual/class/room", name="virtual_class_room_list")
     * @param StudentSession $studentSession
     * @param StudentClasses $studentClasses
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public
    function index(
        StudentSession $studentSession,
        StudentClasses $studentClasses,
        Request $request
    )
    {
        return $this->render(
            'virtual_class_room/index.html.twig',
            [
                'virtualClassRoom' => $this->entityManager->getRepository('App:VirtualClassRoom')->findAll(),
                'sessions' => $studentSession->getAllSessions(),
                'classes' => $studentClasses->getAllClasses(),
            ]
        );
    }

    /**
     * @Route("/virtual/class/room/student", name="virtual_class_room_list_student")
     * @param StudentSession $studentSession
     * @param StudentClasses $studentClasses
     * @param Request $request
     * @param VirtualClassRoomRepository $virtualClassRoomRepository
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function student_class_room_list(StudentSession $studentSession,
                                            StudentClasses $studentClasses,
                                            Request $request, VirtualClassRoomRepository $virtualClassRoomRepository)
    {

        /** @var User $User */
        $User = $this->getUser();
        $classSessionEnr = $User->getClassSessionEnrolments()->toArray();
        $classSessionEnrol = [];
        foreach ($classSessionEnr as $key => $value) {
            array_push($classSessionEnrol, $value->getClassSession()->getId());
        }

        $allVirtualClassRooms = [];
        if ($classSessionEnrol) {
            $allVirtualClassRooms = $virtualClassRoomRepository->getVirtualClassRooms($classSessionEnrol);
        }

        return $this->render(
            'virtual_class_room/index.html.twig',
            ['virtualClassRoom' => $allVirtualClassRooms,]
        );
    }

    // virtual_class_room_list_student

    /**
     * @IsGranted("ROLE_ADMIN")
     * @Route("{_locale}/virtual/class/room/create/{query}", name="create_virtual_class_room", defaults={"query"=null})
     * Purpose: used to add or update class
     * @param TranslatorInterface $translator
     * @param Request $request
     * @param HttpClientInterface $httpClient
     * @param EntityManagerInterface $entity_manager
     * @return Response
     * @throws ClientExceptionInterface
     * @throws DecodingExceptionInterface
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     * @throws TransportExceptionInterface
     * @ParamDecryptor(params={"query"})
     */
    public
    function addVirtualClassRoom(
        TranslatorInterface $translator,
        Request $request,
        HttpClientInterface $httpClient,
        EntityManagerInterface $entity_manager
    )
    {

        if ($request->isMethod('POST')) {

            $testValidation = true;

            ## empty check..
            if (empty($request->request->get('exC__cLs'))) {
                $this->addFlash('errorMessage', 'Please select Class');
                $testValidation = false;
            }

            if (empty($request->request->get('exC__sbI'))) {
                $this->addFlash('errorMessage', 'Please select Class Subject');
                $testValidation = false;

            }

            if (empty($request->request->get('ex__Loc'))) {
                $this->addFlash('errorMessage', 'Please type Meeting Virtual Class Purpose');
                $testValidation = false;

            }

            if (empty($request->request->get('ex__d'))) {
                $this->addFlash('errorMessage', 'Please select Meeting Start time');
                $testValidation = false;

            }


            if ($testValidation) {


                $agenda = empty($request->request->get('ex__agenda')) ? 'agenda' : $request->request->get('ex__agenda');
                $path = 'users/me/meetings';

                try {
                    $response = $httpClient->request(
                        'POST',
//                        'http://localhost:8001/api/meetings',
                        'http://laravelpatchforfekara.makli.com/api/meetings',
                        [
                            'body' => [
                                'topic' => $request->request->get('ex__Loc'),
                                'start_time' => $request->request->get('ex__d'),
                                'agenda' => $agenda,
                            ],
                        ]
                    );

                    $response = $response->toArray();
                    if (!empty($response['success']) && $response['success'] == true) {

                        $virtualClassRoomRepo = $this->entityManager->getRepository('App:VirtualClassRoom')->findBy(
                            [
                                'classes' => $request->request->get('exC__cLs'),
                                'class_subjects' => $request->request->get('exC__sbI'),
                            ]
                        );

                        if (!$virtualClassRoomRepo) {

                            $virtualClassRoom = new VirtualClassRoom();
                            $virtualClassRoom->setClasses(
                                $this->classesRepository->find($request->request->get('exC__cLs'))
                            );
                            $virtualClassRoom->setClassSubjects(
                                $this->classSubjectRepository->find($request->request->get('exC__sbI'))
                            );
                            $virtualClassRoom->setVcrAgenda($agenda);
                            $virtualClassRoom->setVcrName($request->request->get('ex__Loc'));
                            $virtualClassRoom->setVcrStartTime(new \DateTime($request->request->get('ex__d')));
                            $virtualClassRoom->setZoomMeetingJoingingLink($response['data']['join_url']);
                            $virtualClassRoom->setZoomMeetingPassword($response['data']['password']);
                            $virtualClassRoom->setZoomStartMeetingLink($response['data']['start_url']);
                            $virtualClassRoom->setZoomMeetingObject(json_encode($response['data']));
                            $virtualClassRoom->setZoomSessionId($response['data']['id']);
                            $entity_manager->persist($virtualClassRoom);
                            $entity_manager->flush();
                            $this->addFlash('successMessage', 'Virtual Class room has been created');

                            return $this->redirectToRoute('virtual_class_room_list');
                        } else {
                            $this->addFlash(
                                'errorMessage',
                                'Virtual Class room has been created for the selected Class and Subject'
                            );

                            return $this->redirectToRoute('create_virtual_class_room');
                        }
                    } else {
                        $this->addFlash('errorMessage', 'failed to create Virtual Class Room');

                        return $this->redirectToRoute('create_virtual_class_room');
                    }
                } catch (\Exception $exception) {
                    $this->addFlash('errorMessage', $exception->getMessage());
                    return $this->redirectToRoute('create_virtual_class_room');
                }
            }
        }


        $examsClass = new ExamsClasses();
        $examsClassSelectedSubjects = null;
        if (!empty($this->url_encryptor->decrypt($request->query->get('id')))) {
            $examsClass = $this->examsService->get__examClass(
                $this->url_encryptor->decrypt($request->query->get('id'))
            );
            if ($examsClass instanceof ExamsClasses) {
                ## get the class ref from the exam class
                $classID = $examsClass->getClass()->getId();
                ## get the subject from the reference of class.
                $examsClassSelectedSubjects = $this->classSubjectRepository->findBy(['classes__' => $classID]);
            } else {
                $examsClass = new ExamsClasses();
            }
        }

        return $this->render(
            'virtual_class_room/addEditVirtualClassRoom.html.twig',
            [
                'examsClass' => $examsClass,
                'examsClassSelectedSubjects' => $examsClassSelectedSubjects,
                ## Class list
                'class__list' => $this->classesRepository->getActiveClassesOfActiveSession(),
                'requestData' => $request->request->all()
            ]
        );

    }


    /**
     * @Route("{_locale}/delete/virtual/class/room", name="delete_virtual_class_room")
     * @IsGranted("ROLE_ADMIN")
     * Purpose: delete class room
     * @param Request $request
     * @param VirtualClassRoomRepository $virtualClassRoomRepository
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteVirtualClassRoom(Request $request)
    {
        try {
            $sql = "Delete from virtual_class_room where virtual_class_room.id = {$request->query->get('vcid')}";
            $this->entityManager->getConnection()->exec($sql);
            $this->addFlash('successMessage', 'Virtual Class Room has been deleted');
            return $this->redirectToRoute('virtual_class_room_list');
        } catch (\Exception$exception) {
            $this->addFlash('errorMessage', $exception->getMessage());
            return $this->redirectToRoute('virtual_class_room_list');
        }
    }

}
