<?php


namespace App\Chat;

use App\Entity\InternalChat;
use App\Entity\InternalChatGroups;
use App\Entity\InternalChatGroupUsers;
use App\Entity\User;
use App\Repository\InternalChatGroupsRepository;
use App\Repository\InternalChatRepository;
use App\Service\DefaultFunction;
use App\Service\FileManagment;
use App\Service\UserService;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\FileBag;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

class ChatOperations
{


    const chat__attachment_file = 'internal_chat_content' . DIRECTORY_SEPARATOR;

    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;
    /**
     * @var UserService
     */
    private $user_service;
    /**
     * @var FileManagment
     */
    private $file_managment;
    /**
     * @var InternalChatRepository
     */
    private $internal_chat_repository;
    /**
     * @var InternalChatGroupsRepository
     */
    private $internal_chat_groups_repository;
    /**
     * @var Session
     */
    private $session;
    /**
     * @var \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface
     */
    private $token_storage;

    public function __construct(DefaultFunction $default_function, EntityManagerInterface $entity_manager, UserService $user_service, FileManagment $file_managment, InternalChatRepository $internal_chat_repository, InternalChatGroupsRepository $internal_chat_groups_repository, SessionInterface $session, \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface $token_storage)
    {
        $this->default_function = $default_function;
        $this->entity_manager = $entity_manager;
        $this->user_service = $user_service;
        $this->file_managment = $file_managment;
        $this->internal_chat_repository = $internal_chat_repository;
        $this->internal_chat_groups_repository = $internal_chat_groups_repository;
        $this->session = $session;
        $this->token_storage = $token_storage;
    }

    ## validate before saving the chat message
    public function validation__send__message(ParameterBag $bag, \Symfony\Component\HttpFoundation\FileBag $files = null)
    {
        $response = [];

        ## if receiver reference is empty
        if (empty($bag->get('m___t'))) {
            $response = $this->default_function->push_error($response, 'Recipient is empty');
        }

        ## if sender reference is empty
        if (empty($bag->get('m___f'))) {
            $response = $this->default_function->push_error($response, 'Unknown sender');
        }
        ## if message is empty
        ## if files is selected top upload & message is not typed then don't throw a validation error.
        if (empty($bag->get('message'))) {
            $response = $this->default_function->push_error($response, 'Message is empty');
        }

        return $response;
    }

    ## this method validate that this is message for the group or single user.
    public function is___this_value_is_reference_of_group_chat($value)
    {
        $response = false;
        if (!is_integer($value) && substr($value, 0, 4) == 'g___') {
            $response = true;
        }

        return $response;
    }

    ## get the chat group reference
    public function get__the_chat_group(int $chat_group_reference)
    {
        $chat_group_reference_ = null;
        if ($chat_group_reference) {
            $chat_group_reference_ = $this->internal_chat_groups_repository->find($chat_group_reference);
        }

        return $chat_group_reference_;
    }

    ## send message to the user
    public function send__message(ParameterBag $bag, \Symfony\Component\HttpFoundation\FileBag $files = null)
    {
        $validation_response = $this->validation__send__message($bag, $files);
        $response = [];

        ## if we've errors then don't do anything.
        if (!empty($validation_response)) {
            return $validation_response;
        }

        ## create a new bag.
        $bag__ = new ParameterBag();

        ## validate, if sender is valid user
        $bag__->set('id', $bag->get('m___f'));
        $user___f = $this->user_service->pre__userCheck($bag__);

        ## if not valid user then return
        if (!$user___f instanceof User) {
            $response = $this->default_function->push_error($response, 'Invalid from user');
        }

        ## if response is not empty then send it.
        if (!empty($response)) {
            return $response;
        }

        ## check given to is user or group reference
        //		if ( $this->is___this_value_is_reference_of_group_chat( $bag->get( 'm___t' ) ) ) {
        //			## this is group reference /** @var InternalChatGroups */ */
        //			$chat_group = $this->get__the_chat_group( substr( $bag->get( 'm___t' ), 4 ) );
        //			if ( ! $chat_group instanceof InternalChatGroups ) {
        //				$response = $this->default_function->push_error( $response, 'Invalid Group reference' );
        //			} else {
        //				$InternalChat->setChatGroup( $chat_group );
        //			}
        //
        //		} else {
        //}


        try {

            ## message sent to multiple users
            ## this is user reference
            ## validate if receiver is valid user
            if (is_array($bag->get('m___t'))) {
                foreach ($bag->get('m___t') as $key => $value) {

                    $bag__ = new ParameterBag();
                    ## set the user in the bag
                    $bag__->set('id', $value);
                    ## pre-check, user is valid or not.
                    $user___t = $this->user_service->pre__userCheck($bag__);

                    ## if not valid user then return
                    if (!$user___t instanceof User) {
                        $response = $this->default_function->push_error($response, 'Invalid to user');
                    } else {

                        ## to save the internal chat..
                        $InternalChat = new InternalChat();

                        ## log sender who, send the message
                        $InternalChat->setMessageFrom($user___f);
                        ## set the content of the chat.
                        $InternalChat->setChatContent($bag->get('message'));
                        ## set the message subject.
                        $InternalChat->setMessageSubject($bag->get('m___s'));

                        ## message reply of
                        if (!empty($bag->get('r__to'))) {
                            $InternalChat->setChatReplyTo($bag->get('r__to'));
                        }

                        $InternalChat->setMessageTo($user___t);
                        ## save chat message to database.
                        $this->entity_manager->persist($InternalChat);
                        $this->entity_manager->flush();

                        ## upload file if selected by user.
                        if (!empty($files->get('m___fls'))) {
                            foreach ($files->get('m___fls') as $value2) {
                                ## upload files.
                                $this->upload___chat_message_file($value2, $InternalChat->getId());
                            }
                        }

                    }
                }
            }

            $response = 'OK';

        } catch (\Exception $exception) {
            $response = $this->default_function->push_error($response, $exception->getMessage());
        }

        ## return the response.
        return $response;

    }

    ## upload chat message file.
    public function upload___chat_message_file($file_bag, int $message_id)
    {
        $args = [
            'fileArray' => $file_bag,
            'public' => true,
            'path' => self::chat__attachment_file . date('d-M-Y') . DIRECTORY_SEPARATOR . $message_id . DIRECTORY_SEPARATOR,
            'returnPath' => true,
        ];
        $response = $this->file_managment->uploadFile($args);
        ## if file upload successfully
        if (is_array($response) && !empty($response['response'])) {
            $response = $response['response'];
        }

        return $response;
    }

    ## load chat attachments.
    public function load___chat_message_files($dateOfMessage, $MessageRef)
    {
        ## convert date into the correct format
        $dateOfMessage = date('d-M-Y', strtotime($dateOfMessage));

        ## find that given chat is correct or wrong.
        $InternalChat = $this->internal_chat_repository->find((int)$MessageRef);
        if (!$InternalChat instanceof InternalChat) {
            return '--invalid file--';
        }

        ## to get the file pass the argu
        $args = [
            'public' => true,
            'path' => self::chat__attachment_file . $dateOfMessage . DIRECTORY_SEPARATOR . $MessageRef . DIRECTORY_SEPARATOR,
            'need_url' => true,
        ];

        ## get the uploaded file.
        $response = $this->file_managment->getUploadedFile($args);
        ## if response is empty
        if (empty($response)) {
            $response = [];
        }

        return $response;
    }

    ## save active chat list in the session.
    public function save__chatListInSession($recentChattedUser, $recentChatGroups)
    {
        ## save data in contact list.
        $this->session->set('contact__list', $recentChattedUser);
        $this->session->set('group__list', $recentChatGroups);
    }

    ## if recentChattedUser is true then return contact__list or if recentChattedUser is false then return group__list
    public function get__chatListInSession($recentChattedUser = false)
    {
        $response = null;
        if ($recentChattedUser) {
            $response = $this->session->get('contact__list');
        } else {
            $response = $this->session->get('group__list');
        }

        return $response;
    }

    ## load recent chat list of the user
    public function load__chatListOfUser($currentLoggedInUse, $saveInSesson = false, $getCounter = false)
    {
        $recentChattedUser = $this->internal_chat_repository->load_chat_list__of_user($currentLoggedInUse);
        if ($saveInSesson) {
            ## save recent chat list counter in the session
            $this->session->set('contact__list', count($recentChattedUser));
        }

        if ($getCounter) {
            return count($recentChattedUser);
        } else {
            return $recentChattedUser;
        }

    }

    ## load active group of users
    public function load__recentGroupList($currentLoggedInUser, $saveINsession = false, $getCounter = false)
    {
        $recentChatGroups = $this->internal_chat_groups_repository->get_the_chat_group_list_in_which_user_involved($currentLoggedInUser);
        if ($saveINsession) {
            ## save group chat list counter in the session.
            $this->session->set('group__list', count($recentChatGroups));
        }

        if ($getCounter) {
            return count($recentChatGroups);
        } else {
            return $recentChatGroups;
        }
    }

    ## validate the chat group.
    public function validate__chatGroup(ParameterBag $request)
    {
        ## group name should not be empty.
        $response = [];
        if (empty($request->get('g__n'))) {
            $response = $this->default_function->push_error($response, 'Group name should not be empty');
        }

        return $response;
    }

    ## get message from database
    public function getMessage(int $ref)
    {
        $response = null;
        if (!empty($ref)) {
            try {
                $response = $this->internal_chat_repository->find($ref);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    ## mark message as read.
    public function markMessageAsRead(int $ref = null)
    {
        ## get message.
        $getMessageResponse = null;
        if (($getMessageResponse = $this->getMessage($ref)) instanceof InternalChat) {
            $getMessageResponse->setChatMessageIsRead(true);
            $this->entity_manager->persist($getMessageResponse);
            $this->entity_manager->flush();
            $getMessageResponse = 'OK';
        }

        return $getMessageResponse;
    }

    /*
     *  Chat Group...
     * */

    ## create new chat group..
    public function create__chatGroup(ParameterBag $request)
    {
        $response = null;

        ## validate the chat Group.
        if (!empty($validateChatGroup = $this->validate__chatGroup($request))) {
            return $validateChatGroup;
        }

        ## decide what to do, add or edit the chat group.
        if (empty($request->get('ch___ref'))) {
            $Chat = new InternalChatGroups();
        } else {
            $Chat = $this->get__the_chat_group($request->get('ch___ref'));
        }

        if (!$Chat instanceof InternalChatGroups) {
            $Chat = new InternalChatGroups();
        }


        try {
            ## set the chat group name
            $Chat->setIcgName($request->get('g__n'));
            ## set the group admin..
            /** @var  User $CurrentLoggedinUser */
            $CurrentLoggedinUser = $this->token_storage->getToken()->getUser();
            $Chat->setIcgAdmin($CurrentLoggedinUser);
            ## set the group description.
            $Chat->setIcgDescription($request->get('g__d'));
            ## how created this group.
            $Chat->setIcgCreatedBy($CurrentLoggedinUser);
            ## create the chat group.
            $this->entity_manager->persist($Chat);
            $this->entity_manager->flush();

            ## Now, add users in the chat group.
            $response = $this->add__useInChatGroup($request->get('u_lst'), $Chat);
            if (empty($respone)) {
                $response = 'OK';
            }
            ## set the involved users in the chat.
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;

    }

    ## add user in the chat group.
    public function add__useInChatGroup(array $userLIst, InternalChatGroups $internal_chat_groups)
    {
        ## add current logged in user in this group, if he is not selected his name.
        array_push($userLIst, $this->token_storage->getToken()->getUser()->getId());
        ## make this array unique
        $userLIst = array_unique($userLIst);

        $response = [];
        foreach ($userLIst as $key => $value) {
            ## get the user object.
            $User = $this->user_service->get__user($value);
            if ($User instanceof User) {
                ## if user found in the database, then add users in the group.
                ## create a new object of internal chat group users
                $InternalChatGroupUser = new InternalChatGroupUsers();
                ## set the internal chat group, reference
                $InternalChatGroupUser->setIcg($internal_chat_groups);
                ## set the user in this group.
                $InternalChatGroupUser->setInvolvedUsers($User);
                try {
                    $this->entity_manager->persist($InternalChatGroupUser);
                    $this->entity_manager->flush();
                } catch (\Exception $exception) {
                    $response = $this->default_function->push_error($response, $exception->getMessage());
                }
            } else {
                ## if user is not found then, log an error.
                $response = $this->default_function->push_error($response, $User);
            }
        }

        ## return the response.
        return $response;
    }


    /*
         * USING IN INTERNAL MESSAGES
         * */

    public function get__data__for_message(int $UserID, $messageType = 'inbox')
    {
        $response = 'User not found';
        if (!empty($UserID)) {

            ## find user against this id.
            $User = $this->user_service->get__user($UserID);
            ## if user is an entity of user
            if (!$User instanceof User) {
                $response = 'User not found';
            } else {
                if ($messageType == 'inbox') {
                    ## get inbox messages.
                    $response = $this->internal_chat_repository->findBy([
                        'message__to' => $UserID,
                        'is_sent' => true,
                        'is_deleted' => false,
                        'is_important' => false,
                    ], ['id' => 'desc']);
                } else if ($messageType == 'marked') {
                    ## get important messages
                    $bag = new ParameterBag();
                    $bag->set('user__ref', $UserID);
                    $bag->set('imp_message', 1);
                    $bag->set('deleted_message', false);
                    $response = $this->internal_chat_repository->loadFullConversationOfUser($bag);
                } else if ($messageType == 'draft') {
                    ## get draft message
                    $bag = new ParameterBag();
                    $bag->set('user__ref', $UserID);
                    $bag->set('draft_message', 1);
                    $bag->set('deleted_message', false);
                    $response = $this->internal_chat_repository->loadFullConversationOfUser($bag);
                } else if ($messageType == 'sent') {
                    ## get the sent message
                    $response = $this->internal_chat_repository->findBy([
                        'message__from' => $UserID,
                        'is_sent' => true,
                    ], ['id' => 'desc']);
                } else if ($messageType == 'trash') {
                    ## get the trash messages.
                    $bag = new ParameterBag();
                    $bag->set('user__ref', $UserID);
                    $bag->set('trash_message', 1);
                    $response = $this->internal_chat_repository->loadFullConversationOfUser($bag);
                }
            }

        }

        return $response;
    }

    ## get message counter.
    public function getMessageCounter($userID)
    {
        return count($this->get__data__for_message($userID, 'inbox'));
    }


    /*
     * Bulk Operations.
     * */
    public function ValidateBulkOperation(Request $request)
    {
        $response = [];
        ## check message operation.
        if (empty($request->get('opertion'))) {
            $this->default_function->push_error($response, 'What operation you want to do?');
        }
        ## target that you want to do
        if (empty($request->get('target'))) {
            $this->default_function->push_error($response, 'What you want to do?');
        }

        return $response;
    }

    /*
     * Do Bulk Operation:
     * ------------------------------
     *  Mark messages as delete.
     * Mark message as important.
     * Mark message as read.
     * */
    public function OperateBulkOperation(Request $request)
    {

        ## validate record.
        if (!empty($validationResponse = $this->ValidateBulkOperation($request))) {
            return $validationResponse;
        }

        $target = $request->get('target');
        if (is_array($target)) {
            ## if target is array then covert into the string
            $target = implode(',', $target);
        }

        ## do bulk operation.
        $this->internal_chat_repository->updateBulkMessages($target, $request->get('opertion'));

        return 'OK';
    }

}

