<?php


namespace App\Service;


use App\Entity\Classes;
use App\Entity\ClassFee;
use App\Entity\ClassFeeTemplate;
use App\Entity\ClassSessionEnrolment;
use App\Entity\ClassSessionEnrolmentSubjects;
use App\Entity\ClassSubject;
use App\Entity\ClassSubjectTemplate;
use App\Entity\ClassTemplate;
use App\Entity\Session;
use App\Entity\StudentFee;
use App\Entity\Subjects;
use App\Repository\ClassSessionEnrolmentRepository;
use App\Repository\ClassSessionEnrolmentSubjectsRepository;
use App\Repository\ClassSubjectTemplateRepository;
use App\Repository\ClassSubjectRepository;
use App\Repository\SubjectsRepository;
use App\Service\StudentsEnrollment\Enrollments;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\ORMException;
use Symfony\Component\HttpFoundation\ParameterBag;

class SubjectService
{


    private $errorArray = [];
    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var ClassSubjectTemplateRepository
     */
    private $class_subject_template_repository;
    /**
     * @var ClassSubjectRepository
     */
    private $class_subject_repository;
    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;
    /**
     * @var ClassSessionEnrolmentSubjectsRepository
     */
    private $class_session_enrolment_subjects_repository;
    /**
     * @var ClassSessionEnrolmentRepository
     */
    private $class_session_enrolment_repository;
    /**
     * @var SubjectsRepository
     */
    private $subjects_repository;
    /**
     * @var Enrollments
     */
    private $enrollments;
    /**
     * @var AppSettings
     */
    private $appSettings;

    public function __construct(
        DefaultFunction $default_function,
        SubjectsRepository $subjects_repository,
        ClassSubjectTemplateRepository $class_subject_template_repository,
        EntityManagerInterface $entity_manager,
        ClassSubjectRepository $class_subject_repo,
        ClassSessionEnrolmentSubjectsRepository $class_session_enrolment_subjects_repository,
        ClassSessionEnrolmentRepository $class_session_enrolment_repository,
        AppSettings $appSettings
    ) {
        $this->default_function = $default_function;
        $this->class_subject_template_repository = $class_subject_template_repository;
        $this->entity_manager = $entity_manager;
        $this->class_subject_repository = $class_subject_repo;
        $this->class_session_enrolment_subjects_repository = $class_session_enrolment_subjects_repository;
        $this->class_session_enrolment_repository = $class_session_enrolment_repository;
        $this->subjects_repository = $subjects_repository;
        $this->appSettings = $appSettings;
    }


    /**
     *  ClassSubjectTemplate
     * */
    ## get subjects from classSubjectTemplate table
    public function getSubjectFromClassSubjectTemplate(int $Ref = null, string $key = null, $value = null)
    {
        $response = null;
        try {
            if (!empty($Ref)) {
                $response = $this->class_subject_template_repository->find($Ref);
            } else {
                if (!empty($key) && !empty($value)) {
                    $response = $this->class_subject_template_repository->findBy([$key => $value]);
                }
            }

        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;
    }

    ## delete class subject template
    public function deleteClassSubjectTemplate(int $ClassSubjectTemplateRef, bool $markAsDelete = true)
    {
        $response = [];
        $ClassSubjectTemplate = $this->getSubjectFromClassSubjectTemplate($ClassSubjectTemplateRef);
        if ($ClassSubjectTemplate instanceof ClassSubjectTemplate) {
            try {

                if ($markAsDelete) {
                    ## mark as delete
                    $ClassSubjectTemplate->setIsDeleted(true);
                    $this->entity_manager->persist($ClassSubjectTemplate);
                    $this->entity_manager->flush();
                    $response = 'OK';
                } else {

                    $ClassSubject = count($ClassSubjectTemplate->getClassSubjects()->toArray());
                    if ($ClassSubject > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            'This subject has attached with '.$ClassSubject.' class, Please delete them before deleting this'
                        );
                        $response = $this->default_function->push_error($response, 'Please remove related records');

                    }
                    if (empty($response)) {
                        ## remove from database
                        $this->entity_manager->remove($ClassSubjectTemplate);
                        $this->entity_manager->flush();
                        $response = 'OK';

                    }
                }

            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }

        } else {
            $response = $ClassSubjectTemplate;
        }

        return $response;
    }

    ## bulk delete class subject template
    ## single class template has attached to multiple subject so, if we gone delete the class we have to delete all subject related to this one.
    ## so basically this method is used to delete the classSubjectTemplate by reference of ClassTemplate
    public function deleteClassSubjectTemplateByClassTemplateRef(ClassTemplate $classTemplate, $markAsDelete = true)
    {
        $classTemplateArray = $classTemplate->getClassSubjectTemplates()->toArray();
        $response = [];
        /** @var ClassSubjectTemplate $value */
        foreach ($classTemplateArray as $key => $value) {
            $response = $this->default_function->push_error(
                $response,
                $this->deleteClassSubjectTemplate($value->getId(), $markAsDelete)
            );
        }

        return $this->default_function->purify_success_error_response_in_bulk_operation($response);
    }

    ## update class_subject_template table in the database.
    public function update__classSubjectTemplate(\Symfony\Component\HttpFoundation\ParameterBag $request)
    {
        $response = [];

        ## no validation rules yet.
        if (!empty($request->get('__hidefieldid'))) {

            $ClassSubjectTemplate = null;

            try {
                $ClassSubjectTemplate = $this->class_subject_template_repository->find($request->get('__hidefieldid'));
            } catch (\Exception $exception) {
                $response = $this->default_function->push_error($response, $exception->getMessage());
            }

            ## if we found the class subject template entity
            if (!$ClassSubjectTemplate instanceof ClassSubjectTemplate) {
                $response = $this->default_function->push_error($response, 'Subject not found');
            }

            ## if error exits then return back
            if (!empty($response)) {
                return $response;
            }

            try {
                $ClassSubjectTemplate->setSubjectName($request->get('subject_name'));
                $ClassSubjectTemplate->setShortName($request->get('subject_short_name'));
                $ClassSubjectTemplate->setCredits($request->get('credits'));
                $ClassSubjectTemplate->setFee($request->get('subject_fee'));

                $ClassSubjectTemplate->setMarks($request->get('marks'));
                $ClassSubjectTemplate->setPassMarks($request->get('pass_marks'));

                $this->entity_manager->persist($ClassSubjectTemplate);
                $this->entity_manager->flush();

            } catch (\Exception $exception) {
                $response = $this->default_function->push_error($response, $exception->getMessage());
            }

            ## if error exits then return back
            if (!empty($response)) {
                return $response;
            } else {
                return 'OK';
            }
        } else {
            return 'No subject found';
        }
    }

    ## get the attached subject with the class from the class_subject table.
    public function get__subjectsFromClassSubjectTable(ParameterBag $request)
    {
        // get the subjects by reference of class.
        return $this->class_subject_repository->getSubjects((int)$request->get('referece_'));
    }

    ## Student enrollment in the subjects
    public function student___enrollmentInSubjects(array $subjectList, ClassSessionEnrolment $ClassSessionEnrollment)
    {
        if (!is_array($subjectList)) {
            $subjectList = explode(' ', (string)$subjectList);
        }

        ## save the subjects in the class_session_enrollement_subjects table
        foreach ($subjectList as $key => $value) {

            $ClassSubject = null;

            try {
                $ClassSubject = $this->class_subject_repository->find($value);
            } catch (\Exception $exception) {
                $this->errorArray = $this->default_function->push_error($this->errorArray, $exception->getMessage());
            }

            ## if classSubject is not valid Object
            if (!$ClassSubject instanceof ClassSubject) {
                continue;
            }

            try {
                $ClassSessionEnrollmentSubject = new ClassSessionEnrolmentSubjects();
                $ClassSessionEnrollmentSubject->setNotes($ClassSessionEnrollment->getNotes());
                $ClassSessionEnrollmentSubject->setFee($ClassSessionEnrollment->getFee());
                $ClassSessionEnrollmentSubject->setClassSubject($ClassSubject);
                $ClassSessionEnrollmentSubject->setClassSessionEntrolment($ClassSessionEnrollment);

                $this->entity_manager->persist($ClassSessionEnrollmentSubject);
                $this->entity_manager->flush();
            } catch (\Exception $exception) {
                $this->errorArray = $this->default_function->push_error($this->errorArray, $exception->getMessage());
            }
        }

        ## if we have some errors then return back with the errors.
        if (empty($this->errorArray)) {
            return 'OK';
        } else {
            return $this->errorArray;
        }

    }

    ## delete student enrolment in subject.
    public function deleteStudentEnrolmentInSubject(int $ClassSubjectEnrolmentRef, Enrollments $enrollments)
    {
        $response = null;
        $ClassSubjectEnrolment = $enrollments->getClassSessionEnrolmentSubject($ClassSubjectEnrolmentRef);
        ## if subject found then delete it.
        if ($ClassSubjectEnrolment instanceof ClassSessionEnrolmentSubjects) {
            try {
                $this->entity_manager->remove($ClassSubjectEnrolment);
                $this->entity_manager->flush();
                $response = 'OK';
            } catch (ORMException $exception) {
                $response = $exception->getMessage();
            }
        } else {
            $response = $ClassSubjectEnrolment;
        }

        return $response;
    }

    ## get enrolled subject with the classes.
    ## get the enrolled classes
    public function get__enrolledSubjects(int $userID, bool $nonDeleted = false)
    {
        $response = null;
        if (!empty($userID)) {
            try {
                $response = $this->class_session_enrolment_repository->findBy(
                    [
                        'user_id' => $userID,
                        'is_deleted' => $nonDeleted,
                    ]
                );
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    /**
     * @deprecated - use getSubject() method in same class
     * */
    ## get subject object from subjects table
    ## get the exams
    public function get__Subject(int $reference)
    {
        $response = 'Invalid subject reference';
        if (!empty($reference)) {
            try {
                $response = $this->subjects_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    ## get class subject.
    public function get__ClassSubject(int $reference)
    {
        $response = 'Invalid ClassSubject reference';
        if (!empty($reference)) {
            try {
                $response = $this->class_subject_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    /**
     * BEGIN;;
     * Table Subjects
     * */

    ## before saving data in the subject table, validate the data is correct or not.
    public function validate_subject(ParameterBag $request)
    {
        $response = [];

        ## subject name
        if (empty($request->get('subject_name'))) {
            $response = $this->default_function->push_error($response, 'Please Type the subject name');
        }

        return $response;
    }

    ## add subjects in the subjects table.
    public function save__subject(ParameterBag $request)
    {
        $response = [];

        ## validate the data
        if (!empty($validation_response = $this->validate_subject($request))) {
            return $validation_response;
        }

        $subjectEntity = null;

        ## decide what to do add or edit.
        if (!empty($request->get('__hidefieldid'))) {
            ## edit an existing subject
            $subjectEntity = $this->getSubject($request->get('__hidefieldid'));
        }

        ## if not subject found then add new
        if (!$subjectEntity instanceof Subjects) {
            ## add new subject
            $subjectEntity = new Subjects();
        }


        ## duplication check.
        $bagDuplication = new ParameterBag();
        $bagDuplication->set('name', trim($request->get('subject_name')));
        $bagDuplication->set('whereNotIn', $subjectEntity->getId());
        $duplicaitonResponse = $this->subjects_repository->duplicationCheck($bagDuplication);
        if (!empty($duplicaitonResponse)) {
            $this->errorArray = $this->default_function->push_error(
                $this->errorArray,
                $request->get('subject_name').' has already exist with same name'
            );
        }

        if (!empty($this->errorArray)) {
            return $this->errorArray;
        }


        try {
            #set Subject Name, Short Name, Credit Hours, Fee amd hidden fields
            $subjectEntity->setSubjectName(trim($request->get('subject_name')));
            $subjectEntity->setShortName($request->get('subject_short_name'));
            $subjectEntity->setCredits(empty($request->get('credits')) ? null : $request->get('credits'));
            $subjectEntity->setFee(empty($request->get('subject_fee')) ? 0 : $request->get('subject_fee'));
            $subjectEntity->setMarks(empty($request->get('marks')) ? 0 : $request->get('marks'));
            $subjectEntity->setPassMarks(empty($request->get('pass_marks')) ? 0 : $request->get('pass_marks'));
            $subjectEntity->setHidden($this->default_function->parse__boolean($request->get('is_hidden')));
            $this->entity_manager->persist($subjectEntity);
            $this->entity_manager->flush();
            $response = 'OK';
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;

    }

    ## get subjects
    public function getSubject(int $id = null, string $key = null, string $value = null)
    {
        $response = null;
        try {
            if (!empty($id)) {
                $response = $this->subjects_repository->find($id);
            } else {
                if (!empty($key) && !empty($value)) {
                    $response = $this->subjects_repository->findBy([$key => $value]);
                }
            }
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;
    }

    ## delete Subjects
    public function deleteSubject(int $subjectRef, $markAsDelete = true)
    {
        $response = [];
        ## get session
        $subject = $this->getSubject($subjectRef);
        if ($subject instanceof Subjects) {
            try {


                if ($markAsDelete) {
                    ## mark as delete
                    $subject->setIsDeleted(true);
                    $subject->setHidden(1);
                    $this->entity_manager->flush();
                    $response = 'OK';
                } else {


                    $classSubject = count($subject->getClassSubjectTemplates()->toArray());
                    if ($classSubject > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            'This subject has attached with '.$classSubject.' Class'
                        );
                        $response = $this->default_function->push_error(
                            $response,
                            'Please delete related class template before deleting the Subject'
                        );
                    }

                    if (empty($response)) {
                        ## remove from database
                        $this->entity_manager->remove($subject);
                        $this->entity_manager->flush();
                        $response = 'OK';
                    }
                }

            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        } else {
            $response = $subject;
        }

        return $response;
    }

    ## list of subjects
    public function listOfSubjects()
    {
        ## get details from settings
        $showDeleteRecords = $this->appSettings->getAppSettingsFromSessions('show_deleted_records');

        return $this->subjects_repository->listOfSubjects(
            $this->default_function->parse__YesNoToBoolean($showDeleteRecords)
        );
    }


    /**
     * END;;
     * Table Subjects
     * */

    /**
     * BEGIN;;
     *  ClassSubject
     *
     * @param int $classSubject
     * @param bool $markAsDelete
     * @return array|mixed|string
     */

    ## delete Class Subject
    public function deleteClassSubject(int $classSubject, bool $markAsDelete)
    {
        $response = [];
        $ClassSubject = $this->get__ClassSubject($classSubject);
        if ($ClassSubject instanceof ClassSubject) {
            try {
                if ($markAsDelete) {
                    ## mark as delete
                    $ClassSubject->setIsDeleted(true);
                    $this->entity_manager->persist($ClassSubject);
                    $this->entity_manager->flush();
                    $response = 'OK';
                } else {

                    $ClassSessionEnrolmentSubject = count($ClassSubject->getClassSessionEnrolmentSubject()->toArray());
                    if ($ClassSessionEnrolmentSubject > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            'This subject has enrol in '.$ClassSessionEnrolmentSubject.' classes'
                        );

                    }
                    $ClassExams = count($ClassSubject->getExamsClasses()->toArray());
                    if ($ClassExams > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            'This subject has used in '.$ClassExams.' exams'
                        );
                    }

                    $ClassExamsStudent = count($ClassSubject->getExamsClassesStudents()->toArray());
                    if ($ClassExamsStudent > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            $ClassExamsStudent.'  students has passed out in this subject exams'
                        );
                    }

                    if (!empty($response)) {
                        $response = $this->default_function->push_error(
                            $response,
                            'Please delete above mentioned delete to delete this one'
                        );
                    } else {
                        ## remove from database
                        $this->entity_manager->remove($ClassSubject);
                        $this->entity_manager->flush();
                        $response = 'OK';
                    }
                }

            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }

        } else {
            $response = $ClassSubject;
        }

        return $response;
    }

    /**
     * @param Classes $classes
     * @param bool $markAsDelete
     * @return string
     * ## bulk delete class subject
     * ## single class has attached to multiple subject so, if we gone delete the class we have to delete all subject related to this one.
     * ## so basically this method is used to delete the classSubject by reference of Classes
     */
    public function bulkDeleteClassSubjectByClassRef(Classes $classes, $markAsDelete = true)
    {
        /** @var Classes $classes */
        $classSubjectArray = $classes->getClassSubject()->toArray();
        $response = [];
        /** @var ClassSubjectTemplate $value */
        foreach ($classSubjectArray as $key => $value) {
            $response = $this->default_function->push_error(
                $response,
                $this->deleteClassSubject($value->getId(), $markAsDelete)
            );
        }

        return $this->default_function->purify_success_error_response_in_bulk_operation($response);
    }

    ## list of Class Subjects subjects
    public function listOfClassSubjects(ParameterBag $bag = null)
    {

        ## get details from settings
        $showDeleteRecords = $this->appSettings->getAppSettingsFromSessions('show_deleted_records');

        return $this->class_subject_repository->listOfClassSubject(
            $this->default_function->parse__YesNoToBoolean($showDeleteRecords),
            $bag
        );
    }

    ## add Subjects in Class Subject table
    public function addSubjectInClassSubjectTable($subjects, ?Classes $Classes)
    {
        ## if fee list is empty
        if (empty($subjects)) {
            return 'Invalid input';
        }

        ## if fee list is not an array then make it array
        if (!is_array($subjects)) {
            $subjects = explode(' ', $subjects);
        }


        ## save data in the table.
        foreach ($subjects as $key => $value) {
            try {

                ## Get Class Fee
                $ClassSubject = $this->entity_manager->getRepository('App:ClassSubject')->findBy(
                    [
                        'classes__' => $Classes->getId(),
                        'is_deleted' => 0,
                        'subject' => $value,
                    ]
                );

                if ($ClassSubject instanceof ClassSubject || (is_array($ClassSubject) && !empty($ClassSubject))) {
                    ## if Class Subjects already found
                    continue;
                } else {
                    $ClassSubjectTemplate = $this->entity_manager->getRepository('App:ClassSubjectTemplate')->findBy(
                        [
                            'subject__' => $value,
                            'class_template__' => $Classes->getClassTemplate()->getId(),
                            'is_deleted' => 0,
                        ]
                    );

                    ## Class Fee Template Found,, now add Class Student Fee as Class Fee
                    /** @var Subjects $Subject */
                    $Subject = $this->getSubject($value);
                    if (!$ClassSubjectTemplate instanceof ClassSubjectTemplate) {
                        ## If Class Fee Template is not found - then save it into database
                        $ClassSubjectTemplate = new ClassSubjectTemplate();
                        $ClassSubjectTemplate->setIsDeleted($Subject->getIsDeleted());
                        $ClassSubjectTemplate->setHidden(false);
                        $ClassSubjectTemplate->setClassTemplate($Classes->getClassTemplate());
                        $ClassSubjectTemplate->setCredits($Subject->getCredits());
                        $ClassSubjectTemplate->setShortName($Subject->getShortName());
                        $ClassSubjectTemplate->setSubjectName($Subject->getSubjectName());
                        $ClassSubjectTemplate->setFee($Subject->getFee());
                        $ClassSubjectTemplate->setSubject($Subject);
                        $ClassSubjectTemplate->setPassMarks($Subject->getPassMarks());
                        $ClassSubjectTemplate->setMarks($Subject->getMarks());
                        $this->entity_manager->persist($ClassSubjectTemplate);
                        $this->entity_manager->flush();
                    }

                    if ($Subject instanceof Subjects) {
                        ## if Student fee found then save all things into ClassFee.
                        $ClassSubject = new ClassSubject();
                        $ClassSubject->setIsDeleted($ClassSubjectTemplate->getIsDeleted());
                        $ClassSubject->setClassSubjectTemplate($ClassSubjectTemplate);
                        $ClassSubject->setClasses($Classes);
                        $ClassSubject->setShortName($ClassSubjectTemplate->getShortName());
                        $ClassSubject->setSubjectName($ClassSubjectTemplate->getSubjectName());
                        $ClassSubject->setFee($ClassSubjectTemplate->getFee());
                        $ClassSubject->setCredits($ClassSubjectTemplate->getCredits());
                        $ClassSubject->setPassMarks($ClassSubjectTemplate->getPassMarks());
                        $ClassSubject->setMarks($ClassSubjectTemplate->getMarks());
                        $ClassSubject->setSubject($Subject);
                        $this->entity_manager->persist($ClassSubject);
                        $this->entity_manager->flush();
                    }
                }
            } catch (\Exception $exception) {
                $this->errorArray = $this->default_function->push_error($this->errorArray, $exception->getMessage());
            }
        }

        ## sent back error, if we have it.
        if (empty($this->errorArray)) {
            return $this->errorArray;
        }
    }

    /**
     * END;;
     * ClassSubject
     * */


}
