<?php

/**
 * PURPOSE: When adding or editing fee changes will appear in this table, this is base table of fee.
 *
 * */


namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\StudentFeeRepository")
 */
class StudentFee
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $recurring;

    /**
     * @ORM\Column(type="string", length=50)
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $amount;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     *
     * 1 mean is at the time of admission and 2 meaning is at the custom date
     */
    private $charget_at;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassFeeTemplate", mappedBy="fee")
     */
    private $classFeeTemplates;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassFee", mappedBy="fee")
     */
    private $classFees;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassFeeSchedule", mappedBy="student_fee")
     */
    private $classFeeSchedules;

    /**
     * @ORM\Column(type="boolean")
     * 1 means charge fee at admission time.
     * 0 means any time
     */
    private $is_charged_at_admission_time;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;


    public function __construct()
    {
        $this->classFeeTemplates = new ArrayCollection();
        $this->classFees = new ArrayCollection();
        $this->classFeeSchedules = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getRecurring(): ?bool
    {
        return $this->recurring;
    }

    public function setRecurring(?bool $recurring): self
    {
        $this->recurring = $recurring;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(?float $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getChargetAt(): ?int
    {
        return $this->charget_at;
    }

    public function setChargetAt(?int $charget_at): self
    {
        $this->charget_at = $charget_at;

        return $this;
    }

    /**
     * @return Collection|ClassFeeTemplate[]
     */
    public function getClassFeeTemplates(): Collection
    {
        return $this->classFeeTemplates;
    }

    public function addClassFeeTemplate(ClassFeeTemplate $classFeeTemplate): self
    {
        if (!$this->classFeeTemplates->contains($classFeeTemplate)) {
            $this->classFeeTemplates[] = $classFeeTemplate;
            $classFeeTemplate->setFee($this);
        }

        return $this;
    }

    public function removeClassFeeTemplate(ClassFeeTemplate $classFeeTemplate): self
    {
        if ($this->classFeeTemplates->contains($classFeeTemplate)) {
            $this->classFeeTemplates->removeElement($classFeeTemplate);
            // set the owning side to null (unless already changed)
            if ($classFeeTemplate->getFee() === $this) {
                $classFeeTemplate->setFee(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassFee[]
     */
    public function getClassFees(): Collection
    {
        return $this->classFees;
    }

    public function addClassFee(ClassFee $classFee): self
    {
        if (!$this->classFees->contains($classFee)) {
            $this->classFees[] = $classFee;
            $classFee->setFee($this);
        }

        return $this;
    }

    public function removeClassFee(ClassFee $classFee): self
    {
        if ($this->classFees->contains($classFee)) {
            $this->classFees->removeElement($classFee);
            // set the owning side to null (unless already changed)
            if ($classFee->getFee() === $this) {
                $classFee->setFee(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassFeeSchedule[]
     */
    public function getClassFeeSchedules(): Collection
    {
        return $this->classFeeSchedules;
    }

    public function addClassFeeSchedule(ClassFeeSchedule $classFeeSchedule): self
    {
        if (!$this->classFeeSchedules->contains($classFeeSchedule)) {
            $this->classFeeSchedules[] = $classFeeSchedule;
            $classFeeSchedule->setStudentFee($this);
        }

        return $this;
    }

    public function removeClassFeeSchedule(ClassFeeSchedule $classFeeSchedule): self
    {
        if ($this->classFeeSchedules->contains($classFeeSchedule)) {
            $this->classFeeSchedules->removeElement($classFeeSchedule);
            // set the owning side to null (unless already changed)
            if ($classFeeSchedule->getStudentFee() === $this) {
                $classFeeSchedule->setStudentFee(null);
            }
        }

        return $this;
    }

    public function getIsChargedAtAdmissionTime(): ?bool
    {
        return $this->is_charged_at_admission_time;
    }

    public function setIsChargedAtAdmissionTime(bool $is_charged_at_admission_time): self
    {
        $this->is_charged_at_admission_time = $is_charged_at_admission_time;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

}
