<?php

namespace App\DataFixtures;

use App\Entity\SAnswersRegardingCF;
use App\Repository\WhoCanUpdateCustomFieldRepository;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;

class WhoCanUpdateCustomField extends Fixture implements DependentFixtureInterface {

	private $faker;

	public function load( ObjectManager $manager ) {


		$this->faker = Factory::create();
		for ( $x = 0; $x < 10; $x ++ ) {

			$sanswer = new \App\Entity\WhoCanUpdateCustomField();
			$sanswer->addCustomFieldRef( $this->getReference( CustomFieldFixtures::CustomFieldRference . '_' . $x ) );
			$sanswer->addUserReference( $this->getReference( UserFixtures::UserFixtureReference . $x ) );

			$manager->persist( $sanswer );
		}

		$manager->flush();
	}

	/**
	 * This method must return an array of fixtures classes
	 * on which the implementing class depends on
	 *
	 * @return array
	 */
	public function getDependencies() {
		// TODO: Implement getDependencies() method.
		return [ UserFixtures::class, CustomFieldFixtures::class ];
	}
}
