"use strict";
import {select_initializer} from "../libraries/select2";
import {datepicker_initializer} from "../libraries/datepicker";
import {timepicker_initializer} from "../libraries/timepicker";
import {DashBoard} from "../dashboard__";
import {BaseFile} from "../base";


class scheduleMessage {
    constructor() {
    }

    static Initialize = () => {
        select_initializer.simpleSelect2();
        datepicker_initializer.basic();
        timepicker_initializer.basic();
    }


    // sending ajax request.
    static ajaxHandler = (Object, absoulteUrl = BaseFile.getPageUrl(), callBackFunction = null) => {
        // show all message before sending any other request.
        BaseFile.removeServerResponse();

        $.ajax({
            method: 'POST',
            data: Object.dataToSend,
            url: absoulteUrl + '?query=' + Object.sendTo,
            success: function (data) {
                scheduleMessage.post_ajax(Object, data, callBackFunction);
                if (data.status === 'OK') {
                    BaseFile.handleRemoteAjaxResponse('OK');
                } else {
                    BaseFile.handleRemoteAjaxResponse(data);
                }
            }, error: function (err) {
                BaseFile.invalidAjaxRequest(err);
            }

        });
    };

    static post_ajax = (Object, dataFromServerReponse, callBackFunction) => {
        // replace subject dropdown with the new one..
        if (Object.sendTo === 'getTheSubjectsOfClass') {
            $('.subject__placement').html(dataFromServerReponse.substr(17));
            select_initializer.simpleSelect2();
        }

        if (typeof callBackFunction === 'function') {
            callBackFunction();
        }
        DashBoard.removeLoader();
    };


}


// when class is initialized.
$(function () {
    // initialize page.
    scheduleMessage.Initialize();


    // load subject when class dropdown has changed some value.
    $(document).on('change', 'select[name=exC__cLs]', function () {
        DashBoard.showLoader();
        let Object = {
            dataToSend: {
                // id of select2 which is selected.
                referece_: $(this).val(),
                // there is button which is used to remove the subject if user want, hide this button from the ui because we are not providing multiple adding options.
                enable_removal: true,
                // show simple select2 expect multiple.
                use___classes: 'notEmpty',
                // what should be the name of the select tag
                select__name: $(this).attr('data-target-sub'),
                multiselect: true,
            },
            sendTo: 'getTheSubjectsOfClass',
        };
        // send the data object with the different controller.
        scheduleMessage.ajaxHandler(Object, $('.usC__q__s').attr('data-path'));
    });

});
